/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.scm.container.placement.metrics.DatanodeMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;

public class SCMNodeMetric
implements DatanodeMetric<SCMNodeStat, Long> {
    private SCMNodeStat stat;

    public SCMNodeMetric(SCMNodeStat stat) {
        this.stat = stat;
    }

    @VisibleForTesting
    public SCMNodeMetric(long capacity, long used, long remaining, long committed, long freeSpaceToSpare) {
        this.stat = new SCMNodeStat();
        this.stat.set(capacity, used, remaining, committed, freeSpaceToSpare);
    }

    @Override
    public boolean isGreater(SCMNodeStat o) {
        Preconditions.checkNotNull((Object)this.stat, (Object)"Argument cannot be null");
        Preconditions.checkNotNull((Object)o, (Object)"Argument cannot be null");
        long thisDenominator = this.stat.getCapacity().get() == 0L ? 1L : this.stat.getCapacity().get();
        long otherDenominator = o.getCapacity().get() == 0L ? 1L : o.getCapacity().get();
        float thisNodeWeight = (float)this.stat.getScmUsed().get().longValue() / (float)thisDenominator;
        float oNodeWeight = (float)o.getScmUsed().get().longValue() / (float)otherDenominator;
        if ((double)Math.abs(thisNodeWeight - oNodeWeight) > 1.0E-6) {
            return thisNodeWeight > oNodeWeight;
        }
        return this.stat.getScmUsed().isGreater(o.getScmUsed().get());
    }

    @Override
    public boolean isLess(SCMNodeStat o) {
        Preconditions.checkNotNull((Object)o, (Object)"Argument cannot be null");
        long thisDenominator = this.stat.getCapacity().get() == 0L ? 1L : this.stat.getCapacity().get();
        long otherDenominator = o.getCapacity().get() == 0L ? 1L : o.getCapacity().get();
        float thisNodeWeight = (float)this.stat.getScmUsed().get().longValue() / (float)thisDenominator;
        float oNodeWeight = (float)o.getScmUsed().get().longValue() / (float)otherDenominator;
        if ((double)Math.abs(thisNodeWeight - oNodeWeight) > 1.0E-6) {
            return thisNodeWeight < oNodeWeight;
        }
        return this.stat.getScmUsed().isLess(o.getScmUsed().get());
    }

    @Override
    public boolean isEqual(SCMNodeStat o) {
        float oNodeWeight;
        float thisNodeWeight = (float)this.stat.getScmUsed().get().longValue() / (float)this.stat.getCapacity().get().longValue();
        return (double)Math.abs(thisNodeWeight - (oNodeWeight = (float)o.getScmUsed().get().longValue() / (float)o.getCapacity().get().longValue())) < 1.0E-6;
    }

    @Override
    public boolean hasResources(Long resourceNeeded) {
        return false;
    }

    @Override
    public SCMNodeStat get() {
        return this.stat;
    }

    @Override
    public void set(SCMNodeStat value) {
        this.stat.set(value.getCapacity().get(), value.getScmUsed().get(), value.getRemaining().get(), value.getCommitted().get(), value.getFreeSpaceToSpare().get());
    }

    @Override
    public void add(SCMNodeStat value) {
        this.stat.add(value);
    }

    @Override
    public void subtract(SCMNodeStat value) {
        this.stat.subtract(value);
    }

    public int compareTo(SCMNodeStat o) {
        if (this.isEqual(o)) {
            return 0;
        }
        if (this.isGreater(o)) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCMNodeMetric that = (SCMNodeMetric)o;
        return this.stat != null ? this.stat.equals(that.stat) : that.stat == null;
    }

    public int hashCode() {
        return this.stat != null ? this.stat.hashCode() : 0;
    }
}

