/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.util.concurrent.Striped;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaPendingOpsSubscriber;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerMetrics;

public class ContainerReplicaPendingOps {
    private static final int RATIS_COUNTER_INDEX = 0;
    private static final int EC_COUNTER_INDEX = 1;
    private final Clock clock;
    private final ConcurrentHashMap<ContainerID, List<ContainerReplicaOp>> pendingOps = new ConcurrentHashMap();
    private final Striped<ReadWriteLock> stripedLock = Striped.readWriteLock((int)64);
    private final ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<ContainerReplicaOp.PendingOpType, AtomicLong[]> pendingOpCount = new ConcurrentHashMap();
    private ReplicationManagerMetrics replicationMetrics = null;
    private final List<ContainerReplicaPendingOpsSubscriber> subscribers = new ArrayList<ContainerReplicaPendingOpsSubscriber>();

    public ContainerReplicaPendingOps(Clock clock) {
        this.clock = clock;
        this.resetCounters();
    }

    private void resetCounters() {
        for (ContainerReplicaOp.PendingOpType opType : ContainerReplicaOp.PendingOpType.values()) {
            AtomicLong[] counters = new AtomicLong[]{new AtomicLong(0L), new AtomicLong(0L)};
            this.pendingOpCount.put(opType, counters);
        }
    }

    public void clear() {
        this.globalLock.writeLock().lock();
        try {
            this.pendingOps.clear();
            this.resetCounters();
        }
        finally {
            this.globalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerReplicaOp> getPendingOps(ContainerID containerID) {
        Lock lock = this.readLock(containerID);
        this.lock(lock);
        try {
            List<ContainerReplicaOp> ops = this.pendingOps.get(containerID);
            if (ops == null) {
                List<ContainerReplicaOp> list = Collections.emptyList();
                return list;
            }
            ArrayList<ContainerReplicaOp> arrayList = new ArrayList<ContainerReplicaOp>(ops);
            return arrayList;
        }
        finally {
            this.unlock(lock);
        }
    }

    public void scheduleAddReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex, long deadlineEpochMillis) {
        this.addReplica(ContainerReplicaOp.PendingOpType.ADD, containerID, target, replicaIndex, deadlineEpochMillis);
    }

    public void scheduleDeleteReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex, long deadlineEpochMillis) {
        this.addReplica(ContainerReplicaOp.PendingOpType.DELETE, containerID, target, replicaIndex, deadlineEpochMillis);
    }

    public boolean completeAddReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex) {
        boolean completed = this.completeOp(ContainerReplicaOp.PendingOpType.ADD, containerID, target, replicaIndex);
        if (this.isMetricsNotNull() && completed) {
            if (this.isEC(replicaIndex)) {
                this.replicationMetrics.incrEcReplicasCreatedTotal();
            } else {
                this.replicationMetrics.incrReplicasCreatedTotal();
            }
        }
        return completed;
    }

    public boolean completeDeleteReplica(ContainerID containerID, DatanodeDetails target, int replicaIndex) {
        boolean completed = this.completeOp(ContainerReplicaOp.PendingOpType.DELETE, containerID, target, replicaIndex);
        if (this.isMetricsNotNull() && completed) {
            if (this.isEC(replicaIndex)) {
                this.replicationMetrics.incrEcReplicasDeletedTotal();
            } else {
                this.replicationMetrics.incrReplicasDeletedTotal();
            }
        }
        return completed;
    }

    public boolean removeOp(ContainerID containerID, ContainerReplicaOp op) {
        return this.completeOp(op.getOpType(), containerID, op.getTarget(), op.getReplicaIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExpiredEntries() {
        for (ContainerID containerID : this.pendingOps.keySet()) {
            ArrayList<ContainerReplicaOp> expiredOps;
            block6: {
                expiredOps = new ArrayList<ContainerReplicaOp>();
                Lock lock = this.writeLock(containerID);
                this.lock(lock);
                try {
                    List<ContainerReplicaOp> ops = this.pendingOps.get(containerID);
                    if (ops == null) continue;
                    ListIterator<ContainerReplicaOp> iterator = ops.listIterator();
                    while (iterator.hasNext()) {
                        ContainerReplicaOp op = (ContainerReplicaOp)iterator.next();
                        if (this.clock.millis() <= op.getDeadlineEpochMillis()) continue;
                        iterator.remove();
                        expiredOps.add(op);
                        this.decrementCounter(op.getOpType(), op.getReplicaIndex());
                        this.updateTimeoutMetrics(op);
                    }
                    if (ops.size() != 0) break block6;
                    this.pendingOps.remove(containerID);
                }
                finally {
                    this.unlock(lock);
                    continue;
                }
            }
            if (expiredOps.isEmpty()) continue;
            this.notifySubscribers(expiredOps, containerID, true);
        }
    }

    private void updateTimeoutMetrics(ContainerReplicaOp op) {
        if (op.getOpType() == ContainerReplicaOp.PendingOpType.ADD && this.isMetricsNotNull()) {
            if (this.isEC(op.getReplicaIndex())) {
                this.replicationMetrics.incrEcReplicaCreateTimeoutTotal();
            } else {
                this.replicationMetrics.incrReplicaCreateTimeoutTotal();
            }
        } else if (op.getOpType() == ContainerReplicaOp.PendingOpType.DELETE && this.isMetricsNotNull()) {
            if (this.isEC(op.getReplicaIndex())) {
                this.replicationMetrics.incrEcReplicaDeleteTimeoutTotal();
            } else {
                this.replicationMetrics.incrReplicaDeleteTimeoutTotal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplica(ContainerReplicaOp.PendingOpType opType, ContainerID containerID, DatanodeDetails target, int replicaIndex, long deadlineEpochMillis) {
        Lock lock = this.writeLock(containerID);
        this.lock(lock);
        try {
            List ops = this.pendingOps.computeIfAbsent(containerID, s -> new ArrayList());
            ops.add(new ContainerReplicaOp(opType, target, replicaIndex, deadlineEpochMillis));
            this.incrementCounter(opType, replicaIndex);
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean completeOp(ContainerReplicaOp.PendingOpType opType, ContainerID containerID, DatanodeDetails target, int replicaIndex) {
        boolean found = false;
        ArrayList<ContainerReplicaOp> completedOps = new ArrayList<ContainerReplicaOp>();
        Lock lock = this.writeLock(containerID);
        this.lock(lock);
        try {
            List<ContainerReplicaOp> ops = this.pendingOps.get(containerID);
            if (ops != null) {
                ListIterator<ContainerReplicaOp> iterator = ops.listIterator();
                while (iterator.hasNext()) {
                    ContainerReplicaOp op = (ContainerReplicaOp)iterator.next();
                    if (op.getOpType() != opType || !op.getTarget().equals((Object)target) || op.getReplicaIndex() != replicaIndex) continue;
                    found = true;
                    completedOps.add(op);
                    iterator.remove();
                    this.decrementCounter(op.getOpType(), replicaIndex);
                }
                if (ops.size() == 0) {
                    this.pendingOps.remove(containerID);
                }
            }
        }
        finally {
            this.unlock(lock);
        }
        if (found) {
            this.notifySubscribers(completedOps, containerID, false);
        }
        return found;
    }

    private void notifySubscribers(List<ContainerReplicaOp> ops, ContainerID containerID, boolean timedOut) {
        for (ContainerReplicaOp op : ops) {
            for (ContainerReplicaPendingOpsSubscriber subscriber : this.subscribers) {
                subscriber.opCompleted(op, containerID, timedOut);
            }
        }
    }

    public void registerSubscriber(ContainerReplicaPendingOpsSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    private Lock writeLock(ContainerID containerID) {
        return ((ReadWriteLock)this.stripedLock.get((Object)containerID)).writeLock();
    }

    private Lock readLock(ContainerID containerID) {
        return ((ReadWriteLock)this.stripedLock.get((Object)containerID)).readLock();
    }

    private void lock(Lock lock) {
        this.globalLock.readLock().lock();
        lock.lock();
    }

    private void unlock(Lock lock) {
        this.globalLock.readLock().unlock();
        lock.unlock();
    }

    private boolean isMetricsNotNull() {
        return this.replicationMetrics != null;
    }

    public void setReplicationMetrics(ReplicationManagerMetrics replicationMetrics) {
        this.replicationMetrics = replicationMetrics;
    }

    public long getPendingOpCount(ContainerReplicaOp.PendingOpType opType) {
        AtomicLong[] counters = this.pendingOpCount.get((Object)opType);
        long count = 0L;
        for (AtomicLong counter : counters) {
            count += counter.get();
        }
        return count;
    }

    public long getPendingOpCount(ContainerReplicaOp.PendingOpType opType, ReplicationType type) {
        int index = 0;
        if (type == ReplicationType.EC) {
            index = 1;
        }
        return this.pendingOpCount.get((Object)opType)[index].get();
    }

    private long incrementCounter(ContainerReplicaOp.PendingOpType type, int replicaIndex) {
        return this.pendingOpCount.get((Object)type)[this.counterIndex(replicaIndex)].incrementAndGet();
    }

    private long decrementCounter(ContainerReplicaOp.PendingOpType type, int replicaIndex) {
        return this.pendingOpCount.get((Object)type)[this.counterIndex(replicaIndex)].decrementAndGet();
    }

    private int counterIndex(int replicaIndex) {
        if (this.isEC(replicaIndex)) {
            return 1;
        }
        return 0;
    }

    private boolean isEC(int replicaIndex) {
        return replicaIndex > 0;
    }
}

