/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.CommandTargetOverloadedException;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerMetrics;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManagerUtil;
import org.apache.hadoop.hdds.scm.container.replication.UnhealthyReplicationHandler;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.InsufficientDatanodesException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MisReplicationHandler
implements UnhealthyReplicationHandler {
    public static final Logger LOG = LoggerFactory.getLogger(MisReplicationHandler.class);
    private final PlacementPolicy containerPlacement;
    private final long currentContainerSize;
    private final ReplicationManager replicationManager;
    private final ReplicationManagerMetrics metrics;

    public MisReplicationHandler(PlacementPolicy containerPlacement, ConfigurationSource conf, ReplicationManager replicationManager) {
        this.containerPlacement = containerPlacement;
        this.currentContainerSize = (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
        this.replicationManager = replicationManager;
        this.metrics = replicationManager.getMetrics();
    }

    protected ReplicationManager getReplicationManager() {
        return this.replicationManager;
    }

    protected abstract ContainerReplicaCount getContainerReplicaCount(ContainerInfo var1, Set<ContainerReplica> var2, List<ContainerReplicaOp> var3, int var4) throws IOException;

    private Set<ContainerReplica> filterSources(Set<ContainerReplica> replicas) {
        return replicas.stream().filter(r -> r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.CLOSED || r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED).filter(r -> {
            try {
                return this.replicationManager.getNodeStatus(r.getDatanodeDetails()).isHealthy();
            }
            catch (NodeNotFoundException e) {
                return false;
            }
        }).filter(r -> r.getDatanodeDetails().getPersistedOpState() == HddsProtos.NodeOperationalState.IN_SERVICE).collect(Collectors.toSet());
    }

    protected abstract int sendReplicateCommands(ContainerInfo var1, Set<ContainerReplica> var2, List<DatanodeDetails> var3, List<DatanodeDetails> var4) throws CommandTargetOverloadedException, NotLeaderException;

    @Override
    public int processAndSendCommands(Set<ContainerReplica> replicas, List<ContainerReplicaOp> pendingOps, ContainerHealthResult result, int remainingMaintenanceRedundancy) throws IOException {
        ContainerInfo container = result.getContainerInfo();
        if (!pendingOps.isEmpty()) {
            LOG.info("Skipping Mis-Replication for Container {}, as there are still some pending ops for the container: {}", (Object)container, pendingOps);
            return 0;
        }
        ContainerReplicaCount replicaCount = this.getContainerReplicaCount(container, replicas, Collections.emptyList(), remainingMaintenanceRedundancy);
        if (!replicaCount.isSufficientlyReplicated() || replicaCount.isOverReplicated()) {
            LOG.info("Container {} state should be neither under replicated nor over replicated before resolving misreplication.Container UnderReplication status: {},Container OverReplication status: {}", new Object[]{container.getContainerID(), !replicaCount.isSufficientlyReplicated(), replicaCount.isOverReplicated()});
            return 0;
        }
        List<DatanodeDetails> usedDns = replicas.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        if (this.containerPlacement.validateContainerPlacement(usedDns, usedDns.size()).isPolicySatisfied()) {
            LOG.info("Container {} is currently not misreplicated", (Object)container.getContainerID());
            return 0;
        }
        LOG.debug("Handling mis replicated container {}.", (Object)container);
        Set<ContainerReplica> sources = this.filterSources(replicas);
        Set<ContainerReplica> replicasToBeReplicated = this.containerPlacement.replicasToCopyToFixMisreplication(replicas.stream().collect(Collectors.toMap(Function.identity(), sources::contains)));
        ReplicationManagerUtil.ExcludedAndUsedNodes excludedAndUsedNodes = ReplicationManagerUtil.getExcludedAndUsedNodes(container, new ArrayList<ContainerReplica>(replicas), replicasToBeReplicated, Collections.emptyList(), this.replicationManager);
        int requiredNodes = replicasToBeReplicated.size();
        List<DatanodeDetails> targetDatanodes = ReplicationManagerUtil.getTargetDatanodes(this.containerPlacement, requiredNodes, excludedAndUsedNodes.getUsedNodes(), excludedAndUsedNodes.getExcludedNodes(), this.currentContainerSize, container);
        List<DatanodeDetails> availableSources = sources.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        int count = this.sendReplicateCommands(container, replicasToBeReplicated, availableSources, targetDatanodes);
        int found = targetDatanodes.size();
        if (found < requiredNodes) {
            if (container.getReplicationType() == HddsProtos.ReplicationType.EC) {
                this.metrics.incrEcPartialReplicationForMisReplicationTotal();
            } else {
                this.metrics.incrPartialReplicationForMisReplicationTotal();
            }
            LOG.warn("Placement Policy {} found only {} nodes for Container: {}, number of required nodes: {}, usedNodes : {}", new Object[]{this.containerPlacement.getClass(), found, container.getContainerID(), requiredNodes, usedDns});
            throw new InsufficientDatanodesException(requiredNodes, found);
        }
        return count;
    }
}

