/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import com.google.common.collect.Queues;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;

public class ReplicationQueue {
    private final Queue<ContainerHealthResult.UnderReplicatedHealthResult> underRepQueue = Queues.synchronizedQueue(new PriorityQueue<ContainerHealthResult.UnderReplicatedHealthResult>(Comparator.comparing(ContainerHealthResult.UnderReplicatedHealthResult::getWeightedRedundancy).thenComparing(ContainerHealthResult.UnderReplicatedHealthResult::getRequeueCount)));
    private final Queue<ContainerHealthResult.OverReplicatedHealthResult> overRepQueue = Queues.synchronizedQueue(new LinkedList());

    public void enqueue(ContainerHealthResult.UnderReplicatedHealthResult underReplicatedHealthResult) {
        underReplicatedHealthResult.incrementRequeueCount();
        this.underRepQueue.add(underReplicatedHealthResult);
    }

    public void enqueue(ContainerHealthResult.OverReplicatedHealthResult overReplicatedHealthResult) {
        this.overRepQueue.add(overReplicatedHealthResult);
    }

    public ContainerHealthResult.UnderReplicatedHealthResult dequeueUnderReplicatedContainer() {
        return this.underRepQueue.poll();
    }

    public ContainerHealthResult.OverReplicatedHealthResult dequeueOverReplicatedContainer() {
        return this.overRepQueue.poll();
    }

    public int underReplicatedQueueSize() {
        return this.underRepQueue.size();
    }

    public int overReplicatedQueueSize() {
        return this.overRepQueue.size();
    }
}

