/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.RatisContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerableUnhealthyReplicasHandler
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(VulnerableUnhealthyReplicasHandler.class);
    private final ReplicationManager replicationManager;

    public VulnerableUnhealthyReplicasHandler(ReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        ContainerInfo container = request.getContainerInfo();
        if (container.getReplicationType() != HddsProtos.ReplicationType.RATIS) {
            return false;
        }
        if (container.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED) {
            return false;
        }
        Set<ContainerReplica> replicas = request.getContainerReplicas();
        LOG.debug("Checking whether container {} with replicas {} has vulnerable UNHEALTHY replicas.", (Object)container, replicas);
        RatisContainerReplicaCount replicaCount = new RatisContainerReplicaCount(container, replicas, request.getPendingOps(), request.getMaintenanceRedundancy(), true);
        List<ContainerReplica> vulnerableUnhealthy = replicaCount.getVulnerableUnhealthyReplicas(dn -> {
            try {
                return this.replicationManager.getNodeStatus((DatanodeDetails)dn);
            }
            catch (NodeNotFoundException e) {
                LOG.warn("Exception for datanode {} while handling vulnerable replicas for container {}, with all replicas {}.", new Object[]{dn, container, replicaCount.getReplicas(), e});
                return null;
            }
        });
        if (!vulnerableUnhealthy.isEmpty()) {
            LOG.info("Found vulnerable UNHEALTHY replicas {} for container {}.", vulnerableUnhealthy, (Object)container);
            ReplicationManagerReport report = request.getReport();
            report.incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, container.containerID());
            if (!request.isReadOnly()) {
                ContainerHealthResult.UnderReplicatedHealthResult underRepResult = replicaCount.toUnderHealthResult();
                underRepResult.setHasVulnerableUnhealthy(true);
                request.getReplicationQueue().enqueue(underRepResult);
            }
            return true;
        }
        return false;
    }
}

