/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.protocol.scm.proto.InterSCMProtocolProtos;
import org.apache.hadoop.hdds.protocol.scm.proto.InterSCMProtocolServiceGrpc;
import org.apache.hadoop.hdds.scm.ha.SCMDBCheckpointProvider;
import org.apache.hadoop.hdds.scm.ha.SCMGrpcOutputStream;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterSCMGrpcService
extends InterSCMProtocolServiceGrpc.InterSCMProtocolServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(InterSCMGrpcService.class);
    private static final int BUFFER_SIZE = 0x100000;
    private final SCMDBCheckpointProvider provider;
    private final StorageContainerManager scm;
    private final Table<String, TransactionInfo> transactionInfoTable;

    InterSCMGrpcService(StorageContainerManager scm) throws IOException {
        Preconditions.checkNotNull((Object)scm);
        this.scm = scm;
        this.transactionInfoTable = HAUtils.getTransactionInfoTable((DBStore)scm.getScmMetadataStore().getStore(), (DBDefinition)new SCMDBDefinition());
        this.provider = new SCMDBCheckpointProvider(scm.getScmMetadataStore().getStore());
    }

    public void download(InterSCMProtocolProtos.CopyDBCheckpointRequestProto request, StreamObserver<InterSCMProtocolProtos.CopyDBCheckpointResponseProto> responseObserver) {
        try {
            this.scm.getScmHAManager().asSCMHADBTransactionBuffer().flush();
            TransactionInfo transactionInfo = (TransactionInfo)this.transactionInfoTable.get((Object)"#TRANSACTIONINFO");
            Preconditions.checkNotNull((Object)transactionInfo);
            SCMGrpcOutputStream outputStream = new SCMGrpcOutputStream(responseObserver, this.scm.getClusterId(), 0x100000);
            this.provider.writeDBCheckPointToSream(outputStream, request.getFlush());
        }
        catch (IOException e) {
            LOG.error("Error streaming SCM DB checkpoint", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }
}

