/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.metadata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.io.LengthOutputStream;
import org.apache.ratis.util.function.CheckedFunction;

public final class X509CertificateCodec
implements Codec<X509Certificate> {
    private static final int INITIAL_CAPACITY = 4096;
    private static final Codec<X509Certificate> INSTANCE = new X509CertificateCodec();

    public static Codec<X509Certificate> get() {
        return INSTANCE;
    }

    private X509CertificateCodec() {
    }

    public boolean supportCodecBuffer() {
        return true;
    }

    CheckedFunction<OutputStream, Integer, IOException> writeTo(X509Certificate object) {
        return out -> ((LengthOutputStream)CertificateCodec.writePEMEncoded((X509Certificate)object, (OutputStream)new LengthOutputStream(out))).getLength();
    }

    public CodecBuffer toCodecBuffer(@Nonnull X509Certificate object, CodecBuffer.Allocator allocator) throws IOException {
        return ((CodecBuffer)allocator.apply(-4096)).put(this.writeTo(object));
    }

    public X509Certificate fromCodecBuffer(@Nonnull CodecBuffer buffer) throws IOException {
        try (InputStream in = buffer.getInputStream();){
            X509Certificate x509Certificate = CertificateCodec.readX509Certificate((InputStream)in);
            return x509Certificate;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toPersistedFormat(X509Certificate object) throws IOException {
        try (CodecBuffer buffer = this.toHeapCodecBuffer(object);){
            byte[] byArray = buffer.getArray();
            return byArray;
        }
        catch (SCMSecurityException exp) {
            throw new IOException(exp);
        }
    }

    public X509Certificate fromPersistedFormat(byte[] rawData) throws IOException {
        return CertificateCodec.readX509Certificate((InputStream)new ByteArrayInputStream(rawData));
    }

    public X509Certificate copyObject(X509Certificate object) {
        return object;
    }
}

