/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECPipelineProvider
extends PipelineProvider<ECReplicationConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(ECPipelineProvider.class);
    private final ConfigurationSource conf;
    private final PlacementPolicy placementPolicy;
    private final long containerSizeBytes;

    public ECPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf, PlacementPolicy placementPolicy) {
        super(nodeManager, stateManager);
        this.conf = conf;
        this.placementPolicy = placementPolicy;
        this.containerSizeBytes = (long)this.conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
    }

    @Override
    public synchronized Pipeline create(ECReplicationConfig replicationConfig) throws IOException {
        return this.create(replicationConfig, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    protected Pipeline create(ECReplicationConfig replicationConfig, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes) throws IOException {
        List<DatanodeDetails> dns = this.placementPolicy.chooseDatanodes(excludedNodes, favoredNodes, replicationConfig.getRequiredNodes(), 0L, this.containerSizeBytes);
        return this.create(replicationConfig, dns);
    }

    @Override
    protected Pipeline create(ECReplicationConfig replicationConfig, List<DatanodeDetails> nodes) {
        HashMap<DatanodeDetails, Integer> dnIndexes = new HashMap<DatanodeDetails, Integer>();
        int ecIndex = 1;
        for (DatanodeDetails dn : nodes) {
            dnIndexes.put(dn, ecIndex);
            ++ecIndex;
        }
        return this.createPipelineInternal(replicationConfig, nodes, dnIndexes);
    }

    @Override
    public Pipeline createForRead(ECReplicationConfig replicationConfig, Set<ContainerReplica> replicas) {
        HashMap<DatanodeDetails, Integer> map = new HashMap<DatanodeDetails, Integer>();
        ArrayList<DatanodeDetails> dns = new ArrayList<DatanodeDetails>(replicas.size());
        HashMap<DatanodeDetails, NodeStatus> nodeStatusMap = new HashMap<DatanodeDetails, NodeStatus>();
        for (ContainerReplica r : replicas) {
            DatanodeDetails dn = r.getDatanodeDetails();
            try {
                NodeStatus nodeStatus = this.getNodeManager().getNodeStatus(dn);
                if (nodeStatus.isDead()) continue;
                map.put(dn, r.getReplicaIndex());
                dns.add(dn);
                nodeStatusMap.put(dn, nodeStatus);
            }
            catch (NodeNotFoundException e) {
                LOG.error("Node not found", (Throwable)e);
            }
        }
        dns.sort(Comparator.comparing(nodeStatusMap::get));
        return this.createPipelineInternal(replicationConfig, dns, map);
    }

    private Pipeline createPipelineInternal(ECReplicationConfig repConfig, List<DatanodeDetails> dns, Map<DatanodeDetails, Integer> indexes) {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.ALLOCATED).setReplicationConfig((ReplicationConfig)repConfig).setNodes(dns).setReplicaIndexes(indexes).build();
    }

    @Override
    protected void close(Pipeline pipeline) throws IOException {
    }

    @Override
    protected void shutdown() {
    }
}

