/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocol;

import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocolScm;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecretKeyProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolDatanodePB;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolOmPB;
import org.apache.hadoop.hdds.scm.ha.RatisUtil;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.exception.SCMSecretKeyException;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.server.OzoneProtocolMessageDispatcher;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.util.ProtobufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretKeyProtocolServerSideTranslatorPB
implements SecretKeyProtocolDatanodePB,
SecretKeyProtocolOmPB {
    private static final Logger LOG = LoggerFactory.getLogger(SecretKeyProtocolServerSideTranslatorPB.class);
    private final SecretKeyProtocolScm impl;
    private final StorageContainerManager scm;
    private OzoneProtocolMessageDispatcher<SCMSecretKeyProtocolProtos.SCMSecretKeyRequest, SCMSecretKeyProtocolProtos.SCMSecretKeyResponse, ProtocolMessageEnum> dispatcher;

    public SecretKeyProtocolServerSideTranslatorPB(SecretKeyProtocolScm impl, StorageContainerManager storageContainerManager, ProtocolMessageMetrics messageMetrics) {
        this.impl = impl;
        this.scm = storageContainerManager;
        this.dispatcher = new OzoneProtocolMessageDispatcher("SCMSecretKeyProtocol", messageMetrics, LOG);
    }

    public SCMSecretKeyProtocolProtos.SCMSecretKeyResponse submitRequest(RpcController controller, SCMSecretKeyProtocolProtos.SCMSecretKeyRequest request) throws ServiceException {
        if (!this.scm.checkLeader()) {
            RatisUtil.checkRatisException((IOException)((Object)this.scm.getScmHAManager().getRatisServer().triggerNotLeaderException()), this.scm.getSecurityProtocolRpcPort(), this.scm.getScmId());
        }
        return (SCMSecretKeyProtocolProtos.SCMSecretKeyResponse)this.dispatcher.processRequest((Object)request, this::processRequest, (Object)request.getCmdType(), request.getTraceID());
    }

    public SCMSecretKeyProtocolProtos.SCMSecretKeyResponse processRequest(SCMSecretKeyProtocolProtos.SCMSecretKeyRequest request) throws ServiceException {
        SCMSecretKeyProtocolProtos.SCMSecretKeyResponse.Builder scmSecurityResponse = SCMSecretKeyProtocolProtos.SCMSecretKeyResponse.newBuilder().setCmdType(request.getCmdType()).setStatus(SCMSecretKeyProtocolProtos.Status.OK);
        try {
            switch (request.getCmdType()) {
                case GetCurrentSecretKey: {
                    return scmSecurityResponse.setCurrentSecretKeyResponseProto(this.getCurrentSecretKey()).build();
                }
                case GetSecretKey: {
                    return scmSecurityResponse.setGetSecretKeyResponseProto(this.getSecretKey(request.getGetSecretKeyRequest())).build();
                }
                case GetAllSecretKeys: {
                    return scmSecurityResponse.setSecretKeysListResponseProto(this.getAllSecretKeys()).build();
                }
                case CheckAndRotate: {
                    return scmSecurityResponse.setCheckAndRotateResponseProto(this.checkAndRotate(request.getCheckAndRotateRequest().getForce())).build();
                }
            }
            throw new IllegalArgumentException("Unknown request type: " + request.getCmdType());
        }
        catch (IOException e) {
            RatisUtil.checkRatisException(e, this.scm.getSecurityProtocolRpcPort(), this.scm.getScmId());
            scmSecurityResponse.setSuccess(false);
            scmSecurityResponse.setStatus(this.exceptionToResponseStatus(e));
            if (e.getMessage() != null) {
                scmSecurityResponse.setMessage(e.getMessage());
            } else if (e.getCause() != null && e.getCause().getMessage() != null) {
                scmSecurityResponse.setMessage(e.getCause().getMessage());
            }
            return scmSecurityResponse.build();
        }
    }

    private SCMSecretKeyProtocolProtos.SCMSecretKeysListResponse getAllSecretKeys() throws IOException {
        SCMSecretKeyProtocolProtos.SCMSecretKeysListResponse.Builder builder = SCMSecretKeyProtocolProtos.SCMSecretKeysListResponse.newBuilder();
        this.impl.getAllSecretKeys().stream().map(ManagedSecretKey::toProtobuf).forEach(arg_0 -> ((SCMSecretKeyProtocolProtos.SCMSecretKeysListResponse.Builder)builder).addSecretKeys(arg_0));
        return builder.build();
    }

    private SCMSecretKeyProtocolProtos.SCMGetSecretKeyResponse getSecretKey(SCMSecretKeyProtocolProtos.SCMGetSecretKeyRequest getSecretKeyRequest) throws IOException {
        SCMSecretKeyProtocolProtos.SCMGetSecretKeyResponse.Builder builder = SCMSecretKeyProtocolProtos.SCMGetSecretKeyResponse.newBuilder();
        UUID id = ProtobufUtils.fromProtobuf((HddsProtos.UUID)getSecretKeyRequest.getSecretKeyId());
        ManagedSecretKey secretKey = this.impl.getSecretKey(id);
        if (secretKey != null) {
            builder.setSecretKey(secretKey.toProtobuf());
        }
        return builder.build();
    }

    private SCMSecretKeyProtocolProtos.SCMGetCurrentSecretKeyResponse getCurrentSecretKey() throws IOException {
        return SCMSecretKeyProtocolProtos.SCMGetCurrentSecretKeyResponse.newBuilder().setSecretKey(this.impl.getCurrentSecretKey().toProtobuf()).build();
    }

    private SCMSecretKeyProtocolProtos.SCMGetCheckAndRotateResponse checkAndRotate(boolean force) throws IOException {
        return SCMSecretKeyProtocolProtos.SCMGetCheckAndRotateResponse.newBuilder().setStatus(this.impl.checkAndRotate(force)).build();
    }

    private SCMSecretKeyProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof SCMSecretKeyException) {
            return SCMSecretKeyProtocolProtos.Status.values()[((SCMSecretKeyException)ex).getErrorCode().ordinal()];
        }
        return SCMSecretKeyProtocolProtos.Status.INTERNAL_ERROR;
    }
}

