/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationManager;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.TypedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthyPipelineSafeModeRule
extends SafeModeExitRule<Pipeline> {
    public static final Logger LOG = LoggerFactory.getLogger(HealthyPipelineSafeModeRule.class);
    private int healthyPipelineThresholdCount;
    private int currentHealthyPipelineCount = 0;
    private final double healthyPipelinesPercent;
    private final Set<PipelineID> processedPipelineIDs = new HashSet<PipelineID>();
    private final PipelineManager pipelineManager;
    private final int minHealthyPipelines;
    private final SCMContext scmContext;

    HealthyPipelineSafeModeRule(String ruleName, EventQueue eventQueue, PipelineManager pipelineManager, SCMSafeModeManager manager, ConfigurationSource configuration, SCMContext scmContext) {
        super(manager, ruleName, eventQueue);
        this.pipelineManager = pipelineManager;
        this.scmContext = scmContext;
        this.healthyPipelinesPercent = configuration.getDouble("hdds.scm.safemode.healthy.pipeline.pct", 0.1);
        this.minHealthyPipelines = this.getMinHealthyPipelines(configuration);
        Preconditions.checkArgument((this.healthyPipelinesPercent >= 0.0 && this.healthyPipelinesPercent <= 1.0 ? 1 : 0) != 0, (Object)"hdds.scm.safemode.healthy.pipeline.pct value should be >= 0.0 and <= 1.0");
        this.initializeRule(false);
    }

    private int getMinHealthyPipelines(ConfigurationSource config) {
        int minDatanodes = config.getInt("hdds.scm.safemode.min.datanode", 1);
        return minDatanodes / 3;
    }

    @VisibleForTesting
    public synchronized void setHealthyPipelineThresholdCount(int actualPipelineCount) {
        this.healthyPipelineThresholdCount = (int)Math.ceil(this.healthyPipelinesPercent * (double)actualPipelineCount);
    }

    @Override
    protected TypedEvent<Pipeline> getEventType() {
        return SCMEvents.OPEN_PIPELINE;
    }

    @Override
    protected synchronized boolean validate() {
        boolean shouldRunSafemodeCheck = FinalizationManager.shouldCreateNewPipelines(this.scmContext.getFinalizationCheckpoint());
        if (!shouldRunSafemodeCheck) {
            LOG.info("All SCM pipelines are closed due to ongoing upgrade finalization. Bypassing healthy pipeline safemode rule.");
            return true;
        }
        return this.currentHealthyPipelineCount >= this.healthyPipelineThresholdCount;
    }

    @Override
    protected synchronized void process(Pipeline pipeline) {
        Preconditions.checkNotNull((Object)pipeline);
        if (pipeline.getType() == HddsProtos.ReplicationType.RATIS && ((RatisReplicationConfig)pipeline.getReplicationConfig()).getReplicationFactor() == HddsProtos.ReplicationFactor.THREE && !this.processedPipelineIDs.contains(pipeline.getId())) {
            this.getSafeModeMetrics().incCurrentHealthyPipelinesCount();
            ++this.currentHealthyPipelineCount;
            this.processedPipelineIDs.add(pipeline.getId());
        }
        if (this.scmInSafeMode()) {
            SCMSafeModeManager.getLogger().info("SCM in safe mode. Healthy pipelines reported count is {}, required healthy pipeline reported count is {}", (Object)this.currentHealthyPipelineCount, (Object)this.getHealthyPipelineThresholdCount());
        }
    }

    @Override
    public synchronized void refresh(boolean forceRefresh) {
        if (forceRefresh) {
            this.initializeRule(true);
        } else if (!this.validate()) {
            this.initializeRule(true);
        }
    }

    private synchronized void initializeRule(boolean refresh) {
        int pipelineCount = this.pipelineManager.getPipelines((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE), Pipeline.PipelineState.OPEN).size();
        this.healthyPipelineThresholdCount = Math.max(this.minHealthyPipelines, (int)Math.ceil(this.healthyPipelinesPercent * (double)pipelineCount));
        if (refresh) {
            LOG.info("Refreshed total pipeline count is {}, healthy pipeline threshold count is {}", (Object)pipelineCount, (Object)this.healthyPipelineThresholdCount);
        } else {
            LOG.info("Total pipeline count is {}, healthy pipeline threshold count is {}", (Object)pipelineCount, (Object)this.healthyPipelineThresholdCount);
        }
        this.getSafeModeMetrics().setNumHealthyPipelinesThreshold(this.healthyPipelineThresholdCount);
    }

    @Override
    protected synchronized void cleanup() {
        this.processedPipelineIDs.clear();
    }

    @VisibleForTesting
    public synchronized int getCurrentHealthyPipelineCount() {
        return this.currentHealthyPipelineCount;
    }

    @VisibleForTesting
    public synchronized int getHealthyPipelineThresholdCount() {
        return this.healthyPipelineThresholdCount;
    }

    @Override
    public String getStatusText() {
        return String.format("healthy Ratis/THREE pipelines (=%d) >= healthyPipelineThresholdCount (=%d)", this.getCurrentHealthyPipelineCount(), this.getHealthyPipelineThresholdCount());
    }
}

