/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.FixedThreadPoolWithAffinityExecutor;
import org.apache.hadoop.util.Time;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerReportQueue
implements BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>,
FixedThreadPoolWithAffinityExecutor.IQueueMetrics {
    private final Integer maxCapacity;
    private LinkedBlockingQueue<String> orderingQueue = new LinkedBlockingQueue();
    private Map<String, List<SCMDatanodeHeartbeatDispatcher.ContainerReport>> dataMap = new HashMap<String, List<SCMDatanodeHeartbeatDispatcher.ContainerReport>>();
    private int capacity = 0;
    private AtomicInteger droppedCount = new AtomicInteger();

    public ContainerReportQueue() {
        this(100000);
    }

    public ContainerReportQueue(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addContainerReport(SCMDatanodeHeartbeatDispatcher.ContainerReport val) {
        String uuidString = val.getDatanodeDetails().getUuidString();
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            if (!this.dataMap.containsKey(uuidString)) {
                this.addReport(val, uuidString);
                return true;
            }
            List<SCMDatanodeHeartbeatDispatcher.ContainerReport> dataList = this.dataMap.get(uuidString);
            boolean isReportRemoved = false;
            if (!dataList.isEmpty()) {
                for (int i = dataList.size() - 1; i >= 0; --i) {
                    SCMDatanodeHeartbeatDispatcher.ContainerReport reportInfo = dataList.get(i);
                    if (SCMDatanodeHeartbeatDispatcher.ContainerReportType.FCR != reportInfo.getType()) continue;
                    dataList.remove(i);
                    --this.capacity;
                    this.droppedCount.incrementAndGet();
                    isReportRemoved = true;
                    break;
                }
            }
            dataList.add(val);
            ++this.capacity;
            if (!isReportRemoved) {
                this.orderingQueue.add(uuidString);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIncrementalReport(SCMDatanodeHeartbeatDispatcher.ContainerReport val) {
        String uuidString = val.getDatanodeDetails().getUuidString();
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            if (!this.dataMap.containsKey(uuidString)) {
                this.addReport(val, uuidString);
                return true;
            }
            List<SCMDatanodeHeartbeatDispatcher.ContainerReport> dataList = this.dataMap.get(uuidString);
            if (this.mergeIcr(val, dataList)) {
                return true;
            }
            dataList.add(val);
            ++this.capacity;
            this.orderingQueue.add(uuidString);
        }
        return true;
    }

    private void addReport(SCMDatanodeHeartbeatDispatcher.ContainerReport val, String uuidString) {
        ArrayList<SCMDatanodeHeartbeatDispatcher.ContainerReport> dataList = new ArrayList<SCMDatanodeHeartbeatDispatcher.ContainerReport>();
        dataList.add(val);
        ++this.capacity;
        this.dataMap.put(uuidString, dataList);
        this.orderingQueue.add(uuidString);
    }

    private SCMDatanodeHeartbeatDispatcher.ContainerReport removeAndGet(String uuid) {
        if (uuid == null) {
            return null;
        }
        List<SCMDatanodeHeartbeatDispatcher.ContainerReport> dataList = this.dataMap.get(uuid);
        SCMDatanodeHeartbeatDispatcher.ContainerReport report = null;
        if (dataList != null && !dataList.isEmpty()) {
            report = dataList.remove(0);
            --this.capacity;
            if (dataList.isEmpty()) {
                this.dataMap.remove(uuid);
            }
        }
        return report;
    }

    private SCMDatanodeHeartbeatDispatcher.ContainerReport getReport(String uuid) {
        if (uuid == null) {
            return null;
        }
        List<SCMDatanodeHeartbeatDispatcher.ContainerReport> dataList = this.dataMap.get(uuid);
        if (dataList != null && !dataList.isEmpty()) {
            return dataList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addValue(@NotNull SCMDatanodeHeartbeatDispatcher.ContainerReport value) {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            if (this.remainingCapacity() == 0) {
                return false;
            }
            if (SCMDatanodeHeartbeatDispatcher.ContainerReportType.FCR == value.getType()) {
                return this.addContainerReport(value);
            }
            if (SCMDatanodeHeartbeatDispatcher.ContainerReportType.ICR == value.getType()) {
                return this.addIncrementalReport(value);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@NotNull SCMDatanodeHeartbeatDispatcher.ContainerReport value) {
        Objects.requireNonNull(value);
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            if (this.remainingCapacity() == 0) {
                throw new IllegalStateException("capacity not available");
            }
            return this.addValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(@NotNull SCMDatanodeHeartbeatDispatcher.ContainerReport value) {
        Objects.requireNonNull(value);
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            return this.addValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SCMDatanodeHeartbeatDispatcher.ContainerReport remove() {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            String uuid = (String)this.orderingQueue.remove();
            return this.removeAndGet(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SCMDatanodeHeartbeatDispatcher.ContainerReport poll() {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            String uuid = this.orderingQueue.poll();
            return this.removeAndGet(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SCMDatanodeHeartbeatDispatcher.ContainerReport element() {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            String uuid = (String)this.orderingQueue.element();
            return this.getReport(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SCMDatanodeHeartbeatDispatcher.ContainerReport peek() {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            String uuid = this.orderingQueue.peek();
            return this.getReport(uuid);
        }
    }

    @Override
    public void put(@NotNull SCMDatanodeHeartbeatDispatcher.ContainerReport value) throws InterruptedException {
        Objects.requireNonNull(value);
        while (!this.addValue(value)) {
            Thread.currentThread();
            Thread.sleep(10L);
        }
    }

    @Override
    public boolean offer(SCMDatanodeHeartbeatDispatcher.ContainerReport value, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        long timeDiff;
        Objects.requireNonNull(value);
        for (long timeoutMillis = unit.toMillis(timeout); timeoutMillis > 0L; timeoutMillis -= timeDiff) {
            if (this.addValue(value)) {
                return true;
            }
            long startTime = Time.monotonicNow();
            Thread.currentThread();
            Thread.sleep(10L);
            timeDiff = Time.monotonicNow() - startTime;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SCMDatanodeHeartbeatDispatcher.ContainerReport take() throws InterruptedException {
        String uuid = this.orderingQueue.take();
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            return this.removeAndGet(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SCMDatanodeHeartbeatDispatcher.ContainerReport poll(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        String uuid = this.orderingQueue.poll(timeout, unit);
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            return this.removeAndGet(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            return this.maxCapacity - this.capacity;
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends SCMDatanodeHeartbeatDispatcher.ContainerReport> c) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            this.orderingQueue.clear();
            this.dataMap.clear();
            this.capacity = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ContainerReportQueue containerReportQueue = this;
        synchronized (containerReportQueue) {
            return this.capacity;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.orderingQueue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    @NotNull
    public Iterator<SCMDatanodeHeartbeatDispatcher.ContainerReport> iterator() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    @NotNull
    public Object[] toArray() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public int drainTo(@NotNull Collection<? super SCMDatanodeHeartbeatDispatcher.ContainerReport> c) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public int drainTo(@NotNull Collection<? super SCMDatanodeHeartbeatDispatcher.ContainerReport> c, int maxElements) {
        throw new UnsupportedOperationException("not supported");
    }

    public int getAndResetDropCount(String type) {
        if (SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode.class.getSimpleName().equals(type)) {
            return this.droppedCount.getAndSet(0);
        }
        return 0;
    }

    protected boolean mergeIcr(SCMDatanodeHeartbeatDispatcher.ContainerReport val, List<SCMDatanodeHeartbeatDispatcher.ContainerReport> dataList) {
        return false;
    }
}

