/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.ha.SCMHAInvocationHandler;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.CertInfo;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CRLApprover;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.security.x509.crl.CRLStatus;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMCertStore
implements CertificateStore {
    private static final Logger LOG = LoggerFactory.getLogger(SCMCertStore.class);
    private SCMMetadataStore scmMetadataStore;
    private final Lock lock;
    private final AtomicLong crlSequenceId;
    private final Map<UUID, CRLStatus> crlStatusMap;

    private SCMCertStore(SCMMetadataStore dbStore, long sequenceId) {
        this.scmMetadataStore = dbStore;
        this.lock = new ReentrantLock();
        this.crlSequenceId = new AtomicLong(sequenceId);
        this.crlStatusMap = new ConcurrentHashMap<UUID, CRLStatus>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeValidCertificate(BigInteger serialID, X509Certificate certificate, HddsProtos.NodeType role) throws IOException {
        this.lock.lock();
        try {
            if (role == HddsProtos.NodeType.SCM) {
                this.storeValidScmCertificate(serialID, certificate);
            } else {
                this.scmMetadataStore.getValidCertsTable().put((Object)serialID, (Object)certificate);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeValidScmCertificate(BigInteger serialID, X509Certificate certificate) throws IOException {
        this.lock.lock();
        try (BatchOperation batchOperation = this.scmMetadataStore.getBatchHandler().initBatchOperation();){
            this.scmMetadataStore.getValidSCMCertsTable().putWithBatch(batchOperation, (Object)serialID, (Object)certificate);
            this.scmMetadataStore.getValidCertsTable().putWithBatch(batchOperation, (Object)serialID, (Object)certificate);
            this.scmMetadataStore.getStore().commitBatchOperation(batchOperation);
            LOG.info("Scm certificate {} for {} is stored", (Object)serialID, (Object)certificate.getSubjectDN());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void checkValidCertID(BigInteger serialID) throws IOException {
        this.lock.lock();
        try {
            if (this.getCertificateByID(serialID, CertificateStore.CertType.VALID_CERTS) != null || this.getCertificateByID(serialID, CertificateStore.CertType.REVOKED_CERTS) != null) {
                throw new SCMSecurityException("Conflicting certificate ID" + serialID);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> revokeCertificates(List<BigInteger> serialIDs, X509CertificateHolder caCertificateHolder, CRLReason reason, Date revocationTime, CRLApprover crlApprover) throws IOException {
        Optional<Long> sequenceId;
        block22: {
            Date now = new Date();
            X509v2CRLBuilder builder = new X509v2CRLBuilder(caCertificateHolder.getIssuer(), now);
            ArrayList<Object> certsToRevoke = new ArrayList<Object>();
            sequenceId = Optional.empty();
            this.lock.lock();
            try {
                X509CRL crl;
                for (BigInteger serialID : serialIDs) {
                    X509Certificate cert = this.getCertificateByID(serialID, CertificateStore.CertType.VALID_CERTS);
                    if (cert == null && LOG.isWarnEnabled()) {
                        LOG.warn("Trying to revoke a certificate that is not valid. Serial ID: {}", (Object)serialID.toString());
                        continue;
                    }
                    if (this.getCertificateByID(serialID, CertificateStore.CertType.REVOKED_CERTS) != null) {
                        LOG.warn("Trying to revoke a certificate that is already revoked.");
                        continue;
                    }
                    builder.addCRLEntry(serialID, revocationTime, reason.getValue().intValue());
                    certsToRevoke.add(cert);
                }
                if (certsToRevoke.isEmpty()) break block22;
                try {
                    crl = crlApprover.sign(builder);
                }
                catch (CRLException | OperatorCreationException e) {
                    throw new SCMSecurityException("Unable to create Certificate Revocation List.", e);
                }
                try (BatchOperation batch = this.scmMetadataStore.getStore().initBatchOperation();){
                    if (now.after(revocationTime) || now.equals(revocationTime)) {
                        for (X509Certificate x509Certificate : certsToRevoke) {
                            CertInfo certInfo = new CertInfo.Builder().setX509Certificate(x509Certificate).setTimestamp(now.getTime()).build();
                            this.scmMetadataStore.getRevokedCertsV2Table().putWithBatch(batch, (Object)x509Certificate.getSerialNumber(), (Object)certInfo);
                            this.scmMetadataStore.getValidCertsTable().deleteWithBatch(batch, (Object)x509Certificate.getSerialNumber());
                        }
                    }
                    long id = this.crlSequenceId.incrementAndGet();
                    CRLInfo crlInfo = new CRLInfo.Builder().setX509CRL(crl).setCreationTimestamp(now.getTime()).setCrlSequenceID(id).build();
                    this.scmMetadataStore.getCRLInfoTable().putWithBatch(batch, (Object)id, (Object)crlInfo);
                    this.scmMetadataStore.getCRLSequenceIdTable().putWithBatch(batch, (Object)"CRL_SEQUENCE_ID", (Object)id);
                    this.scmMetadataStore.getStore().commitBatchOperation(batch);
                    sequenceId = Optional.of(id);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return sequenceId;
    }

    public void removeExpiredCertificate(BigInteger serialID) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<X509Certificate> removeAllExpiredCertificates() throws IOException {
        ArrayList<X509Certificate> removedCerts = new ArrayList<X509Certificate>();
        this.lock.lock();
        try (BatchOperation batchOperation = this.scmMetadataStore.getBatchHandler().initBatchOperation();){
            removedCerts.addAll(this.addExpiredCertsToBeRemoved(batchOperation, (Table<BigInteger, X509Certificate>)this.scmMetadataStore.getValidCertsTable()));
            removedCerts.addAll(this.addExpiredCertsToBeRemoved(batchOperation, (Table<BigInteger, X509Certificate>)this.scmMetadataStore.getValidSCMCertsTable()));
            this.scmMetadataStore.getStore().commitBatchOperation(batchOperation);
        }
        finally {
            this.lock.unlock();
        }
        return removedCerts;
    }

    private List<X509Certificate> addExpiredCertsToBeRemoved(BatchOperation batchOperation, Table<BigInteger, X509Certificate> certTable) throws IOException {
        ArrayList<X509Certificate> removedCerts = new ArrayList<X509Certificate>();
        try (TableIterator certsIterator = certTable.iterator();){
            Date now = new Date();
            while (certsIterator.hasNext()) {
                Table.KeyValue certEntry = (Table.KeyValue)certsIterator.next();
                X509Certificate cert = (X509Certificate)certEntry.getValue();
                if (!cert.getNotAfter().before(now)) continue;
                removedCerts.add(cert);
                certTable.deleteWithBatch(batchOperation, certEntry.getKey());
            }
        }
        return removedCerts;
    }

    public X509Certificate getCertificateByID(BigInteger serialID, CertificateStore.CertType certType) throws IOException {
        if (certType == CertificateStore.CertType.VALID_CERTS) {
            return (X509Certificate)this.scmMetadataStore.getValidCertsTable().get((Object)serialID);
        }
        CertInfo certInfo = this.getRevokedCertificateInfoByID(serialID);
        return certInfo != null ? certInfo.getX509Certificate() : null;
    }

    public CertInfo getRevokedCertificateInfoByID(BigInteger serialID) throws IOException {
        return (CertInfo)this.scmMetadataStore.getRevokedCertsV2Table().get((Object)serialID);
    }

    public List<X509Certificate> listCertificate(HddsProtos.NodeType role, BigInteger startSerialID, int count, CertificateStore.CertType certType) throws IOException {
        ArrayList<X509Certificate> results = new ArrayList<X509Certificate>();
        String errorMessage = "Fail to list certificate from SCM metadata store";
        Preconditions.checkNotNull((Object)startSerialID);
        if (startSerialID.longValue() == 0L) {
            startSerialID = null;
        }
        if (certType == CertificateStore.CertType.VALID_CERTS) {
            List<? extends Table.KeyValue<BigInteger, X509Certificate>> certs = this.getValidCertTableList(role, startSerialID, count);
            for (Table.KeyValue<BigInteger, X509Certificate> keyValue : certs) {
                try {
                    X509Certificate cert = (X509Certificate)keyValue.getValue();
                    results.add(cert);
                }
                catch (IOException e) {
                    LOG.error(errorMessage, (Throwable)e);
                    throw new SCMSecurityException(errorMessage);
                }
            }
        } else {
            List certs = this.scmMetadataStore.getRevokedCertsV2Table().getRangeKVs((Object)startSerialID, count, null, new MetadataKeyFilters.MetadataKeyFilter[0]);
            for (Table.KeyValue keyValue : certs) {
                try {
                    CertInfo certInfo = (CertInfo)keyValue.getValue();
                    X509Certificate cert = certInfo != null ? certInfo.getX509Certificate() : null;
                    results.add(cert);
                }
                catch (IOException e) {
                    LOG.error(errorMessage, (Throwable)e);
                    throw new SCMSecurityException(errorMessage);
                }
            }
        }
        return results;
    }

    private List<? extends Table.KeyValue<BigInteger, X509Certificate>> getValidCertTableList(HddsProtos.NodeType role, BigInteger startSerialID, int count) throws IOException {
        if (role == HddsProtos.NodeType.SCM) {
            return this.scmMetadataStore.getValidSCMCertsTable().getRangeKVs((Object)startSerialID, count, null, new MetadataKeyFilters.MetadataKeyFilter[0]);
        }
        return this.scmMetadataStore.getValidCertsTable().getRangeKVs((Object)startSerialID, count, null, new MetadataKeyFilters.MetadataKeyFilter[0]);
    }

    public void reinitialize(SCMMetadataStore metadataStore) {
        this.scmMetadataStore = metadataStore;
    }

    public List<CRLInfo> getCrls(List<Long> crlIds) throws IOException {
        ArrayList<CRLInfo> results = new ArrayList<CRLInfo>();
        for (Long crlId : crlIds) {
            try {
                CRLInfo crlInfo = (CRLInfo)this.scmMetadataStore.getCRLInfoTable().get((Object)crlId);
                results.add(crlInfo);
            }
            catch (IOException e) {
                LOG.error("Fail to get CRLs from SCM metadata store for crlId: " + crlId, (Throwable)e);
                throw new SCMSecurityException("Fail to get CRLs from SCM metadata store for crlId: " + crlId, (Throwable)e);
            }
        }
        return results;
    }

    public long getLatestCrlId() {
        return this.crlSequenceId.get();
    }

    public CRLStatus getCRLStatusForDN(UUID uuid) {
        return this.crlStatusMap.get(uuid);
    }

    public void setCRLStatusForDN(UUID uuid, CRLStatus crlStatus) {
        this.crlStatusMap.put(uuid, crlStatus);
    }

    public static class Builder {
        private SCMMetadataStore metadataStore;
        private long crlSequenceId;
        private SCMRatisServer scmRatisServer;

        public Builder setMetadaStore(SCMMetadataStore scmMetadataStore) {
            this.metadataStore = scmMetadataStore;
            return this;
        }

        public Builder setCRLSequenceId(long sequenceId) {
            this.crlSequenceId = sequenceId;
            return this;
        }

        public Builder setRatisServer(SCMRatisServer ratisServer) {
            this.scmRatisServer = ratisServer;
            return this;
        }

        public CertificateStore build() {
            SCMCertStore scmCertStore = new SCMCertStore(this.metadataStore, this.crlSequenceId);
            SCMHAInvocationHandler scmhaInvocationHandler = new SCMHAInvocationHandler(SCMRatisProtocol.RequestType.CERT_STORE, scmCertStore, this.scmRatisServer);
            return (CertificateStore)Proxy.newProxyInstance(SCMHAInvocationHandler.class.getClassLoader(), new Class[]{CertificateStore.class}, (InvocationHandler)scmhaInvocationHandler);
        }
    }
}

