/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.csi;

import csi.v1.ControllerGrpc;
import csi.v1.Csi;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;

public class ControllerService
extends ControllerGrpc.ControllerImplBase {
    private long defaultVolumeSize;
    private OzoneClient ozoneClient;

    public ControllerService(OzoneClient ozoneClient, long volumeSize) {
        this.defaultVolumeSize = volumeSize;
        this.ozoneClient = ozoneClient;
    }

    @Override
    public void createVolume(Csi.CreateVolumeRequest request, StreamObserver<Csi.CreateVolumeResponse> responseObserver) {
        try {
            this.ozoneClient.getObjectStore().createS3Bucket(request.getName());
            long size = this.findSize(request.getCapacityRange());
            Csi.CreateVolumeResponse response = Csi.CreateVolumeResponse.newBuilder().setVolume(Csi.Volume.newBuilder().setVolumeId(request.getName()).setCapacityBytes(size)).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (IOException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    private long findSize(Csi.CapacityRange capacityRange) {
        if (capacityRange.getRequiredBytes() != 0L) {
            return capacityRange.getRequiredBytes();
        }
        if (capacityRange.getLimitBytes() != 0L) {
            return Math.min(this.defaultVolumeSize, capacityRange.getLimitBytes());
        }
        return this.defaultVolumeSize;
    }

    @Override
    public void deleteVolume(Csi.DeleteVolumeRequest request, StreamObserver<Csi.DeleteVolumeResponse> responseObserver) {
        try {
            this.ozoneClient.getObjectStore().deleteS3Bucket(request.getVolumeId());
            Csi.DeleteVolumeResponse response = Csi.DeleteVolumeResponse.newBuilder().build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (IOException e) {
            responseObserver.onError((Throwable)e);
        }
    }

    @Override
    public void controllerGetCapabilities(Csi.ControllerGetCapabilitiesRequest request, StreamObserver<Csi.ControllerGetCapabilitiesResponse> responseObserver) {
        Csi.ControllerGetCapabilitiesResponse response = Csi.ControllerGetCapabilitiesResponse.newBuilder().addCapabilities(Csi.ControllerServiceCapability.newBuilder().setRpc(Csi.ControllerServiceCapability.RPC.newBuilder().setType(Csi.ControllerServiceCapability.RPC.Type.CREATE_DELETE_VOLUME))).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }
}

