/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdiff;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksDiffUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDiffUtils.class);

    private RocksDiffUtils() {
    }

    public static boolean isKeyWithPrefixPresent(String prefixForColumnFamily, String firstDbKey, String lastDbKey) {
        String firstKeyPrefix = RocksDiffUtils.constructBucketKey(firstDbKey);
        String endKeyPrefix = RocksDiffUtils.constructBucketKey(lastDbKey);
        return firstKeyPrefix.compareTo(prefixForColumnFamily) <= 0 && prefixForColumnFamily.compareTo(endKeyPrefix) <= 0;
    }

    public static String constructBucketKey(String keyName) {
        if (!keyName.startsWith("/")) {
            keyName = "/".concat(keyName);
        }
        String[] elements = keyName.split("/");
        String volume = elements[1];
        String bucket = elements[2];
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        if (StringUtils.isNotBlank((CharSequence)bucket)) {
            builder.append("/").append(bucket);
        }
        builder.append("/");
        return builder.toString();
    }

    public static void filterRelevantSstFiles(Set<String> inputFiles, Map<String, String> tableToPrefixMap) throws IOException {
        Iterator<String> fileIterator = inputFiles.iterator();
        while (fileIterator.hasNext()) {
            String filepath = fileIterator.next();
            if (RocksDiffUtils.doesSstFileContainKeyRange(filepath, tableToPrefixMap)) continue;
            fileIterator.remove();
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean doesSstFileContainKeyRange(String filepath, Map<String, String> tableToPrefixMap) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 0[TRYBLOCK], 29[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

