/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface SpaceUsageSource {
    public static final SpaceUsageSource UNKNOWN = new Fixed(0L, 0L, 0L);

    public long getUsedSpace();

    public long getCapacity();

    public long getAvailable();

    default public SpaceUsageSource snapshot() {
        return new Fixed(this.getCapacity(), this.getAvailable(), this.getUsedSpace());
    }

    public static final class Fixed
    implements SpaceUsageSource {
        private final long capacity;
        private final long available;
        private final long used;

        public Fixed(long capacity, long available, long used) {
            this.capacity = capacity;
            this.available = Math.max(Math.min(available, capacity - used), 0L);
            this.used = used;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        @Override
        public long getAvailable() {
            return this.available;
        }

        @Override
        public long getUsedSpace() {
            return this.used;
        }

        @Override
        public SpaceUsageSource snapshot() {
            return this;
        }
    }
}

