/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.io.File;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditWriterFactory;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.RangerAuditWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSAuditDestination
extends AuditDestination {
    private static final Logger logger = LoggerFactory.getLogger(HDFSAuditDestination.class);
    private Map<String, String> auditConfigs = null;
    private String auditProviderName = null;
    private RangerAuditWriter auditWriter = null;
    private boolean initDone = false;
    private boolean isStopped = false;

    @Override
    public void init(Properties prop, String propPrefix) {
        super.init(prop, propPrefix);
        this.auditProviderName = this.getName();
        this.auditConfigs = this.configProps;
        try {
            this.auditWriter = this.getWriter();
            this.initDone = true;
        }
        catch (Exception e) {
            logger.error("Error while getting Audit writer", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean logJSON(Collection<String> events) {
        this.logStatusIfRequired();
        this.addTotalCount(events.size());
        if (!this.initDone) {
            this.addDeferredCount(events.size());
            return false;
        }
        if (this.isStopped) {
            this.addDeferredCount(events.size());
            this.logError("log() called after stop was requested. name=" + this.getName());
            return false;
        }
        try {
            boolean ret = this.auditWriter.log(events);
            if (!ret) {
                this.addDeferredCount(events.size());
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable t) {
            this.addDeferredCount(events.size());
            this.logError("Error writing to log file.", t);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info("Flushing HDFS audit. Event Size:" + events.size());
            if (this.auditWriter != null) {
                this.flush();
            }
        }
        this.addSuccessCount(events.size());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean logFile(File file) {
        this.logStatusIfRequired();
        if (!this.initDone) {
            return false;
        }
        if (this.isStopped) {
            this.logError("log() called after stop was requested. name=" + this.getName());
            return false;
        }
        try {
            boolean ret = this.auditWriter.logFile(file);
            if (!ret) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable t) {
            this.logError("Error writing to log file.", t);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info("Flushing HDFS audit. File:" + file.getAbsolutePath() + file.getName());
            if (this.auditWriter != null) {
                this.flush();
            }
        }
        return true;
    }

    @Override
    public void flush() {
        logger.info("Flush called. name=" + this.getName());
        MiscUtil.executePrivilegedAction(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                HDFSAuditDestination.this.auditWriter.flush();
                return null;
            }
        });
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        if (this.isStopped) {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            this.addDeferredCount(events.size());
            this.logError("log() called after stop was requested. name=" + this.getName());
            return false;
        }
        ArrayList<String> jsonList = new ArrayList<String>();
        for (AuditEventBase event : events) {
            try {
                jsonList.add(MiscUtil.stringify(event));
            }
            catch (Throwable t) {
                logger.error("Error converting to JSON. event=" + event);
                this.addTotalCount(1);
                this.addFailedCount(1);
                this.logFailedEvent(event);
            }
        }
        return this.logJSON(jsonList);
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        this.auditWriter.stop();
        this.logStatus();
        this.isStopped = true;
    }

    public RangerAuditWriter getWriter() throws Exception {
        AuditWriterFactory auditWriterFactory = AuditWriterFactory.getInstance();
        auditWriterFactory.init(this.props, this.propPrefix, this.auditProviderName, this.auditConfigs);
        return auditWriterFactory.getAuditWriter();
    }
}

