/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerTransportFilter;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.ssl.KeyStoresFactory;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.ozone.grpc.metrics.GrpcMetrics;
import org.apache.hadoop.ozone.grpc.metrics.GrpcMetricsServerRequestInterceptor;
import org.apache.hadoop.ozone.grpc.metrics.GrpcMetricsServerResponseInterceptor;
import org.apache.hadoop.ozone.grpc.metrics.GrpcMetricsServerTransportFilter;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.hadoop.ozone.om.OzoneManagerServiceGrpc;
import org.apache.hadoop.ozone.om.protocolPB.GrpcOmTransport;
import org.apache.hadoop.ozone.om.protocolPB.grpc.ClientAddressServerInterceptor;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.ozone.security.OzoneDelegationTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcOzoneManagerServer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcOzoneManagerServer.class);
    private final GrpcMetrics omS3gGrpcMetrics;
    private Server server;
    private int port;
    private final int maxSize;
    private final String threadNamePrefix;
    private ThreadPoolExecutor readExecutors;
    private EventLoopGroup bossEventLoopGroup;
    private EventLoopGroup workerEventLoopGroup;

    public GrpcOzoneManagerServer(OzoneConfiguration config, OzoneManagerProtocolServerSideTranslatorPB omTranslator, OzoneDelegationTokenSecretManager delegationTokenMgr, CertificateClient caClient, String threadPrefix) {
        this.maxSize = config.getInt("ozone.om.grpc.maximum.response.length", 0x8000000);
        OptionalInt haPort = HddsUtils.getNumberFromConfigKeys((ConfigurationSource)config, (String[])new String[]{ConfUtils.addKeySuffixes((String)"ozone.om.grpc.port", (String[])new String[]{config.get("ozone.om.service.ids"), config.get("ozone.om.node.id")}), "ozone.om.grpc.port"});
        this.port = haPort.isPresent() ? haPort.getAsInt() : ((GrpcOmTransport.GrpcOmTransportConfig)config.getObject(GrpcOmTransport.GrpcOmTransportConfig.class)).getPort();
        this.threadNamePrefix = threadPrefix;
        this.omS3gGrpcMetrics = GrpcMetrics.create((Configuration)config);
        this.init(omTranslator, delegationTokenMgr, config, caClient);
    }

    public void init(OzoneManagerProtocolServerSideTranslatorPB omTranslator, OzoneDelegationTokenSecretManager delegationTokenMgr, OzoneConfiguration omServerConfig, CertificateClient caClient) {
        int poolSize = omServerConfig.getInt("ozone.om.grpc.read.thread.num", 32);
        int bossGroupSize = omServerConfig.getInt("ozone.om.grpc.bossgroup.size", 8);
        int workerGroupSize = omServerConfig.getInt("ozone.om.grpc.workergroup.size", 32);
        this.readExecutors = new ThreadPoolExecutor(poolSize, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(String.valueOf(this.threadNamePrefix) + "OmRpcReader-%d").build());
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(String.valueOf(this.threadNamePrefix) + "OmRpcBoss-ELG-%d").build();
        this.bossEventLoopGroup = new NioEventLoopGroup(bossGroupSize, bossFactory);
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(String.valueOf(this.threadNamePrefix) + "OmRpcWorker-ELG-%d").build();
        this.workerEventLoopGroup = new NioEventLoopGroup(workerGroupSize, workerFactory);
        NettyServerBuilder nettyServerBuilder = (NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).maxInboundMessageSize(this.maxSize).bossEventLoopGroup(this.bossEventLoopGroup).workerEventLoopGroup(this.workerEventLoopGroup).channelType(NioServerSocketChannel.class).executor((Executor)this.readExecutors)).addService(ServerInterceptors.intercept((BindableService)new OzoneManagerServiceGrpc(omTranslator, delegationTokenMgr, omServerConfig), (ServerInterceptor[])new ServerInterceptor[]{new ClientAddressServerInterceptor(), new GrpcMetricsServerResponseInterceptor(this.omS3gGrpcMetrics), new GrpcMetricsServerRequestInterceptor(this.omS3gGrpcMetrics)}))).addTransportFilter((ServerTransportFilter)new GrpcMetricsServerTransportFilter(this.omS3gGrpcMetrics));
        SecurityConfig secConf = new SecurityConfig((ConfigurationSource)omServerConfig);
        if (secConf.isSecurityEnabled() && secConf.isGrpcTlsEnabled()) {
            try {
                KeyStoresFactory factory = caClient.getServerKeyStoresFactory();
                SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((KeyManager)factory.getKeyManagers()[0]);
                SslContextBuilder sslContextBuilder = GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)SslProvider.valueOf((String)omServerConfig.get("hdds.grpc.tls.provider", "OPENSSL")));
                nettyServerBuilder.sslContext(sslContextBuilder.build());
            }
            catch (Exception ex) {
                LOG.error("Unable to setup TLS for secure Om S3g GRPC channel.", (Throwable)ex);
            }
        }
        this.server = nettyServerBuilder.build();
    }

    public void start() throws IOException {
        this.server.start();
        LOG.info("{} is started using port {}", (Object)this.getClass().getSimpleName(), (Object)this.server.getPort());
        this.port = this.server.getPort();
    }

    public void stop() {
        try {
            try {
                this.readExecutors.shutdown();
                this.readExecutors.awaitTermination(5L, TimeUnit.SECONDS);
                this.server.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
                this.bossEventLoopGroup.shutdownGracefully().sync();
                this.workerEventLoopGroup.shutdownGracefully().sync();
                LOG.info("Server {} is shutdown", (Object)this.getClass().getSimpleName());
            }
            catch (InterruptedException interruptedException) {
                LOG.warn("{} couldn't be stopped gracefully", (Object)this.getClass().getSimpleName());
                this.omS3gGrpcMetrics.unRegister();
            }
        }
        finally {
            this.omS3gGrpcMetrics.unRegister();
        }
    }

    public int getPort() {
        return this.port;
    }
}

