/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdds.ExitManager;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfigValidator;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ReconfigureProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolPB;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.ha.SCMNodeInfo;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.OzoneSecurityException;
import org.apache.hadoop.hdds.security.symmetric.DefaultSecretKeySignerClient;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenSecretManager;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.server.http.RatisDropwizardExports;
import org.apache.hadoop.hdds.utils.DBStoreHAManager;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBUpdatesWrapper;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.common.ha.ratis.RatisSnapshotInfo;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.BucketManagerImpl;
import org.apache.hadoop.ozone.om.GrpcOzoneManagerServer;
import org.apache.hadoop.ozone.om.IOmMetadataReader;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMMXBean;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OMMultiTenantManagerImpl;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OMPolicyProvider;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmMetadataReader;
import org.apache.hadoop.ozone.om.OmMetricsInfo;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OmUpgradeConfig;
import org.apache.hadoop.ozone.om.OzoneAclUtils;
import org.apache.hadoop.ozone.om.OzoneConfigUtil;
import org.apache.hadoop.ozone.om.OzoneManagerHttpServer;
import org.apache.hadoop.ozone.om.OzoneManagerPrepareState;
import org.apache.hadoop.ozone.om.OzoneTrash;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.PrefixManagerImpl;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.S3SecretLockedManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.S3SecretManagerImpl;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.ServiceInfoProvider;
import org.apache.hadoop.ozone.om.TrashOzoneFileSystem;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.VolumeManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.OMHAMetrics;
import org.apache.hadoop.ozone.om.ha.OMHANodeDetails;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.KeyInfoWithVolumeContext;
import org.apache.hadoop.ozone.om.helpers.ListKeysLightResult;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.OMNodeDetails;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBTenantState;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.helpers.SnapshotDiffJob;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneLockProvider;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.protocol.OMConfiguration;
import org.apache.hadoop.ozone.om.protocol.OMInterServiceProtocol;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OMAdminProtocolClientSideImpl;
import org.apache.hadoop.ozone.om.protocolPB.OMAdminProtocolPB;
import org.apache.hadoop.ozone.om.protocolPB.OMInterServiceProtocolClientSideImpl;
import org.apache.hadoop.ozone.om.protocolPB.OMInterServiceProtocolPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.ratis_snapshot.OmRatisSnapshotProvider;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.s3.S3SecretCacheProvider;
import org.apache.hadoop.ozone.om.s3.S3SecretStoreConfigurationKeys;
import org.apache.hadoop.ozone.om.s3.S3SecretStoreProvider;
import org.apache.hadoop.ozone.om.service.OMRangerBGSyncService;
import org.apache.hadoop.ozone.om.snapshot.OmSnapshotUtils;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutVersionManager;
import org.apache.hadoop.ozone.om.upgrade.OMUpgradeFinalizer;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerAdminProtocolProtos;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerInterServiceProtocolProtos;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMAdminProtocolServerSideImpl;
import org.apache.hadoop.ozone.protocolPB.OMInterServiceProtocolServerSideImpl;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.ozone.security.OMCertificateClient;
import org.apache.hadoop.ozone.security.OzoneDelegationTokenSecretManager;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneAuthorizerFactory;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.Time;
import org.apache.ozone.graph.PrintableGraph;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JvmPauseMonitor;
import org.apache.ratis.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class OzoneManager
extends ServiceRuntimeInfoImpl
implements OzoneManagerProtocol,
OMInterServiceProtocol,
OMMXBean,
Auditor {
    public static final Logger LOG = LoggerFactory.getLogger(OzoneManager.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMLOGGER);
    private static final String OM_DAEMON = "om";
    private static final ThreadLocal<OzoneManagerProtocolProtos.S3Authentication> S3_AUTH = new ThreadLocal();
    private static boolean securityEnabled = false;
    private final ReconfigurationHandler reconfigurationHandler;
    private OzoneDelegationTokenSecretManager delegationTokenMgr;
    private OzoneBlockTokenSecretManager blockTokenMgr;
    private CertificateClient certClient;
    private SecretKeySignerClient secretKeyClient;
    private final Text omRpcAddressTxt;
    private OzoneConfiguration configuration;
    private RPC.Server omRpcServer;
    private GrpcOzoneManagerServer omS3gGrpcServer;
    private final InetSocketAddress omRpcAddress;
    private final String omId;
    private final String threadPrefix;
    private ServiceInfoProvider serviceInfo;
    private OMMetadataManager metadataManager;
    private OMMultiTenantManager multiTenantManager;
    private VolumeManager volumeManager;
    private BucketManager bucketManager;
    private KeyManager keyManager;
    private PrefixManagerImpl prefixManager;
    private final UpgradeFinalizer<OzoneManager> upgradeFinalizer;
    private final String omStarterUser;
    private final OzoneAdmins omAdmins;
    private final OzoneAdmins readOnlyAdmins;
    private final OzoneAdmins s3OzoneAdmins;
    private final OMMetrics metrics;
    private OMHAMetrics omhaMetrics;
    private final ProtocolMessageMetrics<ProtocolMessageEnum> omClientProtocolMetrics;
    private OzoneManagerHttpServer httpServer;
    private final OMStorage omStorage;
    private final ScmBlockLocationProtocol scmBlockClient;
    private final StorageContainerLocationProtocol scmContainerClient;
    private ObjectName omInfoBeanName;
    private Timer metricsTimer;
    private ScheduleOMMetricsWriteTask scheduleOMMetricsWriteTask;
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final ObjectReader READER = new ObjectMapper().readerFor(OmMetricsInfo.class);
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final File omMetaDir;
    private boolean isAclEnabled;
    private final boolean isSpnegoEnabled;
    private final JvmPauseMonitor jvmPauseMonitor;
    private final SecurityConfig secConfig;
    private S3SecretManager s3SecretManager;
    private final boolean isOmGrpcServerEnabled;
    private volatile boolean isOmRpcServerRunning = false;
    private volatile boolean isOmGrpcServerRunning = false;
    private String omComponent;
    private OzoneManagerProtocolServerSideTranslatorPB omServerProtocol;
    private final boolean isRatisEnabled;
    private OzoneManagerRatisServer omRatisServer;
    private OmRatisSnapshotProvider omRatisSnapshotProvider;
    private OMNodeDetails omNodeDetails;
    private final Map<String, OMNodeDetails> peerNodesMap;
    private File omRatisSnapshotDir;
    private final RatisSnapshotInfo omRatisSnapshotInfo;
    private final Map<String, RatisDropwizardExports> ratisMetricsMap = new ConcurrentHashMap<String, RatisDropwizardExports>();
    private List<RatisDropwizardExports.MetricReporter> ratisReporterList = null;
    private KeyProviderCryptoExtension kmsProvider;
    private final OMLayoutVersionManager versionManager;
    private final ReplicationConfigValidator replicationConfigValidator;
    private boolean allowListAllVolumes;
    private final long maxUserVolumeCount;
    private int minMultipartUploadPartSize = 0x500000;
    private final ScmClient scmClient;
    private final long scmBlockSize;
    private final int preallocateBlocksMax;
    private final boolean grpcBlockTokenEnabled;
    private final BucketLayout defaultBucketLayout;
    private final ReplicationConfig defaultReplicationConfig;
    private final boolean isS3MultiTenancyEnabled;
    private final boolean isStrictS3;
    private ExitManager exitManager;
    private OzoneManagerPrepareState prepareState;
    private boolean isBootstrapping = false;
    private boolean isForcedBootstrapping = false;
    private static boolean testReloadConfigFlag = false;
    private static boolean testSecureOmFlag = false;
    private static UserGroupInformation testUgi;
    private final OzoneLockProvider ozoneLockProvider;
    private final OMPerformanceMetrics perfMetrics;
    private boolean fsSnapshotEnabled;
    private State omState;
    private Thread emptier;
    private static final int MSECS_PER_MINUTE = 60000;
    private final boolean isSecurityEnabled;
    private IAccessAuthorizer accessAuthorizer;
    private OmMetadataReader omMetadataReader;
    private ReferenceCounted<IOmMetadataReader> rcOmMetadataReader;
    private OmSnapshotManager omSnapshotManager;

    private OzoneManager(OzoneConfiguration conf, StartupOption startupOption) throws IOException, AuthenticationException {
        super(OzoneVersionInfo.OZONE_VERSION_INFO);
        ScmInfo scmInfo;
        Preconditions.checkNotNull((Object)conf);
        this.setConfiguration(conf);
        OMHANodeDetails omhaNodeDetails = OMHANodeDetails.loadOMHAConfig(this.configuration);
        this.isSecurityEnabled = OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf);
        this.peerNodesMap = omhaNodeDetails.getPeerNodesMap();
        this.omNodeDetails = omhaNodeDetails.getLocalNodeDetails();
        this.omStorage = new OMStorage(conf);
        this.omStorage.validateOrPersistOmNodeId(this.omNodeDetails.getNodeId());
        this.omId = this.omStorage.getOmId();
        this.reconfigurationHandler = new ReconfigurationHandler("OM", conf, this::checkAdminUserPrivilege).register("ozone.administrators", this::reconfOzoneAdmins).register("ozone.readonly.administrators", this::reconfOzoneReadOnlyAdmins).register("ozone.key.deleting.limit.per.task", this::reconfOzoneKeyDeletingLimitPerTask);
        this.versionManager = new OMLayoutVersionManager(this.omStorage.getLayoutVersion());
        this.upgradeFinalizer = new OMUpgradeFinalizer(this.versionManager);
        this.replicationConfigValidator = (ReplicationConfigValidator)conf.getObject(ReplicationConfigValidator.class);
        this.exitManager = new ExitManager();
        if (this.omNodeDetails.getNodeId() == null) {
            this.omNodeDetails = OMHANodeDetails.getOMNodeDetailsForNonHA(conf, this.omNodeDetails.getServiceId(), this.omStorage.getOmId(), this.omNodeDetails.getRpcAddress(), this.omNodeDetails.getRatisPort());
        }
        this.threadPrefix = this.omNodeDetails.threadNamePrefix();
        OzoneManager.loginOMUserIfSecurityEnabled(conf);
        this.setInstanceVariablesFromConf();
        this.maxUserVolumeCount = conf.getInt("ozone.om.user.max.volume", 1024);
        Preconditions.checkArgument((this.maxUserVolumeCount > 0L ? 1 : 0) != 0, (Object)"ozone.om.user.max.volume value should be greater than zero");
        if (this.omStorage.getState() != Storage.StorageState.INITIALIZED) {
            throw new OMException("OM not initialized, current OM storage state: " + this.omStorage.getState().name() + ". Please ensure 'ozone om --init' " + "command is executed to generate all the required metadata to " + this.omStorage.getStorageDir() + " once before starting the OM service.", OMException.ResultCodes.OM_NOT_INITIALIZED);
        }
        this.omMetaDir = OMStorage.getOmDbDir((ConfigurationSource)this.configuration);
        this.isSpnegoEnabled = conf.get("ozone.om.http.auth.type", "simple").equals("kerberos");
        this.isOmGrpcServerEnabled = conf.getBoolean("ozone.om.s3.grpc.server_enabled", true);
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.preallocateBlocksMax = conf.getInt("ozone.key.preallocation.max.blocks", 64);
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.isStrictS3 = conf.getBoolean("ozone.om.namespace.s3.strict", true);
        this.isRatisEnabled = this.configuration.getBoolean("ozone.om.ratis.enable", true);
        this.jvmPauseMonitor = !this.isRatisEnabled ? RatisHelper.newJvmPauseMonitor((String)this.omId) : null;
        String defaultBucketLayoutString = this.configuration.getTrimmed("ozone.default.bucket.layout", OMConfigKeys.OZONE_DEFAULT_BUCKET_LAYOUT_DEFAULT);
        boolean bucketLayoutValid = Arrays.stream(BucketLayout.values()).anyMatch(layout -> layout.name().equals(defaultBucketLayoutString));
        if (bucketLayoutValid) {
            this.defaultBucketLayout = BucketLayout.fromString((String)defaultBucketLayoutString);
            if (!this.defaultBucketLayout.isLegacy() && !this.versionManager.isAllowed(OMLayoutFeature.BUCKET_LAYOUT_SUPPORT)) {
                LOG.warn("{} configured to non-legacy bucket layout {} when Ozone Manager is pre-finalized for bucket layout support. Legacy buckets will be created by default until Ozone Manager is finalized.", (Object)"ozone.default.bucket.layout", (Object)this.defaultBucketLayout);
            }
        } else {
            throw new ConfigurationException(String.valueOf(defaultBucketLayoutString) + " is not a valid default bucket layout. Supported values are " + Arrays.stream(BucketLayout.values()).map(Enum::toString).collect(Collectors.joining(", ")));
        }
        this.defaultReplicationConfig = this.getDefaultReplicationConfig();
        InetSocketAddress omNodeRpcAddr = this.omNodeDetails.getRpcAddress();
        this.omRpcAddressTxt = new Text(SecurityUtil.buildTokenService((InetSocketAddress)omNodeRpcAddr));
        this.scmContainerClient = OzoneManager.getScmContainerClient(this.configuration);
        this.scmBlockClient = OzoneManager.getScmBlockClient(this.configuration);
        this.scmClient = new ScmClient(this.scmBlockClient, this.scmContainerClient, this.configuration);
        this.ozoneLockProvider = new OzoneLockProvider(this.getKeyPathLockEnabled(), this.getEnableFileSystemPaths());
        if (!testSecureOmFlag) {
            scmInfo = HAUtils.getScmInfo((OzoneConfiguration)this.configuration);
            if (!scmInfo.getClusterId().equals(this.omStorage.getClusterID())) {
                this.logVersionMismatch(conf, scmInfo);
                throw new OMException("SCM version info mismatch.", OMException.ResultCodes.SCM_VERSION_MISMATCH_ERROR);
            }
        } else {
            scmInfo = new ScmInfo.Builder().setScmId("test").build();
        }
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.secConfig = new SecurityConfig((ConfigurationSource)this.configuration);
        try {
            this.kmsProvider = this.createKeyProviderExt(this.configuration);
        }
        catch (IOException iOException) {
            this.kmsProvider = null;
            LOG.error("Fail to create Key Provider");
        }
        if (this.secConfig.isSecurityEnabled()) {
            this.omComponent = "om-" + this.omId;
            HddsProtos.OzoneManagerDetailsProto omInfo = OzoneManager.getOmDetailsProto((ConfigurationSource)conf, this.omStorage.getOmId());
            if (this.omStorage.getOmCertSerialId() == null) {
                throw new RuntimeException("OzoneManager started in secure mode but doesn't have SCM signed certificate.");
            }
            SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)this.configuration, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            this.certClient = new OMCertificateClient(this.secConfig, scmSecurityClient, this.omStorage, omInfo, "", scmInfo == null ? null : scmInfo.getScmId(), this::saveNewCertId, this::terminateOM);
            SecretKeyProtocolClientSideTranslatorPB secretKeyProtocol = HddsServerUtil.getSecretKeyClientForOm((ConfigurationSource)conf);
            this.secretKeyClient = new DefaultSecretKeySignerClient((SecretKeyProtocol)secretKeyProtocol, this.omNodeDetails.threadNamePrefix());
        }
        this.serviceInfo = new ServiceInfoProvider(this.secConfig, this, this.certClient, testSecureOmFlag);
        if (this.secConfig.isBlockTokenEnabled()) {
            this.blockTokenMgr = this.createBlockTokenSecretManager();
        }
        this.isS3MultiTenancyEnabled = OMMultiTenantManager.checkAndEnableMultiTenancy(this, conf);
        this.metrics = OMMetrics.create();
        this.perfMetrics = OMPerformanceMetrics.register();
        this.omStarterUser = UserGroupInformation.getCurrentUser().getShortUserName();
        this.omAdmins = OzoneAdmins.getOzoneAdmins((String)this.omStarterUser, (OzoneConfiguration)conf);
        LOG.info("OM start with adminUsers: {}", (Object)this.omAdmins.getAdminUsernames());
        this.readOnlyAdmins = OzoneAdmins.getReadonlyAdmins((OzoneConfiguration)conf);
        Collection<String> s3AdminUsernames = OzoneConfigUtil.getS3AdminsFromConfig(this.configuration);
        Collection<String> s3AdminGroups = OzoneConfigUtil.getS3AdminsGroupsFromConfig(this.configuration);
        this.s3OzoneAdmins = new OzoneAdmins(s3AdminUsernames, s3AdminGroups);
        this.instantiateServices(false);
        this.addS3GVolumeToDB();
        if (startupOption == StartupOption.BOOTSTRAP) {
            this.isBootstrapping = true;
        } else if (startupOption == StartupOption.FORCE_BOOTSTRAP) {
            this.isForcedBootstrapping = true;
        }
        this.omRatisSnapshotInfo = new RatisSnapshotInfo();
        this.initializeRatisDirs(conf);
        this.initializeRatisServer(this.isBootstrapping || this.isForcedBootstrapping);
        this.omClientProtocolMetrics = ProtocolMessageMetrics.create((String)"OmClientProtocol", (String)"Ozone Manager RPC endpoint", (Object[])OzoneManagerProtocolProtos.Type.values());
        this.omRpcServer = this.getRpcServer(this.configuration);
        this.omRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)this.configuration, (String)"ozone.om.address", (InetSocketAddress)omNodeRpcAddr, (RPC.Server)this.omRpcServer);
        if (this.isOmGrpcServerEnabled) {
            this.omS3gGrpcServer = this.getOmS3gGrpcServer(this.configuration);
        }
        ShutdownHookManager.get().addShutdownHook(this::saveOmMetrics, 30);
        this.omState = this.isBootstrapping || this.isForcedBootstrapping ? State.BOOTSTRAPPING : State.INITIALIZED;
    }

    public boolean isStopped() {
        return this.omState == State.STOPPED;
    }

    public static void setS3Auth(OzoneManagerProtocolProtos.S3Authentication val) {
        S3_AUTH.set(val);
    }

    public static OzoneManagerProtocolProtos.S3Authentication getS3Auth() {
        return S3_AUTH.get();
    }

    public String getThreadNamePrefix() {
        return this.threadPrefix;
    }

    private void setInstanceVariablesFromConf() {
        this.isAclEnabled = this.configuration.getBoolean("ozone.acl.enabled", false);
        this.allowListAllVolumes = this.configuration.getBoolean("ozone.om.volume.listall.allowed", true);
    }

    public static OzoneManager createOm(OzoneConfiguration conf) throws IOException, AuthenticationException {
        return new OzoneManager(conf, StartupOption.REGUALR);
    }

    public static OzoneManager createOm(OzoneConfiguration conf, StartupOption startupOption) throws IOException, AuthenticationException {
        return new OzoneManager(conf, startupOption);
    }

    private void logVersionMismatch(OzoneConfiguration conf, ScmInfo scmInfo) {
        List scmNodeInfoList = SCMNodeInfo.buildNodeInfo((ConfigurationSource)conf);
        StringBuilder scmBlockAddressBuilder = new StringBuilder();
        for (SCMNodeInfo scmNodeInfo : scmNodeInfoList) {
            scmBlockAddressBuilder.append(scmNodeInfo.getBlockClientAddress()).append(",");
        }
        String scmBlockAddress = scmBlockAddressBuilder.toString();
        if (!StringUtils.isBlank((CharSequence)scmBlockAddress)) {
            scmBlockAddress = scmBlockAddress.substring(0, scmBlockAddress.lastIndexOf(","));
        }
        if (!scmInfo.getClusterId().equals(this.omStorage.getClusterID())) {
            LOG.error("clusterId from {} is {}, but is {} in {}", new Object[]{scmBlockAddress, scmInfo.getClusterId(), this.omStorage.getClusterID(), this.omStorage.getVersionFile()});
        }
    }

    private void instantiateServices(boolean withNewSnapshot) throws IOException {
        OmMetadataManagerImpl store;
        OmMetadataManagerImpl metadataManagerImpl = new OmMetadataManagerImpl(this.configuration, this);
        this.metadataManager = metadataManagerImpl;
        LOG.info("S3 Multi-Tenancy is {}", (Object)(this.isS3MultiTenancyEnabled ? "enabled" : "disabled"));
        if (this.isS3MultiTenancyEnabled) {
            this.multiTenantManager = new OMMultiTenantManagerImpl(this, this.configuration);
            OzoneAclUtils.setOMMultiTenantManager(this.multiTenantManager);
        }
        this.volumeManager = new VolumeManagerImpl(this.metadataManager);
        this.bucketManager = new BucketManagerImpl(this, this.metadataManager);
        Class storeProviderClass = this.configuration.getClass("ozone.secret.s3.store.provider", S3SecretStoreConfigurationKeys.DEFAULT_SECRET_STORAGE_TYPE, S3SecretStoreProvider.class);
        try {
            store = storeProviderClass == S3SecretStoreConfigurationKeys.DEFAULT_SECRET_STORAGE_TYPE ? metadataManagerImpl : ((S3SecretStoreProvider)storeProviderClass.getConstructor(new Class[0]).newInstance(new Object[0])).get((Configuration)this.configuration);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        S3SecretCacheProvider secretCacheProvider = S3SecretCacheProvider.IN_MEMORY;
        this.s3SecretManager = new S3SecretLockedManager((S3SecretManager)new S3SecretManagerImpl(store, secretCacheProvider.get((Configuration)this.configuration)), this.metadataManager.getLock());
        if (this.secConfig.isSecurityEnabled() || testSecureOmFlag) {
            this.delegationTokenMgr = this.createDelegationTokenSecretManager(this.configuration);
        }
        this.prefixManager = new PrefixManagerImpl(this.metadataManager, this.isRatisEnabled);
        this.keyManager = new KeyManagerImpl(this, this.scmClient, this.configuration, this.perfMetrics);
        if (this.accessAuthorizer == null || this.accessAuthorizer.isNative()) {
            this.accessAuthorizer = OzoneAuthorizerFactory.forOM(this);
        }
        this.omMetadataReader = new OmMetadataReader(this.keyManager, this.prefixManager, this, LOG, AUDIT, this.metrics, this.accessAuthorizer);
        this.rcOmMetadataReader = new ReferenceCounted<OmMetadataReader>(this.omMetadataReader, true, null);
        this.fsSnapshotEnabled = this.configuration.getBoolean("ozone.filesystem.snapshot.enabled", true);
        this.omSnapshotManager = new OmSnapshotManager(this);
        this.updateActiveSnapshotMetrics();
        if (withNewSnapshot) {
            Integer layoutVersionInDB = this.getLayoutVersionInDB();
            if (layoutVersionInDB != null && this.versionManager.getMetadataLayoutVersion() < layoutVersionInDB) {
                LOG.info("New OM snapshot received with higher layout version {}. Attempting to finalize current OM to that version.", (Object)layoutVersionInDB);
                OmUpgradeConfig uConf = (OmUpgradeConfig)this.configuration.getObject(OmUpgradeConfig.class);
                this.upgradeFinalizer.finalizeAndWaitForCompletion("om-ratis-snapshot", (Object)this, uConf.getRatisBasedFinalizationTimeout());
                if (this.versionManager.getMetadataLayoutVersion() < layoutVersionInDB) {
                    throw new IOException("Unable to finalize OM to the desired layout version " + layoutVersionInDB + " present in the snapshot DB.");
                }
                this.updateLayoutVersionInDB(this.versionManager, this.metadataManager);
            }
            this.instantiatePrepareStateAfterSnapshot();
        } else {
            this.instantiatePrepareStateOnStartup();
        }
    }

    public ScmClient getScmClient() {
        return this.scmClient;
    }

    public OzoneBlockTokenSecretManager getBlockTokenSecretManager() {
        return this.blockTokenMgr;
    }

    public long getScmBlockSize() {
        return this.scmBlockSize;
    }

    public int getPreallocateBlocksMax() {
        return this.preallocateBlocksMax;
    }

    public boolean isGrpcBlockTokenEnabled() {
        return this.grpcBlockTokenEnabled;
    }

    public boolean isS3MultiTenancyEnabled() {
        return this.isS3MultiTenancyEnabled;
    }

    public boolean isStrictS3() {
        return this.isStrictS3;
    }

    public void checkS3MultiTenancyEnabled() throws OMException {
        if (this.isS3MultiTenancyEnabled()) {
            return;
        }
        throw new OMException("S3 multi-tenancy feature is not enabled. Please set ozone.om.multitenancy.enabled to true and restart all OMs.", OMException.ResultCodes.FEATURE_NOT_ENABLED);
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled || testSecureOmFlag;
    }

    public boolean isTestSecureOmFlag() {
        return testSecureOmFlag;
    }

    private KeyProviderCryptoExtension createKeyProviderExt(OzoneConfiguration conf) throws IOException {
        KeyProvider keyProvider = KMSUtil.createKeyProvider((Configuration)conf, (String)"hadoop.security.key.provider.path");
        if (keyProvider == null) {
            return null;
        }
        return KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
    }

    public void close() throws IOException {
        this.stop();
    }

    private void saveOmMetrics() {
        try {
            File parent = this.getTempMetricsStorageFile().getParentFile();
            if (!parent.exists()) {
                Files.createDirectories(parent.toPath(), new FileAttribute[0]);
            }
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTempMetricsStorageFile()), StandardCharsets.UTF_8));){
                OmMetricsInfo metricsInfo = new OmMetricsInfo();
                metricsInfo.setNumKeys(this.metrics.getNumKeys());
                WRITER.writeValue((Writer)writer, (Object)metricsInfo);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Files.move(this.getTempMetricsStorageFile().toPath(), this.getMetricsStorageFile().toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            LOG.error("Unable to write the om Metrics file", (Throwable)ex);
        }
    }

    private File getTempMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics.tmp");
    }

    private File getMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics");
    }

    private OzoneDelegationTokenSecretManager createDelegationTokenSecretManager(OzoneConfiguration conf) throws IOException {
        long tokenRemoverScanInterval = conf.getTimeDuration("ozone.manager.delegation.remover.scan.interval", 3600000L, TimeUnit.MILLISECONDS);
        long tokenMaxLifetime = conf.getTimeDuration("ozone.manager.delegation.token.max-lifetime", 604800000L, TimeUnit.MILLISECONDS);
        long tokenRenewInterval = conf.getTimeDuration("ozone.manager.delegation.token.renew-interval", 86400000L, TimeUnit.MILLISECONDS);
        long certificateGracePeriod = Duration.parse(conf.get("hdds.x509.renew.grace.duration", "P28D")).toMillis();
        boolean tokenSanityChecksEnabled = conf.getBoolean("hdds.x509.grace.duration.token.checks.enabled", true);
        if (tokenSanityChecksEnabled && tokenMaxLifetime > certificateGracePeriod) {
            throw new IllegalArgumentException("Certificate grace period hdds.x509.renew.grace.duration should be greater than maximum delegation token lifetime ozone.manager.delegation.token.max-lifetime");
        }
        return new OzoneDelegationTokenSecretManager.Builder().setConf(conf).setTokenMaxLifetime(tokenMaxLifetime).setTokenRenewInterval(tokenRenewInterval).setTokenRemoverScanInterval(tokenRemoverScanInterval).setService(this.omRpcAddressTxt).setOzoneManager(this).setS3SecretManager(this.s3SecretManager).setCertificateClient(this.certClient).setOmServiceId(this.omNodeDetails.getServiceId()).build();
    }

    private OzoneBlockTokenSecretManager createBlockTokenSecretManager() {
        long expiryTime = this.configuration.getTimeDuration("hdds.block.token.expiry.time", "1d", TimeUnit.MILLISECONDS);
        return new OzoneBlockTokenSecretManager(expiryTime, this.secretKeyClient);
    }

    private void stopSecretManager() {
        if (this.secretKeyClient != null) {
            LOG.info("Stopping secret key client.");
            this.secretKeyClient.stop();
        }
        if (this.delegationTokenMgr != null) {
            LOG.info("Stopping OM delegation token secret manager.");
            try {
                this.delegationTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop delegation token manager", (Throwable)e);
            }
        }
    }

    public UUID refetchSecretKey() {
        this.secretKeyClient.refetchSecretKey();
        return this.secretKeyClient.getCurrentSecretKey().getId();
    }

    @VisibleForTesting
    public void startSecretManager() {
        try {
            this.certClient.assertValidKeysAndCertificate();
        }
        catch (OzoneSecurityException e) {
            LOG.error("Unable to read key pair for OM.", (Throwable)e);
            throw new UncheckedIOException((IOException)((Object)e));
        }
        if (this.secConfig.isBlockTokenEnabled() && this.blockTokenMgr != null) {
            LOG.info("Starting secret key client.");
            try {
                this.secretKeyClient.start((ConfigurationSource)this.configuration);
            }
            catch (IOException e) {
                LOG.error("Unable to initialize secret key.", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
        if (this.delegationTokenMgr != null) {
            try {
                LOG.info("Starting OM delegation token secret manager");
                this.delegationTokenMgr.start(this.certClient);
            }
            catch (IOException e) {
                LOG.error("Error starting delegation token secret manager.", (Throwable)e);
                throw new UncheckedIOException(e);
            }
        }
    }

    @VisibleForTesting
    public void setCertClient(CertificateClient newClient) throws IOException {
        if (this.certClient != null) {
            this.certClient.close();
        }
        this.certClient = newClient;
        this.serviceInfo = new ServiceInfoProvider(this.secConfig, this, this.certClient);
    }

    @VisibleForTesting
    public void setSecretKeyClient(SecretKeySignerClient secretKeyClient) {
        this.secretKeyClient = secretKeyClient;
        this.blockTokenMgr.setSecretKeyClient(secretKeyClient);
    }

    private static void loginOMUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ozone security is enabled. Attempting login for OM user. Principal: {}, keytab: {}", (Object)conf.get("ozone.om.kerberos.principal"), (Object)conf.get("ozone.om.kerberos.keytab.file"));
            }
        } else {
            throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. OM user login " + "failed.");
        }
        UserGroupInformation.setConfiguration((Configuration)conf);
        InetSocketAddress socAddr = OmUtils.getOmAddress((ConfigurationSource)conf);
        SecurityUtil.login((Configuration)conf, (String)"ozone.om.kerberos.keytab.file", (String)"ozone.om.kerberos.principal", (String)socAddr.getHostName());
        LOG.info("Ozone Manager login successful.");
    }

    private static ScmBlockLocationProtocol getScmBlockClient(OzoneConfiguration conf) {
        return HAUtils.getScmBlockClient((OzoneConfiguration)conf);
    }

    private static StorageContainerLocationProtocol getScmContainerClient(OzoneConfiguration conf) {
        return HAUtils.getScmContainerClient((ConfigurationSource)conf);
    }

    private RPC.Server getRpcServer(OzoneConfiguration conf) throws IOException {
        if (this.isOmRpcServerRunning) {
            return this.omRpcServer;
        }
        LOG.info("Creating RPC Server");
        InetSocketAddress omNodeRpcAddr = OmUtils.getOmAddress((ConfigurationSource)conf);
        boolean flexibleFqdnResolutionEnabled = conf.getBoolean("ozone.network.flexible.fqdn.resolution.enabled", false);
        if (flexibleFqdnResolutionEnabled && omNodeRpcAddr.getAddress() == null) {
            omNodeRpcAddr = OzoneNetUtils.getAddressWithHostNameLocal((InetSocketAddress)omNodeRpcAddr);
        }
        int handlerCount = conf.getInt("ozone.om.handler.count.key", 100);
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.omServerProtocol = new OzoneManagerProtocolServerSideTranslatorPB(this, this.omRatisServer, this.omClientProtocolMetrics, this.isRatisEnabled, this.getLastTrxnIndexForNonRatis());
        BlockingService omService = OzoneManagerProtocolProtos.OzoneManagerService.newReflectiveBlockingService((OzoneManagerProtocolProtos.OzoneManagerService.BlockingInterface)this.omServerProtocol);
        OMInterServiceProtocolServerSideImpl omInterServerProtocol = new OMInterServiceProtocolServerSideImpl(this, this.omRatisServer, this.isRatisEnabled);
        BlockingService omInterService = OzoneManagerInterServiceProtocolProtos.OzoneManagerInterService.newReflectiveBlockingService((OzoneManagerInterServiceProtocolProtos.OzoneManagerInterService.BlockingInterface)omInterServerProtocol);
        OMAdminProtocolServerSideImpl omMetadataServerProtocol = new OMAdminProtocolServerSideImpl(this);
        BlockingService omAdminService = OzoneManagerAdminProtocolProtos.OzoneManagerAdminService.newReflectiveBlockingService((OzoneManagerAdminProtocolProtos.OzoneManagerAdminService.BlockingInterface)omMetadataServerProtocol);
        ReconfigureProtocolServerSideTranslatorPB reconfigureServerProtocol = new ReconfigureProtocolServerSideTranslatorPB((ReconfigureProtocol)this.reconfigurationHandler);
        BlockingService reconfigureService = ReconfigureProtocolProtos.ReconfigureProtocolService.newReflectiveBlockingService((ReconfigureProtocolProtos.ReconfigureProtocolService.BlockingInterface)reconfigureServerProtocol);
        return this.startRpcServer(this.configuration, omNodeRpcAddr, omService, omInterService, omAdminService, reconfigureService, handlerCount);
    }

    private RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, BlockingService clientProtocolService, BlockingService interOMProtocolService, BlockingService omAdminProtocolService, BlockingService reconfigureProtocolService, int handlerCount) throws IOException {
        RPC.Server rpcServer = (RPC.Server)HddsUtils.preserveThreadName(() -> new RPC.Builder((Configuration)conf).setProtocol(OzoneManagerProtocolPB.class).setInstance((Object)clientProtocolService).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager((SecretManager)this.delegationTokenMgr).build());
        HddsServerUtil.addPBProtocol((Configuration)conf, OMInterServiceProtocolPB.class, (BlockingService)interOMProtocolService, (RPC.Server)rpcServer);
        HddsServerUtil.addPBProtocol((Configuration)conf, OMAdminProtocolPB.class, (BlockingService)omAdminProtocolService, (RPC.Server)rpcServer);
        HddsServerUtil.addPBProtocol((Configuration)conf, ReconfigureProtocolPB.class, (BlockingService)reconfigureProtocolService, (RPC.Server)rpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            rpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)OMPolicyProvider.getInstance());
        }
        rpcServer.addSuppressedLoggingExceptions(new Class[]{OMNotLeaderException.class, OMLeaderNotReadyException.class});
        return rpcServer;
    }

    private GrpcOzoneManagerServer startGrpcServer(OzoneConfiguration conf) {
        return new GrpcOzoneManagerServer(conf, this.omServerProtocol, this.delegationTokenMgr, this.certClient, this.threadPrefix);
    }

    private static boolean isOzoneSecurityEnabled() {
        return securityEnabled;
    }

    private static void loginOMUserIfSecurityEnabled(OzoneConfiguration conf) throws IOException, AuthenticationException {
        securityEnabled = OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf);
        if (securityEnabled && testUgi == null) {
            new SecurityConfig((ConfigurationSource)conf);
            OzoneManager.loginOMUser(conf);
        }
    }

    @VisibleForTesting
    public static boolean omInit(OzoneConfiguration conf) throws IOException, AuthenticationException {
        String scmId;
        OMHANodeDetails omhaNodeDetails = OMHANodeDetails.loadOMHAConfig(conf);
        String nodeId = omhaNodeDetails.getLocalNodeDetails().getNodeId();
        OzoneManager.loginOMUserIfSecurityEnabled(conf);
        OMStorage omStorage = new OMStorage(conf);
        Storage.StorageState state = omStorage.getState();
        try {
            ScmInfo scmInfo = HAUtils.getScmInfo((OzoneConfiguration)conf);
            scmId = scmInfo.getScmId();
            if (scmId == null || scmId.isEmpty()) {
                throw new IOException("Invalid SCM ID");
            }
            String clusterId = scmInfo.getClusterId();
            if (clusterId == null || clusterId.isEmpty()) {
                throw new IOException("Invalid Cluster ID");
            }
            if (state != Storage.StorageState.INITIALIZED) {
                omStorage.setOmNodeId(nodeId);
                omStorage.setClusterId(clusterId);
                omStorage.initialize();
                System.out.println("OM initialization succeeded.Current cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID() + ";layoutVersion=" + omStorage.getLayoutVersion());
            } else {
                System.out.println("OM already initialized.Reusing existing cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID() + ";layoutVersion=" + omStorage.getLayoutVersion());
            }
        }
        catch (IOException ioe) {
            LOG.error("Could not initialize OM version file", (Throwable)ioe);
            return false;
        }
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
            LOG.info("OM storage initialized. Initializing security");
            OzoneManager.initializeSecurity(conf, omStorage, scmId);
        }
        omStorage.persistCurrentState();
        return true;
    }

    @VisibleForTesting
    public static void initializeSecurity(OzoneConfiguration conf, OMStorage omStore, String scmId) throws IOException {
        LOG.info("Initializing secure OzoneManager.");
        HddsProtos.OzoneManagerDetailsProto omInfo = OzoneManager.getOmDetailsProto((ConfigurationSource)conf, omStore.getOmId());
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)conf, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        OMCertificateClient certClient = new OMCertificateClient(new SecurityConfig((ConfigurationSource)conf), scmSecurityClient, omStore, omInfo, "", scmId, certId -> {
            try {
                omStore.setOmCertSerialId((String)certId);
            }
            catch (IOException e) {
                LOG.error("Failed to set new certificate ID", (Throwable)e);
                throw new RuntimeException("Failed to set new certificate ID");
            }
        }, null);
        certClient.initWithRecovery();
    }

    private void initializeRatisDirs(OzoneConfiguration conf) throws IOException {
        if (this.isRatisEnabled) {
            String omRatisDirectory = OzoneManagerRatisUtils.getOMRatisDirectory((ConfigurationSource)conf);
            if (omRatisDirectory == null || omRatisDirectory.isEmpty()) {
                throw new IllegalArgumentException("ozone.metadata.dirs must be defined.");
            }
            OmUtils.createOMDir((String)omRatisDirectory);
            String scmStorageDir = SCMHAUtils.getRatisStorageDir((ConfigurationSource)conf);
            if (!Strings.isNullOrEmpty((String)omRatisDirectory) && !Strings.isNullOrEmpty((String)scmStorageDir) && omRatisDirectory.equals(scmStorageDir)) {
                throw new IOException("Path of ozone.om.ratis.storage.dir and ozone.scm.ha.ratis.storage.dir should not be co located. Please change atleast one path.");
            }
            this.omRatisSnapshotDir = OmUtils.createOMDir((String)OzoneManagerRatisUtils.getOMRatisSnapshotDirectory((ConfigurationSource)conf));
            File snapshotDir = new File(omRatisDirectory, "snapshot");
            if (snapshotDir.isDirectory()) {
                FileUtils.moveDirectory((Path)snapshotDir.toPath(), (Path)this.omRatisSnapshotDir.toPath());
            }
            File omRatisDir = new File(omRatisDirectory);
            String groupIDfromServiceID = RaftGroupId.valueOf((UUID)OzoneManagerRatisServer.getRaftGroupIdFromOmServiceId(this.getOMServiceId())).getUuid().toString();
            File[] ratisDirFiles = omRatisDir.listFiles();
            if (ratisDirFiles != null) {
                File[] fileArray = ratisDirFiles;
                int n = ratisDirFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File ratisGroupDir = fileArray[n2];
                    if (ratisGroupDir.isDirectory()) {
                        if (!ratisGroupDir.getName().equals(groupIDfromServiceID)) {
                            throw new IOException("Ratis group Dir on disk " + ratisGroupDir.getName() + " does not match with RaftGroupID" + groupIDfromServiceID + " generated from service id " + this.getOMServiceId() + ". Looks like there is a change to " + "ozone.om.service.ids" + " value after the " + "cluster is setup. Currently change to this value is not " + "supported.");
                        }
                    } else {
                        LOG.warn("Unknown file {} exists in ratis storage dir {}. It is recommended not to share the ratis storage dir.", (Object)ratisGroupDir, (Object)omRatisDir);
                    }
                    ++n2;
                }
            }
            if (this.peerNodesMap != null && !this.peerNodesMap.isEmpty()) {
                this.omRatisSnapshotProvider = new OmRatisSnapshotProvider((MutableConfigurationSource)this.configuration, this.omRatisSnapshotDir, this.peerNodesMap);
            }
        }
    }

    private static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr) : String.format("%s not started", description);
    }

    @VisibleForTesting
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    @VisibleForTesting
    public OMStorage getOmStorage() {
        return this.omStorage;
    }

    @VisibleForTesting
    public OzoneManagerRatisServer getOmRatisServer() {
        return this.omRatisServer;
    }

    @VisibleForTesting
    public OmRatisSnapshotProvider getOmSnapshotProvider() {
        return this.omRatisSnapshotProvider;
    }

    @VisibleForTesting
    public InetSocketAddress getOmRpcServerAddr() {
        return this.omRpcAddress;
    }

    @VisibleForTesting
    public LifeCycle.State getOmRatisServerState() {
        if (this.omRatisServer == null) {
            return null;
        }
        return this.omRatisServer.getServerState();
    }

    @VisibleForTesting
    public KeyProviderCryptoExtension getKmsProvider() {
        return this.kmsProvider;
    }

    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }

    public VolumeManager getVolumeManager() {
        return this.volumeManager;
    }

    public BucketManager getBucketManager() {
        return this.bucketManager;
    }

    public IAccessAuthorizer getAccessAuthorizer() {
        return this.accessAuthorizer;
    }

    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public S3SecretManager getS3SecretManager() {
        return this.s3SecretManager;
    }

    public OmSnapshotManager getOmSnapshotManager() {
        return this.omSnapshotManager;
    }

    public OMMultiTenantManager getMultiTenantManager() {
        return this.multiTenantManager;
    }

    public OzoneBlockTokenSecretManager getBlockTokenMgr() {
        return this.blockTokenMgr;
    }

    public OzoneManagerProtocolServerSideTranslatorPB getOmServerProtocol() {
        return this.omServerProtocol;
    }

    public OMMetrics getMetrics() {
        return this.metrics;
    }

    public OMPerformanceMetrics getPerfMetrics() {
        return this.perfMetrics;
    }

    public void start() throws IOException {
        if (this.omState == State.BOOTSTRAPPING) {
            if (this.isBootstrapping) {
                this.checkConfigBeforeBootstrap();
            } else if (this.isForcedBootstrapping) {
                LOG.warn("Skipped checking whether existing OM configs have been updated with this OM information as force bootstrap is called.");
            }
        }
        this.omClientProtocolMetrics.register();
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"OzoneManager");
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        this.metadataManager.start(this.configuration);
        if (this.omRatisServer != null) {
            this.omRatisServer.start();
        }
        this.startSecretManagerIfNecessary();
        this.upgradeFinalizer.runPrefinalizeStateActions((Storage)this.omStorage, (Object)this);
        Integer layoutVersionInDB = this.getLayoutVersionInDB();
        if (layoutVersionInDB == null || this.versionManager.getMetadataLayoutVersion() != layoutVersionInDB.intValue()) {
            LOG.info("Version File has different layout version ({}) than OM DB ({}). That is expected if this OM has never been finalized to a newer layout version.", (Object)this.versionManager.getMetadataLayoutVersion(), (Object)layoutVersionInDB);
        }
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        this.metrics.setNumDirs(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getDirectoryTable()));
        this.metrics.setNumFiles(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getFileTable()));
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.keyManager.start(this.configuration);
        try {
            this.httpServer = new OzoneManagerHttpServer((MutableConfigurationSource)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        this.startTrashEmptier((Configuration)this.configuration);
        if (this.isOmGrpcServerEnabled) {
            this.omS3gGrpcServer.start();
            this.isOmGrpcServerRunning = true;
        }
        this.registerMXBean();
        this.startJVMPauseMonitor();
        this.setStartTime();
        if (this.omState == State.BOOTSTRAPPING) {
            this.bootstrap(this.omNodeDetails);
        }
        this.omState = State.RUNNING;
    }

    public void restart() throws IOException {
        this.setInstanceVariablesFromConf();
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"OzoneManager");
        this.instantiateServices(false);
        this.metadataManager.start(this.configuration);
        this.keyManager.start(this.configuration);
        this.startSecretManagerIfNecessary();
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        this.metrics.setNumDirs(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getDirectoryTable()));
        this.metrics.setNumFiles(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getFileTable()));
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.initializeRatisServer(false);
        if (this.omRatisServer != null) {
            this.omRatisServer.start();
        }
        this.omRpcServer = this.getRpcServer(this.configuration);
        if (this.isOmGrpcServerEnabled) {
            this.omS3gGrpcServer = this.getOmS3gGrpcServer(this.configuration);
        }
        try {
            this.httpServer = new OzoneManagerHttpServer((MutableConfigurationSource)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        this.startTrashEmptier((Configuration)this.configuration);
        this.registerMXBean();
        if (this.isOmGrpcServerEnabled) {
            this.omS3gGrpcServer.start();
            this.isOmGrpcServerRunning = true;
        }
        this.startJVMPauseMonitor();
        this.setStartTime();
        this.omState = State.RUNNING;
    }

    private void updateActiveSnapshotMetrics() throws IOException {
        long activeGauge = 0L;
        long deletedGauge = 0L;
        Throwable throwable = null;
        Object var6_5 = null;
        try (TableIterator keyIter = this.metadataManager.getSnapshotInfoTable().iterator();){
            while (keyIter.hasNext()) {
                SnapshotInfo info = (SnapshotInfo)((Table.KeyValue)keyIter.next()).getValue();
                SnapshotInfo.SnapshotStatus snapshotStatus = info.getSnapshotStatus();
                if (snapshotStatus == SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) {
                    ++activeGauge;
                    continue;
                }
                if (snapshotStatus != SnapshotInfo.SnapshotStatus.SNAPSHOT_DELETED) continue;
                ++deletedGauge;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.metrics.setNumSnapshotActive(activeGauge);
        this.metrics.setNumSnapshotDeleted(deletedGauge);
    }

    private void checkConfigBeforeBootstrap() throws IOException {
        ArrayList<OMNodeDetails> omsWithoutNewConfig = new ArrayList<OMNodeDetails>();
        for (Map.Entry<String, OMNodeDetails> entry : this.peerNodesMap.entrySet()) {
            String remoteNodeId = entry.getKey();
            OMNodeDetails remoteNodeDetails = entry.getValue();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (OMAdminProtocolClientSideImpl omAdminProtocolClient = OMAdminProtocolClientSideImpl.createProxyForSingleOM((OzoneConfiguration)this.configuration, (UserGroupInformation)HddsServerUtil.getRemoteUser(), (OMNodeDetails)entry.getValue());){
                    OMConfiguration remoteOMConfiguration = omAdminProtocolClient.getOMConfiguration();
                    this.checkRemoteOMConfig(remoteNodeId, remoteOMConfiguration);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                LOG.error("Remote OM config check failed on OM {}", (Object)remoteNodeId, (Object)ioe);
                omsWithoutNewConfig.add(remoteNodeDetails);
            }
        }
        if (!omsWithoutNewConfig.isEmpty()) {
            String errorMsg = String.valueOf(OmUtils.getOMAddressListPrintString(omsWithoutNewConfig)) + " do not have or have incorrect information of the bootstrapping " + "OM. Update their ozone-site.xml before proceeding.";
            this.exitManager.exitSystem(1, errorMsg, LOG);
        }
    }

    private void checkRemoteOMConfig(String remoteNodeId, OMConfiguration remoteOMConfig) throws IOException {
        OMNodeDetails omNodeDetailsInRemoteConfig;
        if (remoteOMConfig == null) {
            throw new IOException("Remote OM " + remoteNodeId + " configuration " + "returned null");
        }
        if (remoteOMConfig.getCurrentPeerList().contains(this.getOMNodeId())) {
            LOG.warn("Remote OM {} already contains bootstrapping OM({}) as part of its Raft group peers.", (Object)remoteNodeId, (Object)this.getOMNodeId());
        }
        if ((omNodeDetailsInRemoteConfig = (OMNodeDetails)remoteOMConfig.getActiveOmNodesInNewConf().get(this.getOMNodeId())) == null) {
            throw new IOException("Remote OM " + remoteNodeId + " does not have the" + " bootstrapping OM(" + this.getOMNodeId() + ") information on reloading " + "configs or it could not resolve the address.");
        }
        if (!omNodeDetailsInRemoteConfig.getRpcAddress().equals(this.omNodeDetails.getRpcAddress())) {
            throw new IOException("Remote OM " + remoteNodeId + " configuration has" + " bootstrapping OM(" + this.getOMNodeId() + ") address as " + omNodeDetailsInRemoteConfig.getRpcAddress() + " where the " + "bootstrapping OM address is " + this.omNodeDetails.getRpcAddress());
        }
        if (omNodeDetailsInRemoteConfig.isDecommissioned()) {
            throw new IOException("Remote OM " + remoteNodeId + " configuration has" + " bootstrapping OM(" + this.getOMNodeId() + ") in decommissioned " + "nodes list - " + "ozone.om.decommissioned.nodes");
        }
    }

    public void bootstrap(OMNodeDetails newOMNode) throws IOException {
        block12: {
            if (this.isRatisEnabled) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (OMInterServiceProtocolClientSideImpl omInterServiceProtocol = new OMInterServiceProtocolClientSideImpl((ConfigurationSource)this.configuration, HddsServerUtil.getRemoteUser(), this.getOMServiceId());){
                        omInterServiceProtocol.bootstrap(this.omNodeDetails);
                        LOG.info("Successfully bootstrapped OM {} and joined the Ratis group {}", (Object)this.getOMNodeId(), (Object)this.omRatisServer.getRaftGroup());
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOG.error("Failed to Bootstrap OM.");
                    throw e;
                }
            }
            throw new IOException("OzoneManager can be bootstrapped only when ratis is enabled and there is atleast one OzoneManager to bootstrap from.");
        }
    }

    public void updatePeerList(List<String> newPeers) {
        List<String> currentPeers = this.omRatisServer.getPeerIds();
        ArrayList<String> bootstrappedOMs = new ArrayList<String>(newPeers);
        bootstrappedOMs.removeAll(currentPeers);
        ArrayList<String> decommissionedOMs = new ArrayList<String>(currentPeers);
        decommissionedOMs.removeAll(newPeers);
        for (String omNodeId : bootstrappedOMs) {
            if (this.isCurrentNode(omNodeId)) {
                for (String peerNodeId : newPeers) {
                    if (peerNodeId.equals(omNodeId)) {
                        this.omRatisServer.addRaftPeer(this.omNodeDetails);
                        continue;
                    }
                    this.omRatisServer.addRaftPeer(this.peerNodesMap.get(peerNodeId));
                }
                continue;
            }
            try {
                this.addOMNodeToPeers(omNodeId);
            }
            catch (IOException e) {
                LOG.error("Fatal Error while adding bootstrapped node to peer list. Shutting down the system as otherwise it could lead to OM state divergence.", (Throwable)e);
                this.exitManager.forceExit(1, (Exception)e, LOG);
            }
        }
        for (String omNodeId : decommissionedOMs) {
            if (this.isCurrentNode(omNodeId)) {
                LOG.warn("New OM node Id: {} is same as decommissioned earlier", (Object)omNodeId);
                continue;
            }
            try {
                this.removeOMNodeFromPeers(omNodeId);
            }
            catch (IOException e) {
                LOG.error("Fatal Error while removing decommissioned node from peer list. Shutting down the system as otherwise it could lead to OM state divergence.", (Throwable)e);
                this.exitManager.forceExit(1, (Exception)e, LOG);
            }
        }
    }

    private boolean isCurrentNode(String omNodeID) {
        return this.getOMNodeId().equals(omNodeID);
    }

    private void addOMNodeToPeers(String newOMNodeId) throws IOException {
        OMNodeDetails newOMNodeDetails = null;
        try {
            newOMNodeDetails = OMNodeDetails.getOMNodeDetailsFromConf((OzoneConfiguration)this.getConfiguration(), (String)this.getOMServiceId(), (String)newOMNodeId);
            if (newOMNodeDetails == null) {
                this.setConfiguration(this.reloadConfiguration());
                newOMNodeDetails = OMNodeDetails.getOMNodeDetailsFromConf((OzoneConfiguration)this.getConfiguration(), (String)this.getOMServiceId(), (String)newOMNodeId);
                if (newOMNodeDetails == null) {
                    LOG.error("There is no OM configuration for node ID {} in ozone-site.xml.", (Object)newOMNodeId);
                    return;
                }
            }
        }
        catch (IOException iOException) {
            LOG.error("{}: Couldn't add OM {} to peer list.", (Object)this.getOMNodeId(), (Object)newOMNodeId);
        }
        if (this.omRatisSnapshotProvider == null) {
            this.omRatisSnapshotProvider = new OmRatisSnapshotProvider((MutableConfigurationSource)this.configuration, this.omRatisSnapshotDir, this.peerNodesMap);
        } else {
            this.omRatisSnapshotProvider.addNewPeerNode(newOMNodeDetails);
        }
        this.omRatisServer.addRaftPeer(newOMNodeDetails);
        this.peerNodesMap.put(newOMNodeId, newOMNodeDetails);
        LOG.info("Added OM {} to the Peer list.", (Object)newOMNodeId);
    }

    private void removeOMNodeFromPeers(String decommNodeId) throws IOException {
        OMNodeDetails decommOMNodeDetails = this.peerNodesMap.get(decommNodeId);
        if (decommOMNodeDetails == null) {
            throw new IOException("Decommissioned Node " + decommNodeId + " not " + "present in peer list");
        }
        this.omRatisSnapshotProvider.removeDecommissionedPeerNode(decommNodeId);
        this.omRatisServer.removeRaftPeer(decommOMNodeDetails);
        this.peerNodesMap.remove(decommNodeId);
        LOG.info("Removed OM {} from OM Peer Nodes.", (Object)decommNodeId);
    }

    @VisibleForTesting
    public boolean doesPeerExist(String omNodeId) {
        if (this.getOMNodeId().equals(omNodeId)) {
            return true;
        }
        if (this.peerNodesMap != null && !this.peerNodesMap.isEmpty()) {
            return this.peerNodesMap.containsKey(omNodeId);
        }
        return false;
    }

    public List<OMNodeDetails> getAllOMNodesInMemory() {
        List<OMNodeDetails> peerNodes = this.getPeerNodes();
        peerNodes.add(this.omNodeDetails);
        return peerNodes;
    }

    public List<OMNodeDetails> getAllOMNodesInNewConf() {
        OzoneConfiguration newConf = this.reloadConfiguration();
        List allOMNodeDetails = OmUtils.getAllOMHAAddresses((OzoneConfiguration)newConf, (String)this.getOMServiceId(), (boolean)true);
        if (allOMNodeDetails.isEmpty()) {
            return Collections.singletonList(this.omNodeDetails);
        }
        return allOMNodeDetails;
    }

    private void startTrashEmptier(Configuration conf) throws IOException {
        if (this.emptier == null) {
            float hadoopTrashInterval = conf.getFloat("fs.trash.interval", 0.0f);
            long trashInterval = (long)(conf.getFloat("ozone.fs.trash.interval", hadoopTrashInterval) * 60000.0f);
            if (trashInterval == 0L) {
                LOG.info("Trash Interval set to 0. Files deleted won't move to trash");
                return;
            }
            if (trashInterval < 0L) {
                throw new IOException("Cannot start trash emptier with negative interval. Set fs.trash.interval to a positive value.");
            }
            OzoneManager i = this;
            FileSystem fs = (FileSystem)SecurityUtil.doAsLoginUser(() -> new TrashOzoneFileSystem(i));
            this.emptier = new Thread(new OzoneTrash(fs, conf, this).getEmptier(), String.valueOf(this.threadPrefix) + "TrashEmptier");
            this.emptier.setDaemon(true);
            this.emptier.start();
        }
    }

    private GrpcOzoneManagerServer getOmS3gGrpcServer(OzoneConfiguration conf) {
        if (this.isOmGrpcServerRunning) {
            return this.omS3gGrpcServer;
        }
        return this.startGrpcServer(this.configuration);
    }

    private void initializeRatisServer(boolean shouldBootstrap) throws IOException {
        if (this.isRatisEnabled) {
            if (this.omRatisServer == null) {
                this.ratisReporterList = RatisDropwizardExports.registerRatisMetricReporters(this.ratisMetricsMap, this::isStopped);
                this.omRatisServer = OzoneManagerRatisServer.newOMRatisServer((ConfigurationSource)this.configuration, this, this.omNodeDetails, this.peerNodesMap, this.secConfig, this.certClient, shouldBootstrap);
            }
            LOG.info("OzoneManager Ratis server initialized at port {}", (Object)this.omRatisServer.getServerPort());
        } else {
            this.omRatisServer = null;
        }
    }

    public long getObjectIdFromTxId(long trxnId) {
        return OmUtils.getObjectIdFromTxId((long)this.metadataManager.getOmEpoch(), (long)trxnId);
    }

    @VisibleForTesting
    long getLastTrxnIndexForNonRatis() throws IOException {
        TransactionInfo transactionInfo = TransactionInfo.readTransactionInfo((DBStoreHAManager)this.metadataManager);
        if (transactionInfo == null || transactionInfo.getTerm() != -1L) {
            return 0L;
        }
        return transactionInfo.getTransactionIndex();
    }

    private Integer getLayoutVersionInDB() throws IOException {
        String layoutVersion = (String)this.metadataManager.getMetaTable().get((Object)"#LAYOUTVERSION");
        return layoutVersion == null ? null : Integer.valueOf(Integer.parseInt(layoutVersion));
    }

    public RatisSnapshotInfo getSnapshotInfo() {
        return this.omRatisSnapshotInfo;
    }

    public long getRatisSnapshotIndex() throws IOException {
        TransactionInfo dbTxnInfo = TransactionInfo.readTransactionInfo((DBStoreHAManager)this.metadataManager);
        if (dbTxnInfo == null) {
            return 0L;
        }
        return dbTxnInfo.getTransactionIndex();
    }

    public boolean stop() {
        LOG.info("{}: Stopping Ozone Manager", (Object)this.omNodeDetails.getOMPrintInfo());
        if (this.isStopped()) {
            return false;
        }
        try {
            this.omState = State.STOPPED;
            if (this.metricsTimer != null) {
                this.metricsTimer.cancel();
                this.metricsTimer = null;
                this.scheduleOMMetricsWriteTask = null;
            }
            this.omRpcServer.stop();
            if (this.isOmGrpcServerEnabled) {
                this.omS3gGrpcServer.stop();
            }
            if (!this.isRatisEnabled) {
                this.omServerProtocol.stop();
            }
            if (this.omRatisServer != null) {
                this.omRatisServer.stop();
                OMHAMetrics.unRegister();
            }
            this.isOmRpcServerRunning = false;
            if (this.isOmGrpcServerEnabled) {
                this.isOmGrpcServerRunning = false;
            }
            this.keyManager.stop();
            this.stopSecretManager();
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            if (this.multiTenantManager != null) {
                this.multiTenantManager.stop();
            }
            this.stopTrashEmptier();
            this.metadataManager.stop();
            this.omSnapshotManager.close();
            this.metrics.unRegister();
            this.omClientProtocolMetrics.unregister();
            this.unregisterMXBean();
            if (this.jvmPauseMonitor != null) {
                this.jvmPauseMonitor.stop();
            }
            if (this.omRatisSnapshotProvider != null) {
                this.omRatisSnapshotProvider.close();
            }
            OMPerformanceMetrics.unregister();
            RatisDropwizardExports.clear(this.ratisMetricsMap, this.ratisReporterList);
            this.scmClient.close();
            if (this.certClient != null) {
                this.certClient.close();
            }
            if (this.omhaMetrics != null) {
                OMHAMetrics.unRegister();
            }
            this.omRatisServer = null;
            return true;
        }
        catch (Exception e) {
            LOG.error("OzoneManager stop failed.", (Throwable)e);
            return false;
        }
    }

    public void shutDown(String message) {
        this.stop();
        ExitUtils.terminate((int)0, (String)message, (Logger)LOG);
    }

    public void terminateOM() {
        this.stop();
        ExitUtil.terminate((int)1);
    }

    public void join() {
        try {
            this.omRpcServer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during OzoneManager join.", (Throwable)e);
        }
    }

    private void startSecretManagerIfNecessary() {
        boolean running;
        boolean shouldRun = OzoneManager.isOzoneSecurityEnabled();
        if (shouldRun && !(running = this.delegationTokenMgr.isRunning())) {
            this.startSecretManager();
        }
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws OMException {
        block6: {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be issued only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            if (this.delegationTokenMgr != null && this.delegationTokenMgr.isRunning()) break block6;
            LOG.warn("trying to get DT with no secret manager running in OM.");
            return null;
        }
        try {
            UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            return this.delegationTokenMgr.createToken(owner, renewer, realUser);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Get Delegation token failed, cause: {}", (Object)ex.getMessage());
            throw new OMException("Get Delegation token failed.", (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        long expiryTime;
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be renewed only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            String renewer = HddsServerUtil.getRemoteUser().getShortUserName();
            expiryTime = this.delegationTokenMgr.renewToken(token, renewer);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            OzoneTokenIdentifier id = null;
            try {
                id = OzoneTokenIdentifier.readProtoBuf((byte[])token.getIdentifier());
            }
            catch (IOException iOException) {}
            LOG.error("Delegation token renewal failed for dt id: {}, cause: {}", (Object)id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
        return expiryTime;
    }

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        OzoneTokenIdentifier id = null;
        try {
            String canceller = HddsServerUtil.getRemoteUser().getUserName();
            id = this.delegationTokenMgr.cancelToken(token, canceller);
            LOG.trace("Delegation token cancelled for dt: {}", (Object)id);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Delegation token cancellation failed for dt id: {}, cause: {}", id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public boolean isOwner(UserGroupInformation callerUgi, String ownerName) {
        if (ownerName == null) {
            return false;
        }
        return callerUgi.getUserName().equals(ownerName) || callerUgi.getShortUserName().equals(ownerName);
    }

    private boolean hasAcls(String userName, OzoneObj.ResourceType resType, OzoneObj.StoreType store, IAccessAuthorizer.ACLType acl, String vol, String bucket, String key) {
        try {
            return this.checkAcls(resType, store, acl, vol, bucket, key, UserGroupInformation.createRemoteUser((String)userName), ProtobufRpcEngine.Server.getRemoteIp(), ProtobufRpcEngine.Server.getRemoteIp().getHostName(), false, this.getVolumeOwner(vol, acl, resType));
        }
        catch (OMException oMException) {
            return false;
        }
    }

    public String getVolumeOwner(String vol, IAccessAuthorizer.ACLType type, OzoneObj.ResourceType resType) throws OMException {
        String volOwnerName = null;
        if (!(vol.equals("/") || type == IAccessAuthorizer.ACLType.CREATE && resType == OzoneObj.ResourceType.VOLUME)) {
            volOwnerName = this.getVolumeOwner(vol);
        }
        return volOwnerName;
    }

    private String getVolumeOwner(String volume) throws OMException {
        OmVolumeArgs volumeArgs;
        OMLockDetails omLockDetails = this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        boolean lockAcquired = omLockDetails.isLockAcquired();
        String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
        try {
            try {
                volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            }
            catch (IOException ioe) {
                if (ioe instanceof OMException) {
                    throw (OMException)((Object)ioe);
                }
                throw new OMException("getVolumeOwner for Volume " + volume + " failed", OMException.ResultCodes.INTERNAL_ERROR);
            }
        }
        catch (Throwable throwable) {
            if (lockAcquired) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
            }
            throw throwable;
        }
        if (lockAcquired) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volume});
        }
        if (volumeArgs != null) {
            return volumeArgs.getOwnerName();
        }
        throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
    }

    public String getBucketOwner(String volume, String bucket, IAccessAuthorizer.ACLType type, OzoneObj.ResourceType resType) throws OMException {
        String bucketOwner = null;
        if (resType != OzoneObj.ResourceType.VOLUME && (type != IAccessAuthorizer.ACLType.CREATE || resType != OzoneObj.ResourceType.BUCKET)) {
            bucketOwner = this.getBucketOwner(volume, bucket);
        }
        return bucketOwner;
    }

    private String getBucketOwner(String volume, String bucket) throws OMException {
        OmBucketInfo bucketInfo;
        OMLockDetails omLockDetails = this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        boolean lockAcquired = omLockDetails.isLockAcquired();
        try {
            try {
                String dbBucketKey = this.metadataManager.getBucketKey(volume, bucket);
                bucketInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)dbBucketKey);
            }
            catch (IOException ioe) {
                if (ioe instanceof OMException) {
                    throw (OMException)((Object)ioe);
                }
                throw new OMException("getBucketOwner for Bucket " + volume + "/" + bucket + " failed: " + ioe.getMessage(), OMException.ResultCodes.INTERNAL_ERROR);
            }
        }
        catch (Throwable throwable) {
            if (lockAcquired) {
                this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
            }
            throw throwable;
        }
        if (lockAcquired) {
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket});
        }
        if (bucketInfo != null) {
            return bucketInfo.getOwner();
        }
        throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
    }

    public boolean checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key, UserGroupInformation ugi, InetAddress remoteAddress, String hostName, boolean throwIfPermissionDenied, String owner) throws OMException {
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setResType(resType).setStoreType(storeType).setVolumeName(vol).setBucketName(bucket).setKeyName(key).build();
        RequestContext context = RequestContext.newBuilder().setClientUgi(ugi).setIp(remoteAddress).setHost(hostName).setAclType(IAccessAuthorizer.ACLIdentityType.USER).setAclRights(aclType).setOwnerName(owner).build();
        return this.omMetadataReader.checkAcls((OzoneObj)obj, context, throwIfPermissionDenied);
    }

    public boolean getAclsEnabled() {
        return this.isAclEnabled;
    }

    public boolean getAllowListAllVolumes() {
        return this.allowListAllVolumes;
    }

    public ReferenceCounted<IOmMetadataReader> getOmMetadataReader() {
        return this.rcOmMetadataReader;
    }

    public boolean isSpnegoEnabled() {
        return this.isSpnegoEnabled;
    }

    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        try {
            if (this.isAclEnabled) {
                this.omMetadataReader.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, null, null);
            }
            this.metrics.incNumVolumeInfos();
            OmVolumeArgs omVolumeArgs = this.volumeManager.getVolumeInfo(volume);
            return omVolumeArgs;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.READ_VOLUME, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.READ_VOLUME, auditMap));
            }
        }
    }

    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        UserGroupInformation remoteUserUgi = ProtobufRpcEngine.Server.getRemoteUser();
        if (this.isAclEnabled && remoteUserUgi == null) {
            LOG.error("Rpc user UGI is null. Authorization failed.");
            throw new OMException("Rpc user UGI is null. Authorization failed.", OMException.ResultCodes.PERMISSION_DENIED);
        }
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", userName);
        try {
            this.metrics.incNumVolumeLists();
            if (this.isAclEnabled) {
                String remoteUserName = remoteUserUgi.getShortUserName();
                if (!remoteUserName.equals(userName) && !this.isAdmin(remoteUserUgi)) {
                    this.omMetadataReader.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, "/", null, null);
                }
                List<OmVolumeArgs> listAllVolumes = this.volumeManager.listVolumes(null, prefix, prevKey, maxKeys);
                ArrayList<OmVolumeArgs> result = new ArrayList<OmVolumeArgs>();
                for (OmVolumeArgs volumeArgs : listAllVolumes) {
                    if (!this.hasAcls(userName, OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeArgs.getVolume(), null, null)) continue;
                    result.add(volumeArgs);
                }
                ArrayList<OmVolumeArgs> arrayList = result;
                return arrayList;
            }
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(userName, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", null);
        try {
            this.metrics.incNumVolumeLists();
            if (this.isAclEnabled) {
                this.omMetadataReader.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, "/", null, null);
            }
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(null, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int maxNumOfBuckets, boolean hasSnapshot) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("startKey", startKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxNumOfBuckets", String.valueOf(maxNumOfBuckets));
        auditMap.put("hasSnapshot", String.valueOf(hasSnapshot));
        try {
            if (this.isAclEnabled) {
                this.omMetadataReader.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, null, null);
            }
            this.metrics.incNumBucketLists();
            List<OmBucketInfo> list = this.bucketManager.listBuckets(volumeName, startKey, prefix, maxNumOfBuckets, hasSnapshot);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumBucketListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_BUCKETS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_BUCKETS, auditMap));
            }
        }
    }

    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            if (this.isAclEnabled) {
                this.omMetadataReader.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, bucket, null);
            }
            this.metrics.incNumBucketInfos();
            OmBucketInfo bucketInfo = this.bucketManager.getBucketInfo(volume, bucket);
            if (!bucketInfo.isLink()) {
                OmBucketInfo omBucketInfo = bucketInfo;
                return omBucketInfo;
            }
            ResolvedBucket resolvedBucket = this.resolveBucketLink((Pair<String, String>)Pair.of((Object)bucketInfo.getSourceVolume(), (Object)bucketInfo.getSourceBucket()), true);
            if (!resolvedBucket.isDangling()) {
                OmBucketInfo realBucket = this.bucketManager.getBucketInfo(resolvedBucket.realVolume(), resolvedBucket.realBucket());
                OmBucketInfo omBucketInfo = bucketInfo.toBuilder().setDefaultReplicationConfig(realBucket.getDefaultReplicationConfig()).setIsVersionEnabled(Boolean.valueOf(realBucket.getIsVersionEnabled())).setStorageType(realBucket.getStorageType()).setQuotaInBytes(realBucket.getQuotaInBytes()).setQuotaInNamespace(realBucket.getQuotaInNamespace()).setUsedBytes(realBucket.getUsedBytes()).setUsedNamespace(realBucket.getUsedNamespace()).addAllMetadata(realBucket.getMetadata()).setBucketLayout(realBucket.getBucketLayout()).build();
                return omBucketInfo;
            }
            OmBucketInfo omBucketInfo = bucketInfo;
            return omBucketInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBucketInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.READ_BUCKET, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.READ_BUCKET, auditMap));
            }
        }
    }

    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ReferenceCounted<IOmMetadataReader> rcReader = this.getReader(args);){
            return rcReader.get().lookupKey(args);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public KeyInfoWithVolumeContext getKeyInfo(OmKeyArgs args, boolean assumeS3Context) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ReferenceCounted<IOmMetadataReader> rcReader = this.getReader(args);){
            return rcReader.get().getKeyInfo(args, assumeS3Context);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ListKeysResult listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (ReferenceCounted<IOmMetadataReader> rcReader = this.getReader(volumeName, bucketName, keyPrefix);){
            return rcReader.get().listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ListKeysLightResult listKeysLight(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        ListKeysResult listKeysResult = this.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
        List keys = listKeysResult.getKeys();
        List basicKeysList = keys.stream().map(BasicOmKeyInfo::fromOmKeyInfo).collect(Collectors.toList());
        return new ListKeysLightResult(basicKeysList, listKeysResult.isTruncated());
    }

    public List<RepeatedOmKeyInfo> listTrash(String volumeName, String bucketName, String startKeyName, String keyPrefix, int maxKeys) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("startKey", startKeyName);
        auditMap.put("keyPrefix", keyPrefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        try {
            if (this.isAclEnabled) {
                this.omMetadataReader.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, bucketName, keyPrefix);
            }
            this.metrics.incNumTrashKeyLists();
            List<RepeatedOmKeyInfo> list = this.keyManager.listTrash(volumeName, bucketName, startKeyName, keyPrefix, maxKeys);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumTrashKeyListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_TRASH, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_TRASH, auditMap));
            }
        }
    }

    public SnapshotInfo getSnapshotInfo(String volumeName, String bucketName, String snapshotName) throws IOException {
        this.metrics.incNumSnapshotInfos();
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        try {
            if (this.isAclEnabled) {
                this.omMetadataReader.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volumeName, bucketName, null);
            }
            SnapshotInfo snapshotInfo = this.metadataManager.getSnapshotInfo(volumeName, bucketName, snapshotName);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.SNAPSHOT_INFO, auditMap));
            return snapshotInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumSnapshotInfoFails();
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.SNAPSHOT_INFO, auditMap, ex));
            throw ex;
        }
    }

    public List<SnapshotInfo> listSnapshot(String volumeName, String bucketName, String snapshotPrefix, String prevSnapshot, int maxListResult) throws IOException {
        this.metrics.incNumSnapshotLists();
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        try {
            if (this.isAclEnabled) {
                this.omMetadataReader.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, bucketName, null);
            }
            List snapshotInfoList = this.metadataManager.listSnapshot(volumeName, bucketName, snapshotPrefix, prevSnapshot, maxListResult);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_SNAPSHOT, auditMap));
            return snapshotInfoList;
        }
        catch (Exception ex) {
            this.metrics.incNumSnapshotListFails();
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_SNAPSHOT, auditMap, ex));
            throw ex;
        }
    }

    private Map<String, String> buildAuditMap(String volume) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", volume);
        return auditMap;
    }

    public AuditLogger getAuditLogger() {
        return AUDIT;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return this.omMetadataReader.buildAuditMessageForSuccess(op, auditMap);
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return this.omMetadataReader.buildAuditMessageForFailure(op, auditMap, throwable);
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.omInfoBeanName = HddsUtils.registerWithJmxProperties((String)"OzoneManager", (String)"OzoneManagerInfo", jmxProperties, (Object)this);
    }

    private void unregisterMXBean() {
        if (this.omInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.omInfoBeanName);
            this.omInfoBeanName = null;
        }
    }

    @Override
    public String getRpcPort() {
        return "" + this.omRpcAddress.getPort();
    }

    @Override
    public List<List<String>> getRatisRoles() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> messageException = new ArrayList<String>();
        int port = this.omNodeDetails.getRatisPort();
        if (this.isRatisEnabled) {
            List<ServiceInfo> serviceList;
            RaftPeer leaderId;
            if (this.omRatisServer == null) {
                messageException.add("Server is shutting down");
                resultList.add(messageException);
                return resultList;
            }
            try {
                leaderId = this.omRatisServer.getLeader();
                if (leaderId == null) {
                    LOG.error("No leader found");
                    messageException.add("Exception: Not a Leader");
                    resultList.add(messageException);
                    return resultList;
                }
                serviceList = this.getServiceList();
            }
            catch (IOException e) {
                LOG.error("IO-Exception Occurred", (Throwable)e);
                messageException.add("IO-Exception Occurred, " + e.getMessage());
                resultList.add(messageException);
                return resultList;
            }
            return OmUtils.format(serviceList, (int)port, (String)leaderId.getId().toString());
        }
        messageException.add("Ratis Disabled");
        resultList.add(messageException);
        return resultList;
    }

    public void omHAMetricsInit(String leaderId) {
        OMHAMetrics.unRegister();
        this.omhaMetrics = OMHAMetrics.create(this.getOMNodeId(), leaderId);
    }

    @VisibleForTesting
    public OMHAMetrics getOmhaMetrics() {
        return this.omhaMetrics;
    }

    @Override
    public String getRatisLogDirectory() {
        return OzoneManagerRatisUtils.getOMRatisDirectory((ConfigurationSource)this.configuration);
    }

    @Override
    public String getRocksDbDirectory() {
        return String.valueOf(OMStorage.getOmDbDir((ConfigurationSource)this.configuration));
    }

    @VisibleForTesting
    public OzoneManagerHttpServer getHttpServer() {
        return this.httpServer;
    }

    public List<ServiceInfo> getServiceList() throws IOException {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        ServiceInfo.Builder omServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(this.omRpcAddress.getHostName()).setOmVersion(OzoneManagerVersion.CURRENT).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(this.omRpcAddress.getPort()).build());
        if (this.httpServer != null && this.httpServer.getHttpAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(this.httpServer.getHttpAddress().getPort()).build());
        }
        if (this.httpServer != null && this.httpServer.getHttpsAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTPS).setValue(this.httpServer.getHttpsAddress().getPort()).build());
        }
        OzoneManagerProtocolProtos.OMRoleInfo omRole = OzoneManagerProtocolProtos.OMRoleInfo.newBuilder().setNodeId(this.getOMNodeId()).setServerRole(RaftProtos.RaftPeerRole.LEADER.name()).build();
        omServiceInfoBuilder.setOmRoleInfo(omRole);
        if (this.isRatisEnabled) {
            if (this.omRatisServer != null) {
                omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RATIS).setValue(this.omNodeDetails.getRatisPort()).build());
            }
            for (OMNodeDetails peerNode : this.peerNodesMap.values()) {
                ServiceInfo.Builder peerOmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(peerNode.getHostName()).setOmVersion(OzoneManagerVersion.CURRENT).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(peerNode.getRpcPort()).build());
                OzoneManagerProtocolProtos.OMRoleInfo peerOmRole = OzoneManagerProtocolProtos.OMRoleInfo.newBuilder().setNodeId(peerNode.getNodeId()).setServerRole(RaftProtos.RaftPeerRole.FOLLOWER.name()).build();
                peerOmServiceInfoBuilder.setOmRoleInfo(peerOmRole);
                services.add(peerOmServiceInfoBuilder.build());
            }
        }
        services.add(omServiceInfoBuilder.build());
        Collection scmAddresses = HddsUtils.getScmAddressForClients((ConfigurationSource)this.configuration);
        for (InetSocketAddress scmAddr : scmAddresses) {
            ServiceInfo.Builder scmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.SCM).setHostname(scmAddr.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(scmAddr.getPort()).build());
            services.add(scmServiceInfoBuilder.build());
        }
        this.metrics.incNumGetServiceLists();
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.GET_SERVICE_LIST, new LinkedHashMap<String, String>()));
        return services;
    }

    public ServiceInfoEx getServiceInfo() throws IOException {
        return this.serviceInfo.provide();
    }

    public void transferLeadership(String newLeaderId) throws IOException {
        UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
        if (!this.isAdmin(ugi)) {
            throw new OMException("Only Ozone admins are allowed to transfer raft leadership.", OMException.ResultCodes.PERMISSION_DENIED);
        }
        if (!this.isRatisEnabled) {
            throw new IOException("OM HA not enabled.");
        }
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("newLeaderId", newLeaderId);
        try {
            try {
                RaftPeerId targetPeerId;
                RaftGroupId groupID = this.omRatisServer.getRaftGroup().getGroupId();
                RaftServer.Division division = this.omRatisServer.getServer().getDivision(groupID);
                if (newLeaderId.isEmpty()) {
                    RaftPeer curLeader = this.omRatisServer.getLeader();
                    targetPeerId = division.getGroup().getPeers().stream().filter(a -> !a.equals((Object)curLeader)).findFirst().map(RaftPeer::getId).orElseThrow(() -> new IOException("Cannot find a new leader to transfer leadership."));
                } else {
                    targetPeerId = RaftPeerId.valueOf((String)newLeaderId);
                }
                GrpcTlsConfig tlsConfig = OzoneManagerRatisUtils.createServerTlsConfig(this.secConfig, this.certClient);
                RatisHelper.transferRatisLeadership((ConfigurationSource)this.configuration, (RaftGroup)division.getGroup(), (RaftPeerId)targetPeerId, (GrpcTlsConfig)tlsConfig);
            }
            catch (IOException ex) {
                auditSuccess = false;
                AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.TRANSFER_LEADERSHIP, auditMap, ex));
                throw ex;
            }
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.TRANSFER_LEADERSHIP, auditMap));
            }
        }
    }

    public boolean triggerRangerBGSync(boolean noWait) throws IOException {
        if (!this.isLeaderReady()) {
            throw new OMException("OM is not leader or not ready", OMException.ResultCodes.INVALID_REQUEST);
        }
        UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
        if (!this.isAdmin(ugi)) {
            throw new OMException("Only Ozone admins are allowed to trigger Ranger background sync manually", OMException.ResultCodes.PERMISSION_DENIED);
        }
        OMMultiTenantManager mtManager = this.getMultiTenantManager();
        if (mtManager == null) {
            throw new OMException("S3 Multi-Tenancy is not enabled", OMException.ResultCodes.FEATURE_NOT_ENABLED);
        }
        OMRangerBGSyncService bgSync = mtManager.getOMRangerBGSyncService();
        if (bgSync == null) {
            throw new OMException("Ranger background sync service is not initialized", OMException.ResultCodes.FEATURE_NOT_ENABLED);
        }
        if (noWait) {
            Thread t = new Thread(bgSync::triggerRangerSyncOnce, String.valueOf(this.threadPrefix) + "RangerSync");
            t.start();
            LOG.info("User '{}' manually triggered Multi-Tenancy Ranger Sync in a new thread, tid={}", (Object)ugi, (Object)t.getId());
            return true;
        }
        LOG.info("User '{}' manually triggered Multi-Tenancy Ranger Sync", (Object)ugi);
        return bgSync.triggerRangerSyncOnce();
    }

    public UpgradeFinalizer.StatusAndMessages finalizeUpgrade(String upgradeClientID) throws IOException {
        return this.upgradeFinalizer.finalize(upgradeClientID, (Object)this);
    }

    public UpgradeFinalizer.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean takeover, boolean readonly) throws IOException {
        if (readonly) {
            return new UpgradeFinalizer.StatusAndMessages(this.upgradeFinalizer.getStatus(), Collections.emptyList());
        }
        return this.upgradeFinalizer.reportStatus(upgradeClientID, takeover);
    }

    public TenantStateList listTenant() throws IOException {
        this.metrics.incNumTenantLists();
        UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
        if (!this.isAdmin(ugi)) {
            OMException omEx = new OMException("Only Ozone admins are allowed to list tenants.", OMException.ResultCodes.PERMISSION_DENIED);
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(OMAction.LIST_TENANT, new LinkedHashMap<String, String>(), omEx));
            throw omEx;
        }
        Table tenantStateTable = this.metadataManager.getTenantStateTable();
        Throwable throwable = null;
        Object var4_6 = null;
        try (TableIterator iterator = tenantStateTable.iterator();){
            ArrayList<OzoneManagerProtocolProtos.TenantState> tenantStateList = new ArrayList<OzoneManagerProtocolProtos.TenantState>();
            while (iterator.hasNext()) {
                Table.KeyValue dbEntry = (Table.KeyValue)iterator.next();
                String tenantId = (String)dbEntry.getKey();
                OmDBTenantState omDBTenantState = (OmDBTenantState)dbEntry.getValue();
                assert (tenantId.equals(omDBTenantState.getTenantId()));
                tenantStateList.add(OzoneManagerProtocolProtos.TenantState.newBuilder().setTenantId(omDBTenantState.getTenantId()).setBucketNamespaceName(omDBTenantState.getBucketNamespaceName()).setUserRoleName(omDBTenantState.getUserRoleName()).setAdminRoleName(omDBTenantState.getAdminRoleName()).setBucketNamespacePolicyName(omDBTenantState.getBucketNamespacePolicyName()).setBucketPolicyName(omDBTenantState.getBucketPolicyName()).build());
            }
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_TENANT, new LinkedHashMap<String, String>()));
            return new TenantStateList(tenantStateList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public TenantUserInfoValue tenantGetUserInfo(String userPrincipal) throws IOException {
        this.metrics.incNumTenantGetUserInfos();
        if (StringUtils.isEmpty((CharSequence)userPrincipal)) {
            return null;
        }
        ArrayList accessIdInfoList = new ArrayList();
        OmDBUserPrincipalInfo kerberosPrincipalInfo = (OmDBUserPrincipalInfo)this.metadataManager.getPrincipalToAccessIdsTable().get((Object)userPrincipal);
        if (kerberosPrincipalInfo == null) {
            return null;
        }
        Set accessIds = kerberosPrincipalInfo.getAccessIds();
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("userPrincipal", userPrincipal);
        accessIds.forEach(accessId -> {
            try {
                OmDBAccessIdInfo accessIdInfo = (OmDBAccessIdInfo)this.metadataManager.getTenantAccessIdTable().get(accessId);
                if (accessIdInfo == null) {
                    LOG.warn("Expected accessId '{}' not found in TenantAccessIdTable. Might have been removed already.", accessId);
                    return;
                }
                assert (accessIdInfo.getUserPrincipal().equals(userPrincipal));
                accessIdInfoList.add(OzoneManagerProtocolProtos.ExtendedUserAccessIdInfo.newBuilder().setUserPrincipal(userPrincipal).setAccessId(accessId).setTenantId(accessIdInfo.getTenantId()).setIsAdmin(accessIdInfo.getIsAdmin()).setIsDelegatedAdmin(accessIdInfo.getIsDelegatedAdmin()).build());
            }
            catch (IOException e) {
                LOG.error("Potential DB issue. Failed to retrieve OmDBAccessIdInfo for accessId '{}' in TenantAccessIdTable.", accessId);
                auditMap.put("accessId", (String)accessId);
                AUDIT.logWriteFailure(this.buildAuditMessageForFailure(OMAction.TENANT_GET_USER_INFO, auditMap, e));
                auditMap.remove("accessId");
            }
        });
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.TENANT_GET_USER_INFO, auditMap));
        return new TenantUserInfoValue(accessIdInfoList);
    }

    public TenantUserList listUsersInTenant(String tenantId, String prefix) throws IOException {
        TenantUserList tenantUserList;
        block7: {
            this.metrics.incNumTenantUserLists();
            if (StringUtils.isEmpty((CharSequence)tenantId)) {
                return null;
            }
            this.multiTenantManager.checkTenantExistence(tenantId);
            String volumeName = this.multiTenantManager.getTenantVolumeName(tenantId);
            LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
            auditMap.put("tenant", tenantId);
            auditMap.put("volume", volumeName);
            auditMap.put("userPrefix", prefix);
            OMLockDetails omLockDetails = this.metadataManager.getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            boolean lockAcquired = omLockDetails.isLockAcquired();
            try {
                UserGroupInformation ugi = ProtobufRpcEngine.Server.getRemoteUser();
                if (!this.multiTenantManager.isTenantAdmin(ugi, tenantId, false)) {
                    throw new OMException("Only tenant and ozone admins can access this API. '" + ugi.getShortUserName() + "' is not an admin.", OMException.ResultCodes.PERMISSION_DENIED);
                }
                TenantUserList userList = this.multiTenantManager.listUsersInTenant(tenantId, prefix);
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.TENANT_LIST_USER, auditMap));
                tenantUserList = userList;
                if (!lockAcquired) break block7;
            }
            catch (IOException ex) {
                try {
                    AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.TENANT_LIST_USER, auditMap, ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (lockAcquired) {
                        this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                    }
                    throw throwable;
                }
            }
            this.metadataManager.getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
        }
        return tenantUserList;
    }

    public S3VolumeContext getS3VolumeContext() throws IOException {
        return this.getS3VolumeContext(false);
    }

    S3VolumeContext getS3VolumeContext(boolean skipChecks) throws IOException {
        String userPrincipal;
        long start = Time.monotonicNowNanos();
        String s3Volume = HddsClientUtils.getDefaultS3VolumeName((ConfigurationSource)this.configuration);
        OzoneManagerProtocolProtos.S3Authentication s3Auth = OzoneManager.getS3Auth();
        if (s3Auth == null) {
            userPrincipal = Server.getRemoteUser().getShortUserName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("S3 authentication was not attached to the OM request. Directing requests to the default S3 volume {}.", (Object)s3Volume);
            }
        } else {
            Optional<String> optionalTenantId;
            String accessId = s3Auth.getAccessId();
            Optional<String> optional = optionalTenantId = this.isS3MultiTenancyEnabled() ? this.multiTenantManager.getTenantForAccessID(accessId) : Optional.absent();
            if (!optionalTenantId.isPresent()) {
                UserGroupInformation s3gUGI = UserGroupInformation.createRemoteUser((String)accessId);
                userPrincipal = s3gUGI.getShortUserName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No tenant found for access ID {}. Directing requests to default s3 volume {}.", (Object)accessId, (Object)s3Volume);
                }
            } else {
                String tenantId = (String)optionalTenantId.get();
                OmDBTenantState tenantState = (OmDBTenantState)this.metadataManager.getTenantStateTable().get((Object)tenantId);
                if (tenantState == null) {
                    String message = "Unable to find tenant '" + tenantId + "' details for access ID " + accessId + ". The tenant might have been removed during this operation, " + "or the OM DB is inconsistent";
                    LOG.warn(message);
                    throw new OMException(message, OMException.ResultCodes.TENANT_NOT_FOUND);
                }
                s3Volume = tenantState.getBucketNamespaceName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Get S3 volume request for access ID {} belonging to tenant {} is directed to the volume {}.", new Object[]{accessId, tenantId, s3Volume});
                }
                OMLockDetails omLockDetails = this.getMetadataManager().getLock().acquireReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{s3Volume});
                boolean acquiredVolumeLock = omLockDetails.isLockAcquired();
                try {
                    userPrincipal = OzoneAclUtils.accessIdToUserPrincipal(accessId);
                }
                catch (Throwable throwable) {
                    if (acquiredVolumeLock) {
                        this.getMetadataManager().getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{s3Volume});
                    }
                    throw throwable;
                }
                if (acquiredVolumeLock) {
                    this.getMetadataManager().getLock().releaseReadLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{s3Volume});
                }
            }
        }
        OmVolumeArgs volumeInfo = skipChecks ? this.volumeManager.getVolumeInfo(s3Volume) : this.getVolumeInfo(s3Volume);
        S3VolumeContext.Builder s3VolumeContext = S3VolumeContext.newBuilder().setOmVolumeArgs(volumeInfo).setUserPrincipal(userPrincipal);
        this.perfMetrics.addS3VolumeContextLatencyNs(Time.monotonicNowNanos() - start);
        return s3VolumeContext.build();
    }

    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName));
        Map<String, String> auditMap = bucket.audit();
        auditMap.put("key", keyName);
        auditMap.put("uploadID", uploadID);
        auditMap.put("partNumberMarker", Integer.toString(partNumberMarker));
        auditMap.put("maxParts", Integer.toString(maxParts));
        this.metrics.incNumListMultipartUploadParts();
        try {
            OmMultipartUploadListParts omMultipartUploadListParts = this.keyManager.listParts(bucket.realVolume(), bucket.realBucket(), keyName, uploadID, partNumberMarker, maxParts);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap));
            return omMultipartUploadListParts;
        }
        catch (IOException ex) {
            this.metrics.incNumListMultipartUploadPartFails();
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap, ex));
            throw ex;
        }
    }

    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix) throws IOException {
        ResolvedBucket bucket = this.resolveBucketLink((Pair<String, String>)Pair.of((Object)volumeName, (Object)bucketName));
        Map<String, String> auditMap = bucket.audit();
        auditMap.put("prefix", prefix);
        this.metrics.incNumListMultipartUploads();
        try {
            OmMultipartUploadList omMultipartUploadList = this.keyManager.listMultipartUploads(bucket.realVolume(), bucket.realBucket(), prefix);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(OMAction.LIST_MULTIPART_UPLOADS, auditMap));
            return omMultipartUploadList;
        }
        catch (IOException ex) {
            this.metrics.incNumListMultipartUploadFails();
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(OMAction.LIST_MULTIPART_UPLOADS, auditMap, ex));
            throw ex;
        }
    }

    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ReferenceCounted<IOmMetadataReader> rcReader = this.getReader(args);){
            return rcReader.get().getFileStatus(args);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public OmKeyInfo lookupFile(OmKeyArgs args) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ReferenceCounted<IOmMetadataReader> rcReader = this.getReader(args);){
            return rcReader.get().lookupFile(args);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.listStatus(args, recursive, startKey, numEntries, false);
    }

    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        Throwable throwable = null;
        Object var8_8 = null;
        try (ReferenceCounted<IOmMetadataReader> rcReader = this.getReader(args);){
            return rcReader.get().listStatus(args, recursive, startKey, numEntries, allowPartialPrefixes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<OzoneFileStatusLight> listStatusLight(OmKeyArgs args, boolean recursive, String startKey, long numEntries, boolean allowPartialPrefixes) throws IOException {
        List<OzoneFileStatus> ozoneFileStatuses = this.listStatus(args, recursive, startKey, numEntries, allowPartialPrefixes);
        return ozoneFileStatuses.stream().map(OzoneFileStatusLight::fromOzoneFileStatus).collect(Collectors.toList());
    }

    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ReferenceCounted<IOmMetadataReader> rcReader = this.getReader(obj);){
            return rcReader.get().getAcl(obj);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public synchronized TermIndex installSnapshotFromLeader(String leaderId) {
        DBCheckpoint omDBCheckpoint;
        if (this.omRatisSnapshotProvider == null) {
            LOG.error("OM Snapshot Provider is not configured as there are no peer nodes.");
            return null;
        }
        try {
            omDBCheckpoint = this.omRatisSnapshotProvider.downloadDBSnapshotFromLeader(leaderId);
        }
        catch (IOException ex) {
            LOG.error("Failed to download snapshot from Leader {}.", (Object)leaderId, (Object)ex);
            return null;
        }
        TermIndex termIndex = null;
        try {
            OmSnapshotUtils.createHardLinks(omDBCheckpoint.getCheckpointLocation());
            termIndex = this.installCheckpoint(leaderId, omDBCheckpoint);
        }
        catch (Exception ex) {
            LOG.error("Failed to install snapshot from Leader OM.", (Throwable)ex);
        }
        return termIndex;
    }

    TermIndex installCheckpoint(String leaderId, DBCheckpoint omDBCheckpoint) throws Exception {
        Path checkpointLocation = omDBCheckpoint.getCheckpointLocation();
        TransactionInfo checkpointTrxnInfo = OzoneManagerRatisUtils.getTrxnInfoFromCheckpoint(this.configuration, checkpointLocation);
        LOG.info("Installing checkpoint with OMTransactionInfo {}", (Object)checkpointTrxnInfo);
        return this.installCheckpoint(leaderId, checkpointLocation, checkpointTrxnInfo);
    }

    TermIndex installCheckpoint(String leaderId, Path checkpointLocation, TransactionInfo checkpointTrxnInfo) throws Exception {
        String errorMsg;
        long startTime = Time.monotonicNow();
        File oldDBLocation = this.metadataManager.getStore().getDbLocation();
        try {
            this.keyManager.stop();
            this.stopSecretManager();
            this.stopTrashEmptier();
            this.omSnapshotManager.invalidateCache();
            this.omRatisServer.getOmStateMachine().pause();
        }
        catch (Exception e) {
            LOG.error("Failed to stop/ pause the services. Cannot proceed with installing the new checkpoint.");
            this.keyManager.start(this.configuration);
            this.startSecretManagerIfNecessary();
            this.startTrashEmptier((Configuration)this.configuration);
            throw e;
        }
        File dbBackup = null;
        TermIndex termIndex = this.omRatisServer.getLastAppliedTermIndex();
        long term = termIndex.getTerm();
        long lastAppliedIndex = termIndex.getIndex();
        boolean canProceed = OzoneManagerRatisUtils.verifyTransactionInfo(checkpointTrxnInfo, lastAppliedIndex, leaderId, checkpointLocation);
        boolean oldOmMetadataManagerStopped = false;
        boolean newMetadataManagerStarted = false;
        boolean omRpcServerStopped = false;
        long time = Time.monotonicNow();
        if (canProceed) {
            this.omRpcServer.stop();
            this.isOmRpcServerRunning = false;
            omRpcServerStopped = true;
            LOG.info("RPC server is stopped. Spend " + (Time.monotonicNow() - time) + " ms.");
            try {
                time = Time.monotonicNow();
                this.metadataManager.stop();
                oldOmMetadataManagerStopped = true;
                LOG.info("metadataManager is stopped. Spend " + (Time.monotonicNow() - time) + " ms.");
            }
            catch (Exception e) {
                errorMsg = "Failed to stop metadataManager. Cannot proceed with installing the new checkpoint.";
                LOG.error(errorMsg);
                this.exitManager.exitSystem(1, errorMsg, (Throwable)e, LOG);
            }
            try {
                time = Time.monotonicNow();
                dbBackup = this.replaceOMDBWithCheckpoint(lastAppliedIndex, oldDBLocation, checkpointLocation);
                term = checkpointTrxnInfo.getTerm();
                lastAppliedIndex = checkpointTrxnInfo.getTransactionIndex();
                LOG.info("Replaced DB with checkpoint from OM: {}, term: {}, index: {}, time: {} ms", new Object[]{leaderId, term, lastAppliedIndex, Time.monotonicNow() - time});
            }
            catch (Exception e) {
                LOG.error("Failed to install Snapshot from {} as OM failed to replace DB with downloaded checkpoint. Reloading old OM state.", (Object)leaderId, (Object)e);
            }
        } else {
            LOG.warn("Cannot proceed with InstallSnapshot as OM is at TermIndex {} and checkpoint has lower TermIndex {}. Reloading old state of OM.", (Object)termIndex, (Object)checkpointTrxnInfo.getTermIndex());
        }
        if (oldOmMetadataManagerStopped) {
            this.omSnapshotManager.close();
        }
        try {
            if (oldOmMetadataManagerStopped) {
                time = Time.monotonicNow();
                this.reloadOMState(lastAppliedIndex, term);
                this.omRatisServer.getOmStateMachine().unpause(lastAppliedIndex, term);
                newMetadataManagerStarted = true;
                LOG.info("Reloaded OM state with Term: {} and Index: {}. Spend {} ms", new Object[]{term, lastAppliedIndex, Time.monotonicNow() - time});
            } else {
                this.keyManager.start(this.configuration);
                this.startSecretManagerIfNecessary();
                this.startTrashEmptier((Configuration)this.configuration);
                this.omRatisServer.getOmStateMachine().unpause(lastAppliedIndex, term);
                LOG.info("OM DB is not stopped. Started services with Term: {} and Index: {}", (Object)term, (Object)lastAppliedIndex);
            }
        }
        catch (Exception ex) {
            errorMsg = "Failed to reload OM state and instantiate services.";
            this.exitManager.exitSystem(1, errorMsg, (Throwable)ex, LOG);
        }
        if (omRpcServerStopped && newMetadataManagerStarted) {
            try {
                time = Time.monotonicNow();
                this.omRpcServer = this.getRpcServer(this.configuration);
                this.omRpcServer.start();
                this.isOmRpcServerRunning = true;
                LOG.info("RPC server is re-started. Spend " + (Time.monotonicNow() - time) + " ms.");
            }
            catch (Exception e) {
                errorMsg = "Failed to start RPC Server.";
                this.exitManager.exitSystem(1, errorMsg, (Throwable)e, LOG);
            }
        }
        try {
            if (dbBackup != null) {
                FileUtils.deleteFully(dbBackup);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to delete the backup of the original DB {}", dbBackup, (Object)e);
        }
        if (lastAppliedIndex != checkpointTrxnInfo.getTransactionIndex()) {
            return null;
        }
        TermIndex newTermIndex = TermIndex.valueOf((long)term, (long)lastAppliedIndex);
        LOG.info("Install Checkpoint is finished with Term: {} and Index: {}. Spend {} ms.", new Object[]{newTermIndex.getTerm(), newTermIndex.getIndex(), Time.monotonicNow() - startTime});
        return newTermIndex;
    }

    private void stopTrashEmptier() {
        if (this.emptier != null) {
            this.emptier.interrupt();
            this.emptier = null;
        }
    }

    File replaceOMDBWithCheckpoint(long lastAppliedIndex, File oldDB, Path checkpointPath) throws IOException {
        String dbBackupName = "om.db.backup." + lastAppliedIndex + "_" + System.currentTimeMillis();
        File dbDir = oldDB.getParentFile();
        File dbBackupDir = new File(dbDir, dbBackupName);
        if (!dbBackupDir.mkdirs()) {
            throw new IOException("Failed to make db backup dir: " + dbBackupDir);
        }
        File dbBackup = new File(dbBackupDir, oldDB.getName());
        File dbSnapshotsDir = new File(dbDir, "db.snapshots");
        File dbSnapshotsBackup = new File(dbBackupDir, "db.snapshots");
        Files.move(oldDB.toPath(), dbBackup.toPath(), new CopyOption[0]);
        if (dbSnapshotsDir.exists()) {
            Files.move(dbSnapshotsDir.toPath(), dbSnapshotsBackup.toPath(), new CopyOption[0]);
        }
        this.moveCheckpointFiles(oldDB, checkpointPath, dbDir, dbBackup, dbSnapshotsDir, dbSnapshotsBackup);
        return dbBackupDir;
    }

    private void moveCheckpointFiles(File oldDB, Path checkpointPath, File dbDir, File dbBackup, File dbSnapshotsDir, File dbSnapshotsBackup) throws IOException {
        Path markerFile = new File(dbDir, "dbInconsistentMarker").toPath();
        try {
            Files.createFile(markerFile, new FileAttribute[0]);
            OmSnapshotUtils.linkFiles(checkpointPath.toFile(), oldDB);
            this.moveOmSnapshotData(oldDB.toPath(), dbSnapshotsDir.toPath());
            Files.deleteIfExists(markerFile);
        }
        catch (IOException e) {
            LOG.error("Failed to move downloaded DB checkpoint {} to metadata directory {}. Exception: {}. Resetting to original DB.", new Object[]{checkpointPath, oldDB.toPath(), e});
            try {
                FileUtil.fullyDelete((File)oldDB);
                Files.move(dbBackup.toPath(), oldDB.toPath(), new CopyOption[0]);
                if (dbSnapshotsBackup.exists()) {
                    Files.move(dbSnapshotsBackup.toPath(), dbSnapshotsDir.toPath(), new CopyOption[0]);
                }
                Files.deleteIfExists(markerFile);
            }
            catch (IOException ex) {
                String errorMsg = "Failed to reset to original DB. OM is in an inconsistent state.";
                this.exitManager.exitSystem(1, errorMsg, (Throwable)ex, LOG);
            }
            throw e;
        }
    }

    private void moveOmSnapshotData(Path dbPath, Path dbSnapshotsDir) throws IOException {
        Path incomingSnapshotsDir = Paths.get(dbPath.toString(), "db.snapshots");
        if (incomingSnapshotsDir.toFile().exists()) {
            Files.move(incomingSnapshotsDir, dbSnapshotsDir, new CopyOption[0]);
        }
    }

    void reloadOMState(long newSnapshotIndex, long newSnapshotTermIndex) throws IOException {
        this.instantiateServices(true);
        this.metadataManager.start(this.configuration);
        this.keyManager.start(this.configuration);
        this.startSecretManagerIfNecessary();
        this.startTrashEmptier((Configuration)this.configuration);
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        this.metrics.setNumKeys(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getKeyTable(this.getBucketLayout())));
        this.metrics.setNumDirs(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getDirectoryTable()));
        this.metrics.setNumFiles(this.metadataManager.countEstimatedRowsInTable(this.metadataManager.getFileTable()));
        Files.deleteIfExists(this.getMetricsStorageFile().toPath());
        this.saveOmMetrics();
        this.omRatisSnapshotInfo.updateTermIndex(newSnapshotTermIndex, newSnapshotIndex);
    }

    public static Logger getLogger() {
        return LOG;
    }

    public OzoneConfiguration getConfiguration() {
        return this.configuration;
    }

    @VisibleForTesting
    public void setConfiguration(OzoneConfiguration conf) {
        this.configuration = conf;
    }

    public OzoneConfiguration reloadConfiguration() {
        if (testReloadConfigFlag) {
            return this.configuration;
        }
        return new OzoneConfiguration();
    }

    public static void setTestReloadConfigFlag(boolean testReloadConfigFlag) {
        OzoneManager.testReloadConfigFlag = testReloadConfigFlag;
    }

    public static void setTestSecureOmFlag(boolean testSecureOmFlag) {
        OzoneManager.testSecureOmFlag = testSecureOmFlag;
    }

    @VisibleForTesting
    public static void setUgi(UserGroupInformation user) {
        testUgi = user;
    }

    public OMNodeDetails getNodeDetails() {
        return this.omNodeDetails;
    }

    public String getOMNodeId() {
        return this.omNodeDetails.getNodeId();
    }

    public String getOMServiceId() {
        return this.omNodeDetails.getServiceId();
    }

    @VisibleForTesting
    public List<OMNodeDetails> getPeerNodes() {
        return new ArrayList<OMNodeDetails>(this.peerNodesMap.values());
    }

    public OMNodeDetails getPeerNode(String nodeID) {
        return this.peerNodesMap.get(nodeID);
    }

    @VisibleForTesting
    public CertificateClient getCertificateClient() {
        return this.certClient;
    }

    public String getComponent() {
        return this.omComponent;
    }

    public long getMaxUserVolumeCount() {
        return this.maxUserVolumeCount;
    }

    public boolean isLeaderReady() {
        OzoneManagerRatisServer ratisServer = this.omRatisServer;
        return !this.isRatisEnabled || ratisServer != null && ratisServer.checkLeaderStatus() == OzoneManagerRatisServer.RaftServerStatus.LEADER_AND_READY;
    }

    public void checkLeaderStatus() throws OMNotLeaderException, OMLeaderNotReadyException {
        OzoneManagerRatisServer.RaftServerStatus raftServerStatus = this.omRatisServer.checkLeaderStatus();
        RaftPeerId raftPeerId = this.omRatisServer.getRaftPeerId();
        RaftPeerId raftLeaderId = null;
        String raftLeaderAddress = null;
        RaftPeer leader = this.omRatisServer.getLeader();
        if (leader != null) {
            raftLeaderId = leader.getId();
            raftLeaderAddress = this.omRatisServer.getRaftLeaderAddress(leader);
        }
        switch (raftServerStatus) {
            case LEADER_AND_READY: {
                return;
            }
            case LEADER_AND_NOT_READY: {
                throw new OMLeaderNotReadyException(String.valueOf(raftPeerId.toString()) + " is Leader " + "but not ready to process request yet.");
            }
            case NOT_LEADER: {
                throw raftLeaderId == null ? new OMNotLeaderException(raftPeerId) : new OMNotLeaderException(raftPeerId, raftLeaderId, raftLeaderAddress);
            }
        }
        throw new IllegalStateException("Unknown Ratis Server state: " + (Object)((Object)raftServerStatus));
    }

    public boolean isRatisEnabled() {
        return this.isRatisEnabled;
    }

    public boolean isFilesystemSnapshotEnabled() {
        return this.fsSnapshotEnabled;
    }

    public DBUpdates getDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws IOException {
        long limitCount = Long.MAX_VALUE;
        if (dbUpdatesRequest.hasLimitCount()) {
            limitCount = dbUpdatesRequest.getLimitCount();
        }
        DBUpdatesWrapper updatesSince = this.metadataManager.getStore().getUpdatesSince(dbUpdatesRequest.getSequenceNumber(), limitCount);
        DBUpdates dbUpdates = new DBUpdates(updatesSince.getData());
        dbUpdates.setCurrentSequenceNumber(updatesSince.getCurrentSequenceNumber());
        dbUpdates.setLatestSequenceNumber(updatesSince.getLatestSequenceNumber());
        dbUpdates.setDBUpdateSuccess(updatesSince.isDBUpdateSuccess());
        return dbUpdates;
    }

    public OzoneDelegationTokenSecretManager getDelegationTokenMgr() {
        return this.delegationTokenMgr;
    }

    public Collection<String> getOmAdminUsernames() {
        return this.omAdmins.getAdminUsernames();
    }

    public Collection<String> getOmReadOnlyAdminUsernames() {
        return this.readOnlyAdmins.getAdminUsernames();
    }

    public Collection<String> getOmAdminGroups() {
        return this.omAdmins.getAdminGroups();
    }

    public boolean isReadOnlyAdmin(UserGroupInformation callerUgi) {
        return callerUgi != null && this.readOnlyAdmins.isAdmin(callerUgi);
    }

    public boolean isAdmin(UserGroupInformation callerUgi) {
        return callerUgi != null && this.omAdmins.isAdmin(callerUgi);
    }

    private void checkAdminUserPrivilege(String operation) throws IOException {
        UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
        if (!this.isAdmin(ugi)) {
            throw new OMException("Only Ozone admins are allowed to " + operation, OMException.ResultCodes.PERMISSION_DENIED);
        }
    }

    public boolean isS3Admin(UserGroupInformation callerUgi) {
        return callerUgi != null && this.s3OzoneAdmins.isAdmin(callerUgi);
    }

    @VisibleForTesting
    public boolean isRunning() {
        return this.omState == State.RUNNING;
    }

    private void startJVMPauseMonitor() {
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.start();
        }
    }

    public ResolvedBucket resolveBucketLink(OzoneManagerProtocolProtos.KeyArgs args, OMClientRequest omClientRequest) throws IOException {
        return this.resolveBucketLink((Pair<String, String>)Pair.of((Object)args.getVolumeName(), (Object)args.getBucketName()), omClientRequest);
    }

    public ResolvedBucket resolveBucketLink(Pair<String, String> requested) throws IOException {
        return this.resolveBucketLink(requested, false);
    }

    public ResolvedBucket resolveBucketLink(OmKeyArgs args) throws IOException {
        return this.resolveBucketLink((Pair<String, String>)Pair.of((Object)args.getVolumeName(), (Object)args.getBucketName()));
    }

    public ResolvedBucket resolveBucketLink(Pair<String, String> requested, OMClientRequest omClientRequest) throws IOException {
        OmBucketInfo resolved = this.isAclEnabled ? this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), omClientRequest.createUGIForApi(), omClientRequest.getRemoteAddress(), omClientRequest.getHostName(), false) : this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), null, null, null, false);
        return new ResolvedBucket((String)requested.getLeft(), (String)requested.getRight(), resolved);
    }

    public ResolvedBucket resolveBucketLink(Pair<String, String> requested, boolean allowDanglingBuckets) throws IOException {
        OmBucketInfo resolved;
        if (this.isAclEnabled) {
            UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
            if (OzoneManager.getS3Auth() != null) {
                ugi = UserGroupInformation.createRemoteUser((String)OzoneAclUtils.accessIdToUserPrincipal(OzoneManager.getS3Auth().getAccessId()));
            }
            InetAddress remoteIp = Server.getRemoteIp();
            resolved = this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), ugi, remoteIp != null ? remoteIp : this.omRpcAddress.getAddress(), remoteIp != null ? remoteIp.getHostName() : this.omRpcAddress.getHostName(), allowDanglingBuckets);
        } else {
            resolved = this.resolveBucketLink(requested, new HashSet<Pair<String, String>>(), null, null, null, allowDanglingBuckets);
        }
        return new ResolvedBucket((String)requested.getLeft(), (String)requested.getRight(), resolved);
    }

    private OmBucketInfo resolveBucketLink(Pair<String, String> volumeAndBucket, Set<Pair<String, String>> visited, UserGroupInformation userGroupInformation, InetAddress remoteAddress, String hostName, boolean allowDanglingBuckets) throws IOException {
        OmBucketInfo info;
        String volumeName = (String)volumeAndBucket.getLeft();
        String bucketName = (String)volumeAndBucket.getRight();
        try {
            info = this.bucketManager.getBucketInfo(volumeName, bucketName);
        }
        catch (OMException e) {
            LOG.warn("Bucket {} not found in volume {}", (Object)bucketName, (Object)volumeName);
            if (allowDanglingBuckets) {
                return null;
            }
            throw e;
        }
        if (!info.isLink()) {
            return info;
        }
        if (!visited.add(volumeAndBucket)) {
            throw new OMException("Detected loop in bucket links", OMException.ResultCodes.DETECTED_LOOP_IN_BUCKET_LINKS);
        }
        if (this.isAclEnabled) {
            IAccessAuthorizer.ACLType type = IAccessAuthorizer.ACLType.READ;
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, type, volumeName, bucketName, null, userGroupInformation, remoteAddress, hostName, true, this.getVolumeOwner(volumeName, type, OzoneObj.ResourceType.BUCKET));
        }
        return this.resolveBucketLink((Pair<String, String>)Pair.of((Object)info.getSourceVolume(), (Object)info.getSourceBucket()), visited, userGroupInformation, remoteAddress, hostName, allowDanglingBuckets);
    }

    @VisibleForTesting
    public void setExitManagerForTesting(ExitManager exitManagerForTesting) {
        this.exitManager = exitManagerForTesting;
    }

    public boolean getEnableFileSystemPaths() {
        return this.configuration.getBoolean("ozone.om.enable.filesystem.paths", false);
    }

    public boolean getKeyPathLockEnabled() {
        return this.configuration.getBoolean("ozone.om.key.path.lock.enabled", false);
    }

    public OzoneLockProvider getOzoneLockProvider() {
        return this.ozoneLockProvider;
    }

    public ReplicationConfig getDefaultReplicationConfig() {
        if (this.defaultReplicationConfig != null) {
            return this.defaultReplicationConfig;
        }
        String replication = this.configuration.getTrimmed("ozone.server.default.replication", OMConfigKeys.OZONE_SERVER_DEFAULT_REPLICATION_DEFAULT);
        String type = this.configuration.getTrimmed("ozone.server.default.replication.type", OMConfigKeys.OZONE_SERVER_DEFAULT_REPLICATION_TYPE_DEFAULT);
        return ReplicationConfig.parse((ReplicationType)ReplicationType.valueOf((String)type), (String)replication, (ConfigurationSource)this.configuration);
    }

    public BucketLayout getOMDefaultBucketLayout() {
        return this.defaultBucketLayout;
    }

    private void addS3GVolumeToDB() throws IOException {
        String s3VolumeName = HddsClientUtils.getDefaultS3VolumeName((ConfigurationSource)this.configuration);
        String dbVolumeKey = this.metadataManager.getVolumeKey(s3VolumeName);
        if (!s3VolumeName.equals("s3v")) {
            LOG.warn("Make sure that all S3Gateway use same volume name. Otherwise user need to manually create/configure Volume configured by S3Gateway");
        }
        if (!this.metadataManager.getVolumeTable().isExist((Object)dbVolumeKey)) {
            long transactionID = 0x3FFFFFFFFFFFFFL;
            long objectID = OmUtils.addEpochToTxId((long)this.metadataManager.getOmEpoch(), (long)transactionID);
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            OmVolumeArgs omVolumeArgs = this.createS3VolumeContext(s3VolumeName, objectID);
            String dbUserKey = this.metadataManager.getUserKey(userName);
            OzoneManagerStorageProtos.PersistedUserVolumeInfo userVolumeInfo = OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().setObjectID(objectID).setUpdateID(transactionID).addVolumeNames(s3VolumeName).build();
            Throwable throwable = null;
            Object var12_11 = null;
            try (BatchOperation batchOperation = this.metadataManager.getStore().initBatchOperation();){
                this.metadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)omVolumeArgs);
                this.metadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)userVolumeInfo);
                this.metadataManager.getStore().commitBatchOperation(batchOperation);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.metadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), CacheValue.get((long)transactionID, (Object)omVolumeArgs));
            this.metadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), CacheValue.get((long)transactionID, (Object)userVolumeInfo));
            LOG.info("Created Volume {} With Owner {} required for S3Gateway operations.", (Object)s3VolumeName, (Object)userName);
        }
    }

    private OmVolumeArgs createS3VolumeContext(String s3Volume, long objectID) throws IOException {
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        long time = Time.now();
        OmVolumeArgs.Builder omVolumeArgs = new OmVolumeArgs.Builder().setVolume(s3Volume).setUpdateID(-1L).setObjectID(objectID).setCreationTime(time).setModificationTime(time).setOwnerName(userName).setAdminName(userName).setQuotaInBytes(-1L);
        ArrayList<OzoneAcl> listOfAcls = new ArrayList<OzoneAcl>();
        listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, userName, IAccessAuthorizer.ACLType.ALL, OzoneAcl.AclScope.ACCESS));
        List<String> userGroups = Arrays.asList(UserGroupInformation.createRemoteUser((String)userName).getGroupNames());
        userGroups.forEach(group -> {
            boolean bl = listOfAcls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.GROUP, group, IAccessAuthorizer.ACLType.ALL, OzoneAcl.AclScope.ACCESS));
        });
        for (OzoneAcl ozoneAcl : listOfAcls) {
            omVolumeArgs.addOzoneAcls(ozoneAcl);
        }
        return omVolumeArgs.build();
    }

    public OMLayoutVersionManager getVersionManager() {
        return this.versionManager;
    }

    public OzoneManagerPrepareState getPrepareState() {
        return this.prepareState;
    }

    private void instantiatePrepareStateOnStartup() throws IOException {
        TransactionInfo txnInfo = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#TRANSACTIONINFO");
        if (txnInfo == null) {
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration);
        } else {
            boolean hasDBMarker;
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration, txnInfo.getTransactionIndex());
            TransactionInfo dbPrepareValue = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#PREPAREDINFO");
            boolean hasMarkerFile = this.prepareState.getState().getStatus() == OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.PREPARE_COMPLETED;
            boolean bl = hasDBMarker = dbPrepareValue != null;
            if (hasDBMarker) {
                long dbPrepareIndex = dbPrepareValue.getTransactionIndex();
                if (hasMarkerFile) {
                    long prepareFileIndex = this.prepareState.getState().getIndex();
                    if (prepareFileIndex != dbPrepareIndex) {
                        LOG.warn("Prepare marker file index {} does not match DB prepare index {}. Writing DB index to prepare file and maintaining prepared state.", (Object)prepareFileIndex, (Object)dbPrepareIndex);
                        this.prepareState.finishPrepare(dbPrepareIndex);
                    }
                } else {
                    this.metadataManager.getTransactionInfoTable().delete((Object)"#PREPAREDINFO");
                }
            } else if (hasMarkerFile) {
                throw new OMException("Prepare marker file found on startup without a corresponding database entry. Corrupt prepare state.", OMException.ResultCodes.PREPARE_FAILED);
            }
        }
    }

    private void instantiatePrepareStateAfterSnapshot() throws IOException {
        TransactionInfo txnInfo = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#TRANSACTIONINFO");
        if (txnInfo == null) {
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration);
        } else {
            boolean hasDBMarker;
            this.prepareState = new OzoneManagerPrepareState((ConfigurationSource)this.configuration, txnInfo.getTransactionIndex());
            TransactionInfo dbPrepareValue = (TransactionInfo)this.metadataManager.getTransactionInfoTable().get((Object)"#PREPAREDINFO");
            boolean bl = hasDBMarker = dbPrepareValue != null;
            if (hasDBMarker) {
                long dbPrepareIndex = dbPrepareValue.getTransactionIndex();
                this.prepareState.restorePrepareFromIndex(dbPrepareIndex, txnInfo.getTransactionIndex());
            } else {
                this.prepareState.cancelPrepare();
            }
        }
    }

    public int getMinMultipartUploadPartSize() {
        return this.minMultipartUploadPartSize;
    }

    @VisibleForTesting
    public void setMinMultipartUploadPartSize(int partSizeForTest) {
        this.minMultipartUploadPartSize = partSizeForTest;
    }

    @VisibleForTesting
    public boolean isOmRpcServerRunning() {
        return this.isOmRpcServerRunning;
    }

    public OzoneManagerProtocolProtos.EchoRPCResponse echoRPCReq(byte[] payloadReq, int payloadSizeResp, boolean writeToRatis) {
        return null;
    }

    public boolean recoverLease(String volumeName, String bucketName, String keyName) {
        return false;
    }

    public void setTimes(OmKeyArgs keyArgs, long mtime, long atime) throws IOException {
    }

    public boolean setSafeMode(SafeModeAction action, boolean isChecked) throws IOException {
        switch (action) {
            case ENTER: {
                throw new OMException("Enter safe mode is unsupported", OMException.ResultCodes.INTERNAL_ERROR);
            }
            case FORCE_EXIT: {
                return this.getScmClient().getContainerClient().forceExitSafeMode();
            }
            case GET: {
                return this.getScmClient().getContainerClient().inSafeMode();
            }
        }
        throw new OMException("Unsupported safe mode action " + action, OMException.ResultCodes.INTERNAL_ERROR);
    }

    private void updateLayoutVersionInDB(OMLayoutVersionManager lvm, OMMetadataManager omMetadataManager) throws IOException {
        omMetadataManager.getMetaTable().put((Object)"#LAYOUTVERSION", (Object)String.valueOf(lvm.getMetadataLayoutVersion()));
    }

    private BucketLayout getBucketLayout() {
        return BucketLayout.DEFAULT;
    }

    void saveNewCertId(String certId) {
        try {
            this.omStorage.setOmCertSerialId(certId);
            this.omStorage.persistCurrentState();
        }
        catch (IOException ex) {
            LOG.error("Failed to persist new cert ID {} to VERSION file.Terminating OzoneManager...", (Object)certId, (Object)ex);
            this.shutDown("OzoneManage shutdown because VERSION file persist failure.");
        }
    }

    public static HddsProtos.OzoneManagerDetailsProto getOmDetailsProto(ConfigurationSource config, String omID) {
        InetSocketAddress omRpcAddWithHostName;
        boolean addressResolved;
        boolean flexibleFqdnResolutionEnabled = config.getBoolean("ozone.network.flexible.fqdn.resolution.enabled", false);
        InetSocketAddress omRpcAdd = OmUtils.getOmAddress((ConfigurationSource)config);
        String ip = null;
        boolean bl = addressResolved = omRpcAdd != null && omRpcAdd.getAddress() != null;
        if (flexibleFqdnResolutionEnabled && !addressResolved && omRpcAdd != null && (omRpcAddWithHostName = OzoneNetUtils.getAddressWithHostNameLocal((InetSocketAddress)omRpcAdd)) != null && omRpcAddWithHostName.getAddress() != null) {
            addressResolved = true;
            ip = omRpcAddWithHostName.getAddress().getHostAddress();
        }
        if (!addressResolved) {
            LOG.error("Incorrect om rpc address. omRpcAdd:{}", (Object)omRpcAdd);
            throw new RuntimeException("Can't get SCM signed certificate. omRpcAdd: " + omRpcAdd);
        }
        if (ip == null) {
            ip = omRpcAdd.getAddress().getHostAddress();
        }
        String hostname = omRpcAdd.getHostName();
        int port = omRpcAdd.getPort();
        HddsProtos.OzoneManagerDetailsProto.Builder omDetailsProtoBuilder = HddsProtos.OzoneManagerDetailsProto.newBuilder().setHostName(hostname).setIpAddress(ip).setUuid(omID).addPorts(HddsProtos.Port.newBuilder().setName("RPC").setValue(port).build());
        HddsProtos.OzoneManagerDetailsProto omDetailsProto = omDetailsProtoBuilder.build();
        LOG.info("OzoneManager ports added:{}", (Object)omDetailsProto.getPortsList());
        return omDetailsProto;
    }

    private ReferenceCounted<IOmMetadataReader> getReader(OmKeyArgs keyArgs) throws IOException {
        return this.omSnapshotManager.getActiveFsMetadataOrSnapshot(keyArgs.getVolumeName(), keyArgs.getBucketName(), keyArgs.getKeyName());
    }

    private ReferenceCounted<IOmMetadataReader> getReader(String volumeName, String bucketName, String key) throws IOException {
        return this.omSnapshotManager.getActiveFsMetadataOrSnapshot(volumeName, bucketName, key);
    }

    private ReferenceCounted<IOmMetadataReader> getReader(OzoneObj ozoneObj) throws IOException {
        return this.omSnapshotManager.getActiveFsMetadataOrSnapshot(ozoneObj.getVolumeName(), ozoneObj.getBucketName(), ozoneObj.getKeyName());
    }

    public SnapshotDiffResponse snapshotDiff(String volume, String bucket, String fromSnapshot, String toSnapshot, String token, int pageSize, boolean forceFullDiff, boolean disableNativeDiff) throws IOException {
        return this.omSnapshotManager.getSnapshotDiffReport(volume, bucket, fromSnapshot, toSnapshot, token, pageSize, forceFullDiff, disableNativeDiff);
    }

    public CancelSnapshotDiffResponse cancelSnapshotDiff(String volume, String bucket, String fromSnapshot, String toSnapshot) throws IOException {
        return this.omSnapshotManager.cancelSnapshotDiff(volume, bucket, fromSnapshot, toSnapshot);
    }

    public List<SnapshotDiffJob> listSnapshotDiffJobs(String volume, String bucket, String jobStatus, boolean listAll) throws IOException {
        return this.omSnapshotManager.getSnapshotDiffList(volume, bucket, jobStatus, listAll);
    }

    public String printCompactionLogDag(String fileNamePrefix, String graphType) throws IOException {
        PrintableGraph.GraphType type;
        UserGroupInformation ugi = HddsServerUtil.getRemoteUser();
        if (!this.isAdmin(ugi)) {
            throw new OMException("Only Ozone admins are allowed to print compaction DAG.", OMException.ResultCodes.PERMISSION_DENIED);
        }
        fileNamePrefix = StringUtils.isBlank((CharSequence)fileNamePrefix) ? "dag-" : String.valueOf(fileNamePrefix) + "-";
        File tempFile = File.createTempFile(fileNamePrefix, ".png");
        try {
            type = PrintableGraph.GraphType.valueOf((String)graphType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            type = PrintableGraph.GraphType.FILE_NAME;
        }
        this.getMetadataManager().getStore().getRocksDBCheckpointDiffer().pngPrintMutableGraph(tempFile.getAbsolutePath(), type);
        return String.format("Graph was generated at '\\tmp\\%s' on OM node '%s'.", tempFile.getName(), this.getOMNodeId());
    }

    private String reconfOzoneAdmins(String newVal) {
        this.getConfiguration().set("ozone.administrators", newVal);
        Collection admins = OzoneAdmins.getOzoneAdminsFromConfig((OzoneConfiguration)this.getConfiguration(), (String)this.omStarterUser);
        this.omAdmins.setAdminUsernames(admins);
        LOG.info("Load conf {} : {}, and now admins are: {}", new Object[]{"ozone.administrators", newVal, admins});
        return String.valueOf(newVal);
    }

    private String reconfOzoneReadOnlyAdmins(String newVal) {
        this.getConfiguration().set("ozone.readonly.administrators", newVal);
        Collection pReadOnlyAdmins = OzoneAdmins.getOzoneReadOnlyAdminsFromConfig((OzoneConfiguration)this.getConfiguration());
        this.readOnlyAdmins.setAdminUsernames(pReadOnlyAdmins);
        LOG.info("Load conf {} : {}, and now readOnly admins are: {}", new Object[]{"ozone.readonly.administrators", newVal, pReadOnlyAdmins});
        return String.valueOf(newVal);
    }

    private String reconfOzoneKeyDeletingLimitPerTask(String newVal) {
        Preconditions.checkArgument((Integer.parseInt(newVal) >= 0 ? 1 : 0) != 0, (Object)"ozone.key.deleting.limit.per.task cannot be negative.");
        this.getConfiguration().set("ozone.key.deleting.limit.per.task", newVal);
        this.getKeyManager().getDeletingService().setKeyLimitPerTask(Integer.parseInt(newVal));
        return newVal;
    }

    public void validateReplicationConfig(ReplicationConfig replicationConfig) throws OMException {
        try {
            this.getReplicationConfigValidator().validate(replicationConfig);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new OMException("Invalid replication config: " + replicationConfig, OMException.ResultCodes.INVALID_REQUEST);
        }
    }

    @VisibleForTesting
    public ReplicationConfigValidator getReplicationConfigValidator() {
        return this.replicationConfigValidator;
    }

    @VisibleForTesting
    public ReconfigurationHandler getReconfigurationHandler() {
        return this.reconfigurationHandler;
    }

    public void awaitDoubleBufferFlush() throws InterruptedException {
        if (this.isRatisEnabled()) {
            this.getOmRatisServer().getOmStateMachine().awaitDoubleBufferFlush();
        } else {
            this.getOmServerProtocol().awaitDoubleBufferFlush();
        }
    }

    private class ScheduleOMMetricsWriteTask
    extends TimerTask {
        private ScheduleOMMetricsWriteTask() {
        }

        @Override
        public void run() {
            OzoneManager.this.saveOmMetrics();
        }
    }

    public static enum StartupOption {
        REGUALR,
        BOOTSTRAP,
        FORCE_BOOTSTRAP;

    }

    private static enum State {
        INITIALIZED,
        BOOTSTRAPPING,
        RUNNING,
        STOPPED;

    }
}

