/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.util.CacheMetrics;
import org.jetbrains.annotations.NotNull;

public class ScmClient {
    private final ScmBlockLocationProtocol blockClient;
    private final StorageContainerLocationProtocol containerClient;
    private final LoadingCache<Long, Pipeline> containerLocationCache;
    private final CacheMetrics containerCacheMetrics;

    ScmClient(ScmBlockLocationProtocol blockClient, StorageContainerLocationProtocol containerClient, OzoneConfiguration configuration) {
        this.containerClient = containerClient;
        this.blockClient = blockClient;
        this.containerLocationCache = ScmClient.createContainerLocationCache(configuration, containerClient);
        this.containerCacheMetrics = CacheMetrics.create(this.containerLocationCache, (String)"ContainerInfo");
    }

    static LoadingCache<Long, Pipeline> createContainerLocationCache(OzoneConfiguration configuration, final StorageContainerLocationProtocol containerClient) {
        int maxSize = configuration.getInt("ozone.om.container.location.cache.size", 100000);
        TimeUnit unit = OMConfigKeys.OZONE_OM_CONTAINER_LOCATION_CACHE_TTL_DEFAULT.getUnit();
        long ttl = configuration.getTimeDuration("ozone.om.container.location.cache.ttl", OMConfigKeys.OZONE_OM_CONTAINER_LOCATION_CACHE_TTL_DEFAULT.getDuration(), unit);
        return CacheBuilder.newBuilder().maximumSize((long)maxSize).expireAfterWrite(ttl, unit).recordStats().build((CacheLoader)new CacheLoader<Long, Pipeline>(){

            @NotNull
            public Pipeline load(@NotNull Long key) throws Exception {
                return containerClient.getContainerWithPipeline(key.longValue()).getPipeline();
            }

            @NotNull
            public Map<Long, Pipeline> loadAll(@NotNull Iterable<? extends Long> keys) throws Exception {
                return containerClient.getContainerWithPipelineBatch(keys).stream().collect(Collectors.toMap(x -> x.getContainerInfo().getContainerID(), ContainerWithPipeline::getPipeline));
            }
        });
    }

    public ScmBlockLocationProtocol getBlockClient() {
        return this.blockClient;
    }

    public StorageContainerLocationProtocol getContainerClient() {
        return this.containerClient;
    }

    /*
     * Unable to fully structure code
     */
    public Map<Long, Pipeline> getContainerLocations(Iterable<Long> containerIds, boolean forceRefresh) throws IOException {
        if (forceRefresh) {
            this.containerLocationCache.invalidateAll(containerIds);
        }
        try {
            result = this.containerLocationCache.getAll(containerIds);
            uncachePipelines = result.entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)()).map((Function<Map.Entry, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/Long;)()).collect(Collectors.toList());
            this.containerLocationCache.invalidateAll(uncachePipelines);
            return result;
        }
        catch (ExecutionException e) {
            return (Map)this.handleCacheExecutionException(e);
        }
        catch (CacheLoader.InvalidCacheLoadException v0) {
            result = new HashMap<Long, Pipeline>();
            ** for (containerId : containerIds)
        }
lbl-1000:
        // 1 sources

        {
            p = (Pipeline)this.containerLocationCache.getIfPresent((Object)containerId);
            if (p == null) continue;
            result.put(containerId, p);
            continue;
        }
lbl18:
        // 1 sources

        return result;
    }

    private <T> T handleCacheExecutionException(ExecutionException e) throws IOException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        throw new IllegalStateException("Unexpected exception accessing container location", e.getCause());
    }

    public void close() {
        this.containerCacheMetrics.unregister();
    }

    private static /* synthetic */ boolean lambda$0(Map.Entry e) {
        Pipeline pipeline = (Pipeline)e.getValue();
        if (pipeline.isEmpty()) {
            return true;
        }
        ReplicationConfig repConfig = pipeline.getReplicationConfig();
        if (repConfig instanceof ECReplicationConfig) {
            int d = ((ECReplicationConfig)repConfig).getData();
            int i = 1;
            while (i <= d) {
                if (!pipeline.getReplicaIndexes().containsValue(i)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

