/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.codec.OMDBDefinition;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisSnapshot;
import org.apache.hadoop.ozone.om.ratis.helpers.DoubleBufferEntry;
import org.apache.hadoop.ozone.om.ratis.metrics.OzoneManagerDoubleBufferMetrics;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerDoubleBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerDoubleBuffer.class);
    private Queue<DoubleBufferEntry<OMClientResponse>> currentBuffer;
    private Queue<DoubleBufferEntry<OMClientResponse>> readyBuffer;
    private volatile Queue<CompletableFuture<Void>> currentFutureQueue;
    private volatile Queue<CompletableFuture<Void>> readyFutureQueue;
    private final Daemon daemon;
    private final OMMetadataManager omMetadataManager;
    private final AtomicLong flushedTransactionCount = new AtomicLong(0L);
    private final AtomicLong flushIterations = new AtomicLong(0L);
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final OzoneManagerDoubleBufferMetrics ozoneManagerDoubleBufferMetrics;
    private long maxFlushedTransactionsInOneIteration;
    private final OzoneManagerRatisSnapshot ozoneManagerRatisSnapShot;
    private final boolean isRatisEnabled;
    private final boolean isTracingEnabled;
    private final Semaphore unFlushedTransactions;
    private final FlushNotifier flushNotifier;
    private final String threadPrefix;
    private final S3SecretManager s3SecretManager;
    private final Function<Long, Long> indexToTerm;

    private OzoneManagerDoubleBuffer(OMMetadataManager omMetadataManager, OzoneManagerRatisSnapshot ozoneManagerRatisSnapShot, boolean isRatisEnabled, boolean isTracingEnabled, Function<Long, Long> indexToTerm, int maxUnFlushedTransactions, FlushNotifier flushNotifier, S3SecretManager s3SecretManager, String threadPrefix) {
        this.currentBuffer = new ConcurrentLinkedQueue<DoubleBufferEntry<OMClientResponse>>();
        this.readyBuffer = new ConcurrentLinkedQueue<DoubleBufferEntry<OMClientResponse>>();
        this.isRatisEnabled = isRatisEnabled;
        this.isTracingEnabled = isTracingEnabled;
        if (!isRatisEnabled) {
            this.currentFutureQueue = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
            this.readyFutureQueue = new ConcurrentLinkedQueue<CompletableFuture<Void>>();
        }
        this.unFlushedTransactions = new Semaphore(maxUnFlushedTransactions);
        this.omMetadataManager = omMetadataManager;
        this.ozoneManagerRatisSnapShot = ozoneManagerRatisSnapShot;
        this.ozoneManagerDoubleBufferMetrics = OzoneManagerDoubleBufferMetrics.create();
        this.indexToTerm = indexToTerm;
        this.flushNotifier = flushNotifier;
        this.threadPrefix = threadPrefix;
        this.isRunning.set(true);
        this.daemon = new Daemon(this::flushTransactions);
        this.daemon.setName(String.valueOf(threadPrefix) + "OMDoubleBufferFlushThread");
        this.daemon.start();
        this.s3SecretManager = s3SecretManager;
    }

    public void acquireUnFlushedTransactions(int n) throws InterruptedException {
        this.unFlushedTransactions.acquire(n);
    }

    public void releaseUnFlushedTransactions(int n) {
        this.unFlushedTransactions.release(n);
    }

    private void addToBatchWithTrace(OzoneManagerProtocolProtos.OMResponse omResponse, CheckedRunnable<IOException> runnable) throws IOException {
        if (!this.isTracingEnabled) {
            runnable.run();
            return;
        }
        String spanName = "DB-addToWriteBatch-" + omResponse.getCmdType();
        TracingUtil.executeAsChildSpan((String)spanName, (String)omResponse.getTraceID(), runnable);
    }

    private void flushBatchWithTrace(String parentName, int batchSize, CheckedRunnable<IOException> runnable) throws IOException {
        if (!this.isTracingEnabled) {
            runnable.run();
            return;
        }
        String spanName = "DB-commitWriteBatch-Size-" + batchSize;
        TracingUtil.executeAsChildSpan((String)spanName, (String)parentName, runnable);
    }

    private void addToBatchTransactionInfoWithTrace(String parentName, long transactionIndex, CheckedRunnable<IOException> runnable) throws IOException {
        if (!this.isTracingEnabled) {
            runnable.run();
            return;
        }
        String spanName = "DB-addWriteBatch-transactioninfo-" + transactionIndex;
        TracingUtil.executeAsChildSpan((String)spanName, (String)parentName, runnable);
    }

    @VisibleForTesting
    public void flushTransactions() {
        while (this.isRunning.get() && this.canFlush()) {
            this.flushCurrentBuffer();
        }
    }

    @VisibleForTesting
    void flushCurrentBuffer() {
        try {
            this.swapCurrentAndReadyBuffer();
            List<Queue<DoubleBufferEntry<OMClientResponse>>> bufferQueues = this.splitReadyBufferAtCreateSnapshot();
            for (Queue<DoubleBufferEntry<OMClientResponse>> buffer : bufferQueues) {
                this.flushBatch(buffer);
            }
            this.clearReadyBuffer();
            this.flushNotifier.notifyFlush();
        }
        catch (IOException ex) {
            this.terminate(ex, 1);
        }
        catch (Throwable t) {
            this.terminate(t, 2);
        }
    }

    private void flushBatch(Queue<DoubleBufferEntry<OMClientResponse>> buffer) throws IOException {
        List<Long> flushedEpochs;
        HashMap<String, List<Long>> cleanupEpochs = new HashMap<String, List<Long>>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BatchOperation batchOperation = this.omMetadataManager.getStore().initBatchOperation();){
            String lastTraceId = this.addToBatch(buffer, batchOperation);
            buffer.iterator().forEachRemaining(entry -> this.addCleanupEntry((DoubleBufferEntry)entry, (Map<String, List<Long>>)cleanupEpochs));
            flushedEpochs = buffer.stream().map(DoubleBufferEntry::getTrxLogIndex).sorted().collect(Collectors.toList());
            long lastRatisTransactionIndex = (Long)flushedEpochs.get(flushedEpochs.size() - 1);
            long term = this.isRatisEnabled ? this.indexToTerm.apply(lastRatisTransactionIndex) : -1L;
            this.addToBatchTransactionInfoWithTrace(lastTraceId, lastRatisTransactionIndex, (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.omMetadataManager.getTransactionInfoTable().putWithBatch(batchOperation, (Object)"#TRANSACTIONINFO", (Object)new TransactionInfo.Builder().setTransactionIndex(lastRatisTransactionIndex).setCurrentTerm(term).build())));
            long startTime = Time.monotonicNow();
            this.flushBatchWithTrace(lastTraceId, buffer.size(), (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.omMetadataManager.getStore().commitBatchOperation(batchOperation)));
            this.ozoneManagerDoubleBufferMetrics.updateFlushTime(Time.monotonicNow() - startTime);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!this.isRatisEnabled) {
            this.clearReadyFutureQueue(buffer.size());
        }
        int flushedTransactionsSize = buffer.size();
        this.flushedTransactionCount.addAndGet(flushedTransactionsSize);
        this.flushIterations.incrementAndGet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sync iteration {} flushed transactions in this iteration {}", (Object)this.flushIterations.get(), (Object)flushedTransactionsSize);
        }
        this.cleanupCache(cleanupEpochs);
        if (this.isRatisEnabled) {
            this.releaseUnFlushedTransactions(flushedTransactionsSize);
        }
        this.ozoneManagerRatisSnapShot.updateLastAppliedIndex(flushedEpochs);
        this.updateMetrics(flushedTransactionsSize);
    }

    private String addToBatch(Queue<DoubleBufferEntry<OMClientResponse>> buffer, BatchOperation batchOperation) {
        String lastTraceId = null;
        for (DoubleBufferEntry doubleBufferEntry : buffer) {
            Object response = doubleBufferEntry.getResponse();
            OzoneManagerProtocolProtos.OMResponse omResponse = ((OMClientResponse)response).getOMResponse();
            lastTraceId = omResponse.getTraceID();
            try {
                this.addToBatchWithTrace(omResponse, (CheckedRunnable<IOException>)((CheckedRunnable)() -> response.checkAndUpdateDB(this.omMetadataManager, batchOperation)));
            }
            catch (IOException ex) {
                this.terminate(ex, 1, omResponse);
            }
            catch (Throwable t) {
                this.terminate(t, 2, omResponse);
            }
        }
        return lastTraceId;
    }

    private List<Queue<DoubleBufferEntry<OMClientResponse>>> splitReadyBufferAtCreateSnapshot() {
        ArrayList<Queue<DoubleBufferEntry<OMClientResponse>>> response = new ArrayList<Queue<DoubleBufferEntry<OMClientResponse>>>();
        Iterator iterator = this.readyBuffer.iterator();
        OzoneManagerProtocolProtos.OMResponse previousOmResponse = null;
        while (iterator.hasNext()) {
            DoubleBufferEntry entry = (DoubleBufferEntry)iterator.next();
            OzoneManagerProtocolProtos.OMResponse omResponse = ((OMClientResponse)entry.getResponse()).getOMResponse();
            if (response.isEmpty() || omResponse.hasCreateSnapshotResponse() || previousOmResponse != null && previousOmResponse.hasCreateSnapshotResponse()) {
                response.add(new LinkedList());
            }
            ((Queue)response.get(response.size() - 1)).add(entry);
            previousOmResponse = omResponse;
        }
        return response;
    }

    private void addCleanupEntry(DoubleBufferEntry entry, Map<String, List<Long>> cleanupEpochs) {
        Class<?> responseClass = entry.getResponse().getClass();
        CleanupTableInfo cleanupTableInfo = responseClass.getAnnotation(CleanupTableInfo.class);
        if (cleanupTableInfo != null) {
            List<String> cleanupTables = cleanupTableInfo.cleanupAll() ? new OMDBDefinition().getColumnFamilies().stream().map(DBColumnFamilyDefinition::getName).collect(Collectors.toList()) : Arrays.asList(cleanupTableInfo.cleanupTables());
            for (String table : cleanupTables) {
                cleanupEpochs.computeIfAbsent(table, list -> new ArrayList()).add(entry.getTrxLogIndex());
            }
        } else {
            throw new RuntimeException("CleanupTableInfo Annotation is missing for" + responseClass);
        }
    }

    private void clearReadyFutureQueue(int count) {
        while (!this.readyFutureQueue.isEmpty() && count > 0) {
            this.readyFutureQueue.remove().complete(null);
            --count;
        }
    }

    private void cleanupCache(Map<String, List<Long>> cleanupEpochs) {
        cleanupEpochs.forEach((tableName, epochs) -> {
            Collections.sort(epochs);
            this.omMetadataManager.getTable(tableName).cleanupCache(epochs);
            if (tableName.equals(OMDBDefinition.S3_SECRET_TABLE.getName())) {
                this.s3SecretManager.clearS3Cache(epochs);
            }
        });
    }

    private synchronized void clearReadyBuffer() {
        this.readyBuffer.clear();
    }

    private void updateMetrics(int flushedTransactionsSize) {
        this.ozoneManagerDoubleBufferMetrics.incrTotalNumOfFlushOperations();
        this.ozoneManagerDoubleBufferMetrics.incrTotalSizeOfFlushedTransactions(flushedTransactionsSize);
        this.ozoneManagerDoubleBufferMetrics.setAvgFlushTransactionsInOneIteration((float)this.ozoneManagerDoubleBufferMetrics.getTotalNumOfFlushedTransactions() / (float)this.ozoneManagerDoubleBufferMetrics.getTotalNumOfFlushOperations());
        if (this.maxFlushedTransactionsInOneIteration < (long)flushedTransactionsSize) {
            this.maxFlushedTransactionsInOneIteration = flushedTransactionsSize;
            this.ozoneManagerDoubleBufferMetrics.setMaxNumberOfTransactionsFlushedInOneIteration(flushedTransactionsSize);
        }
        this.ozoneManagerDoubleBufferMetrics.updateQueueSize(flushedTransactionsSize);
    }

    public void stop() {
        this.stopDaemon();
        this.ozoneManagerDoubleBufferMetrics.unRegister();
    }

    @VisibleForTesting
    public void stopDaemon() {
        if (this.isRunning.compareAndSet(true, false)) {
            LOG.info("Stopping OMDoubleBuffer flush thread");
            this.daemon.interrupt();
            try {
                this.daemon.join();
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted while waiting for daemon to exit.", (Throwable)e);
            }
        } else {
            LOG.info("OMDoubleBuffer flush thread is not running.");
        }
    }

    private void terminate(Throwable t, int status) {
        this.terminate(t, status, null);
    }

    private void terminate(Throwable t, int status, OzoneManagerProtocolProtos.OMResponse omResponse) {
        StringBuilder message = new StringBuilder("During flush to DB encountered error in OMDoubleBuffer flush thread " + Thread.currentThread().getName());
        if (omResponse != null) {
            message.append(" when handling OMRequest: ").append(omResponse);
        }
        ExitUtils.terminate((int)status, (String)message.toString(), (Throwable)t, (Logger)LOG);
    }

    public long getFlushedTransactionCount() {
        return this.flushedTransactionCount.get();
    }

    public long getFlushIterations() {
        return this.flushIterations.get();
    }

    public synchronized CompletableFuture<Void> add(OMClientResponse response, long transactionIndex) {
        this.currentBuffer.add(new DoubleBufferEntry<OMClientResponse>(transactionIndex, response));
        this.notify();
        if (!this.isRatisEnabled) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.currentFutureQueue.add(future);
            return future;
        }
        return null;
    }

    private synchronized boolean canFlush() {
        try {
            while (this.currentBuffer.size() == 0) {
                this.flushNotifier.notifyFlush();
                this.flushNotifier.notifyFlush();
                this.wait(1000L);
            }
            return true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            if (this.isRunning.get()) {
                String message = "OMDoubleBuffer flush thread " + Thread.currentThread().getName() + " encountered Interrupted " + "exception while running";
                ExitUtils.terminate((int)1, (String)message, (Throwable)ex, (Logger)LOG);
            }
            LOG.info("OMDoubleBuffer flush thread {} is interrupted and will exit.", (Object)Thread.currentThread().getName());
            return false;
        }
    }

    private synchronized void swapCurrentAndReadyBuffer() {
        Queue<DoubleBufferEntry<OMClientResponse>> temp = this.currentBuffer;
        this.currentBuffer = this.readyBuffer;
        this.readyBuffer = temp;
        if (!this.isRatisEnabled) {
            Queue<CompletableFuture<Void>> tempFuture = this.currentFutureQueue;
            this.currentFutureQueue = this.readyFutureQueue;
            this.readyFutureQueue = tempFuture;
        }
    }

    @VisibleForTesting
    public OzoneManagerDoubleBufferMetrics getOzoneManagerDoubleBufferMetrics() {
        return this.ozoneManagerDoubleBufferMetrics;
    }

    @VisibleForTesting
    int getCurrentBufferSize() {
        return this.currentBuffer.size();
    }

    @VisibleForTesting
    int getReadyBufferSize() {
        return this.readyBuffer.size();
    }

    @VisibleForTesting
    public void resume() {
        this.isRunning.set(true);
    }

    public void awaitFlush() throws InterruptedException {
        this.flushNotifier.await();
    }

    /* synthetic */ OzoneManagerDoubleBuffer(OMMetadataManager oMMetadataManager, OzoneManagerRatisSnapshot ozoneManagerRatisSnapshot, boolean bl, boolean bl2, Function function, int n, FlushNotifier flushNotifier, S3SecretManager s3SecretManager, String string, OzoneManagerDoubleBuffer ozoneManagerDoubleBuffer) {
        this(oMMetadataManager, ozoneManagerRatisSnapshot, bl, bl2, function, n, flushNotifier, s3SecretManager, string);
    }

    public static class Builder {
        private OMMetadataManager mm;
        private OzoneManagerRatisSnapshot rs;
        private boolean isRatisEnabled = false;
        private boolean isTracingEnabled = false;
        private Function<Long, Long> indexToTerm = null;
        private int maxUnFlushedTransactionCount = 0;
        private FlushNotifier flushNotifier;
        private S3SecretManager s3SecretManager;
        private String threadPrefix = "";

        public Builder setOmMetadataManager(OMMetadataManager omm) {
            this.mm = omm;
            return this;
        }

        public Builder setOzoneManagerRatisSnapShot(OzoneManagerRatisSnapshot omrs) {
            this.rs = omrs;
            return this;
        }

        public Builder enableRatis(boolean enableRatis) {
            this.isRatisEnabled = enableRatis;
            return this;
        }

        public Builder enableTracing(boolean enableTracing) {
            this.isTracingEnabled = enableTracing;
            return this;
        }

        public Builder setIndexToTerm(Function<Long, Long> termGet) {
            this.indexToTerm = termGet;
            return this;
        }

        public Builder setmaxUnFlushedTransactionCount(int size) {
            this.maxUnFlushedTransactionCount = size;
            return this;
        }

        public Builder setFlushNotifier(FlushNotifier flushNotifier) {
            this.flushNotifier = flushNotifier;
            return this;
        }

        public Builder setThreadPrefix(String prefix) {
            this.threadPrefix = prefix;
            return this;
        }

        public Builder setS3SecretManager(S3SecretManager s3SecretManager) {
            this.s3SecretManager = s3SecretManager;
            return this;
        }

        public OzoneManagerDoubleBuffer build() {
            if (this.isRatisEnabled) {
                Preconditions.checkNotNull((Object)this.rs, (Object)"When ratis is enabled, OzoneManagerRatisSnapshot should not be null");
                Preconditions.checkNotNull(this.indexToTerm, (Object)"When ratis is enabled indexToTerm should not be null");
                Preconditions.checkState(((long)this.maxUnFlushedTransactionCount > 0L ? 1 : 0) != 0, (Object)"when ratis is enable, maxUnFlushedTransactions should be bigger than 0");
            }
            if (this.flushNotifier == null) {
                this.flushNotifier = new FlushNotifier();
            }
            return new OzoneManagerDoubleBuffer(this.mm, this.rs, this.isRatisEnabled, this.isTracingEnabled, this.indexToTerm, this.maxUnFlushedTransactionCount, this.flushNotifier, this.s3SecretManager, this.threadPrefix, null);
        }
    }

    static class FlushNotifier {
        private final Set<CountDownLatch> flushLatches = ConcurrentHashMap.newKeySet();

        FlushNotifier() {
        }

        void await() throws InterruptedException {
            CountDownLatch latch = new CountDownLatch(2);
            this.flushLatches.add(latch);
            latch.await();
            this.flushLatches.remove(latch);
        }

        int notifyFlush() {
            int retval = this.flushLatches.size();
            for (CountDownLatch l : this.flushLatches) {
                l.countDown();
            }
            return retval;
        }
    }
}

