/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyRenameResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyRenameRequestWithFSO
extends OMKeyRenameRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyRenameRequestWithFSO.class);

    public OMKeyRenameRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        AuditLogger auditLogger;
        String toKeyName;
        String fromKeyName;
        String bucketName;
        String volumeName;
        Map<String, String> auditMap;
        OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest;
        block24: {
            renameKeyRequest = this.getOmRequest().getRenameKeyRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = renameKeyRequest.getKeyArgs();
            auditMap = this.buildAuditMap(keyArgs, renameKeyRequest);
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            fromKeyName = keyArgs.getKeyName();
            toKeyName = renameKeyRequest.getToKeyName();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumKeyRenames();
            auditLogger = ozoneManager.getAuditLogger();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            omClientResponse = null;
            exception = null;
            try {
                try {
                    if (fromKeyName.length() == 0) {
                        throw new OMException("Source key name is empty", OMException.ResultCodes.INVALID_KEY_NAME);
                    }
                    keyArgs = this.resolveBucketLink(ozoneManager, keyArgs, auditMap);
                    volumeName = keyArgs.getVolumeName();
                    bucketName = keyArgs.getBucketName();
                    this.checkACLsWithFSO(ozoneManager, volumeName, bucketName, fromKeyName, IAccessAuthorizer.ACLType.DELETE);
                    if (toKeyName.isEmpty()) {
                        this.checkBucketAcls(ozoneManager, volumeName, bucketName, toKeyName, IAccessAuthorizer.ACLType.CREATE);
                    } else {
                        this.checkKeyAcls(ozoneManager, volumeName, bucketName, toKeyName, IAccessAuthorizer.ACLType.CREATE, OzoneObj.ResourceType.KEY);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OzoneFileStatus fromKeyFileStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, fromKeyName, 0L, ozoneManager.getDefaultReplicationConfig());
                    if (fromKeyFileStatus == null) {
                        throw new OMException("Key not found " + fromKeyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    if (fromKeyFileStatus.getKeyInfo().isHsync()) {
                        throw new OMException("Open file cannot be renamed since it is hsync'ed: volumeName=" + volumeName + ", bucketName=" + bucketName + ", key=" + fromKeyName, OMException.ResultCodes.RENAME_OPEN_FILE);
                    }
                    OmKeyInfo fromKeyValue = fromKeyFileStatus.getKeyInfo();
                    boolean isRenameDirectory = fromKeyFileStatus.isDirectory();
                    OMFileRequest.verifyToDirIsASubDirOfFromDirectory(fromKeyName, toKeyName, fromKeyFileStatus.isDirectory());
                    OzoneFileStatus toKeyFileStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, toKeyName, 0L, ozoneManager.getDefaultReplicationConfig());
                    if (toKeyFileStatus != null) {
                        OmKeyInfo toKeyValue = toKeyFileStatus.getKeyInfo();
                        if (fromKeyValue.getKeyName().equals(toKeyValue.getKeyName())) {
                            if (!toKeyFileStatus.isFile()) throw new OMException("Key already exists " + toKeyName, OMException.ResultCodes.KEY_ALREADY_EXISTS);
                            result = OMClientRequest.Result.SUCCESS;
                        } else {
                            if (!toKeyFileStatus.isDirectory()) throw new OMException("Failed to rename, key already exists " + toKeyName, OMException.ResultCodes.KEY_ALREADY_EXISTS);
                            String fromFileName = OzoneFSUtils.getFileName((String)fromKeyName);
                            String newToKeyName = OzoneFSUtils.appendFileNameToKeyPath((String)toKeyName, (String)fromFileName);
                            OzoneFileStatus newToOzoneFileStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, newToKeyName, 0L, ozoneManager.getDefaultReplicationConfig());
                            if (newToOzoneFileStatus != null) {
                                throw new OMException(String.format("Failed to rename %s to %s, file already exists or not empty!", fromKeyName, newToKeyName), OMException.ResultCodes.KEY_ALREADY_EXISTS);
                            }
                            omClientResponse = this.renameKey(toKeyValue, newToKeyName, fromKeyValue, fromKeyName, isRenameDirectory, keyArgs.getModificationTime(), ozoneManager, omResponse, trxnLogIndex);
                            result = OMClientRequest.Result.SUCCESS;
                        }
                    } else {
                        OmKeyInfo toKeyParent = OMFileRequest.getKeyParentDir(volumeName, bucketName, toKeyName, ozoneManager, omMetadataManager);
                        omClientResponse = this.renameKey(toKeyParent, toKeyName, fromKeyValue, fromKeyName, isRenameDirectory, keyArgs.getModificationTime(), ozoneManager, omResponse, trxnLogIndex);
                        result = OMClientRequest.Result.SUCCESS;
                    }
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new OMKeyRenameResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse == null) throw throwable;
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditLog(auditLogger, this.buildAuditMessage(OMAction.RENAME_KEY, auditMap, exception, this.getOmRequest().getUserInfo()));
        switch (result) {
            case SUCCESS: {
                LOG.debug("Rename Key is successfully completed for volume:{} bucket:{} fromKey:{} toKey:{}. ", new Object[]{volumeName, bucketName, fromKeyName, toKeyName});
                return omClientResponse;
            }
            case FAILURE: {
                ozoneManager.getMetrics().incNumKeyRenameFails();
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Exception: {}.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, exception.getMessage()});
                return omClientResponse;
            }
            default: {
                LOG.error("Unrecognized Result for OMKeyRenameRequest: {}", (Object)renameKeyRequest);
            }
        }
        return omClientResponse;
    }

    private OMClientResponse renameKey(OmKeyInfo toKeyParent, String toKeyName, OmKeyInfo fromKeyValue, String fromKeyName, boolean isRenameDirectory, long modificationTime, OzoneManager ozoneManager, OzoneManagerProtocolProtos.OMResponse.Builder omResponse, long trxnLogIndex) throws IOException {
        OMMetadataManager ommm = ozoneManager.getMetadataManager();
        long volumeId = ommm.getVolumeId(fromKeyValue.getVolumeName());
        long bucketId = ommm.getBucketId(fromKeyValue.getVolumeName(), fromKeyValue.getBucketName());
        OmBucketInfo omBucketInfo = null;
        String dbFromKey = ommm.getOzonePathKey(volumeId, bucketId, fromKeyValue.getParentObjectID(), fromKeyValue.getFileName());
        String toKeyFileName = toKeyName.isEmpty() ? OzoneFSUtils.getFileName((String)fromKeyName) : OzoneFSUtils.getFileName((String)toKeyName);
        OmKeyInfo fromKeyParent = null;
        OMMetadataManager metadataMgr = ozoneManager.getMetadataManager();
        Table dirTable = metadataMgr.getDirectoryTable();
        String bucketKey = metadataMgr.getBucketKey(fromKeyValue.getVolumeName(), fromKeyValue.getBucketName());
        fromKeyValue.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
        fromKeyValue.setKeyName(toKeyFileName);
        fromKeyValue.setFileName(toKeyFileName);
        if (toKeyParent != null) {
            fromKeyValue.setParentObjectID(toKeyParent.getObjectID());
        } else {
            omBucketInfo = (OmBucketInfo)metadataMgr.getBucketTable().get((Object)bucketKey);
            fromKeyValue.setParentObjectID(omBucketInfo.getObjectID());
        }
        this.setModificationTime(ommm, omBucketInfo, toKeyParent, volumeId, bucketId, modificationTime, (Table<String, OmDirectoryInfo>)dirTable, trxnLogIndex);
        fromKeyParent = OMFileRequest.getKeyParentDir(fromKeyValue.getVolumeName(), fromKeyValue.getBucketName(), fromKeyName, ozoneManager, metadataMgr);
        if (fromKeyParent == null && omBucketInfo == null) {
            omBucketInfo = (OmBucketInfo)metadataMgr.getBucketTable().get((Object)bucketKey);
        }
        this.setModificationTime(ommm, omBucketInfo, fromKeyParent, volumeId, bucketId, modificationTime, (Table<String, OmDirectoryInfo>)dirTable, trxnLogIndex);
        String dbToKey = ommm.getOzonePathKey(volumeId, bucketId, fromKeyValue.getParentObjectID(), toKeyFileName);
        if (isRenameDirectory) {
            dirTable.addCacheEntry(new CacheKey((Object)dbFromKey), CacheValue.get((long)trxnLogIndex));
            dirTable.addCacheEntry(new CacheKey((Object)dbToKey), CacheValue.get((long)trxnLogIndex, (Object)OMFileRequest.getDirectoryInfo(fromKeyValue)));
        } else {
            Table keyTable = metadataMgr.getKeyTable(this.getBucketLayout());
            keyTable.addCacheEntry(new CacheKey((Object)dbFromKey), CacheValue.get((long)trxnLogIndex));
            keyTable.addCacheEntry(new CacheKey((Object)dbToKey), CacheValue.get((long)trxnLogIndex, (Object)fromKeyValue));
        }
        OMKeyRenameResponseWithFSO omClientResponse = new OMKeyRenameResponseWithFSO(omResponse.setRenameKeyResponse(OzoneManagerProtocolProtos.RenameKeyResponse.newBuilder()).build(), dbFromKey, dbToKey, fromKeyParent, toKeyParent, fromKeyValue, omBucketInfo, isRenameDirectory, this.getBucketLayout());
        return omClientResponse;
    }

    private void setModificationTime(OMMetadataManager omMetadataManager, OmBucketInfo bucketInfo, OmKeyInfo keyParent, long volumeId, long bucketId, long modificationTime, Table<String, OmDirectoryInfo> dirTable, long trxnLogIndex) throws OMException {
        if (keyParent != null) {
            keyParent.setModificationTime(modificationTime);
            String dbToKeyParent = omMetadataManager.getOzonePathKey(volumeId, bucketId, keyParent.getParentObjectID(), keyParent.getFileName());
            dirTable.addCacheEntry(new CacheKey((Object)dbToKeyParent), CacheValue.get((long)trxnLogIndex, (Object)OMFileRequest.getDirectoryInfo(keyParent)));
        } else {
            if (bucketInfo == null) {
                throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            bucketInfo.setModificationTime(modificationTime);
            String bucketKey = omMetadataManager.getBucketKey(bucketInfo.getVolumeName(), bucketInfo.getBucketName());
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), CacheValue.get((long)trxnLogIndex, (Object)bucketInfo));
        }
    }

    private Map<String, String> buildAuditMap(OzoneManagerProtocolProtos.KeyArgs keyArgs, OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest) {
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgs);
        auditMap.remove("key");
        auditMap.put("srcKey", keyArgs.getKeyName());
        auditMap.put("dstKey", renameKeyRequest.getToKeyName());
        return auditMap;
    }

    @Override
    protected String extractDstKey(OzoneManagerProtocolProtos.RenameKeyRequest request) throws OMException {
        String normalizedDstKey = OmUtils.normalizeKey((String)request.getToKeyName(), (boolean)false);
        return normalizedDstKey.isEmpty() ? normalizedDstKey : OMKeyRenameRequestWithFSO.isValidKeyPath(normalizedDstKey);
    }

    @Override
    protected String extractSrcKey(OzoneManagerProtocolProtos.KeyArgs keyArgs) throws OMException {
        return OMKeyRenameRequestWithFSO.validateAndNormalizeKey(keyArgs.getKeyName());
    }
}

