/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key.acl;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.ObjectParser;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.acl.OMKeyAclResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMKeyAclRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyAclRequest.class);
    private BucketLayout bucketLayout = BucketLayout.DEFAULT;

    public OMKeyAclRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long trxnLogIndex) {
        OMClientRequest.Result result;
        boolean operationResult;
        Exception exception;
        OMClientResponse omClientResponse;
        block18: {
            OmKeyInfo omKeyInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            String key = null;
            operationResult = false;
            result = null;
            try {
                try {
                    ObjectParser objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY);
                    ResolvedBucket resolvedBucket = ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)objectParser.getVolume(), (Object)objectParser.getBucket()));
                    volume = resolvedBucket.realVolume();
                    bucket = resolvedBucket.realBucket();
                    key = objectParser.getKey();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    String dbKey = omMetadataManager.getOzoneKey(volume, bucket, key);
                    omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable(this.getBucketLayout()).get((Object)dbKey);
                    if (omKeyInfo == null) {
                        throw new OMException(OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    operationResult = this.apply(omKeyInfo, trxnLogIndex);
                    omKeyInfo.setUpdateID(trxnLogIndex, ozoneManager.isRatisEnabled());
                    long modificationTime = omKeyInfo.getModificationTime();
                    if (this.getOmRequest().getAddAclRequest().hasObj() && operationResult) {
                        modificationTime = this.getOmRequest().getAddAclRequest().getModificationTime();
                    } else if (this.getOmRequest().getSetAclRequest().hasObj() && operationResult) {
                        modificationTime = this.getOmRequest().getSetAclRequest().getModificationTime();
                    } else if (this.getOmRequest().getRemoveAclRequest().hasObj() && operationResult) {
                        modificationTime = this.getOmRequest().getRemoveAclRequest().getModificationTime();
                    }
                    omKeyInfo.setModificationTime(modificationTime);
                    omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbKey), CacheValue.get((long)trxnLogIndex, (Object)omKeyInfo));
                    omClientResponse = this.onSuccess(omResponse, omKeyInfo, operationResult);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volume, bucket}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        OzoneObj obj = this.getObject();
        Map auditMap = obj.toAuditMap();
        this.onComplete(result, operationResult, exception, trxnLogIndex, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    abstract String getPath();

    public void initializeBucketLayout(OzoneManager ozoneManager) {
        try {
            ObjectParser objectParser = new ObjectParser(this.getPath(), OzoneManagerProtocolProtos.OzoneObj.ObjectType.KEY);
            String volume = objectParser.getVolume();
            String bucket = objectParser.getBucket();
            String buckKey = ozoneManager.getMetadataManager().getBucketKey(volume, bucket);
            try {
                OmBucketInfo buckInfo = (OmBucketInfo)ozoneManager.getMetadataManager().getBucketTable().get((Object)buckKey);
                if (buckInfo == null) {
                    LOG.error("Bucket not found: {}/{} ", (Object)volume, (Object)bucket);
                    return;
                }
                this.bucketLayout = buckInfo.getBucketLayout();
            }
            catch (IOException e) {
                LOG.error("Failed to get bucket for the key: " + buckKey, (Throwable)e);
            }
        }
        catch (OMException ome) {
            LOG.error("Invalid Path: " + this.getPath(), (Throwable)ome);
            return;
        }
    }

    abstract OzoneObj getObject();

    abstract OzoneManagerProtocolProtos.OMResponse.Builder onInit();

    abstract OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder var1, OmKeyInfo var2, boolean var3);

    OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, Exception exception) {
        return new OMKeyAclResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
    }

    abstract void onComplete(OMClientRequest.Result var1, boolean var2, Exception var3, long var4, AuditLogger var6, Map<String, String> var7);

    abstract boolean apply(OmKeyInfo var1, long var2);

    public void setBucketLayout(BucketLayout bucketLayout) {
        this.bucketLayout = bucketLayout;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }
}

