/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotUtils.class);

    private SnapshotUtils() {
        throw new IllegalStateException("SnapshotUtils should not be initialized.");
    }

    public static SnapshotInfo getSnapshotInfo(OzoneManager ozoneManager, String volumeName, String bucketName, String snapshotName) throws IOException {
        return SnapshotUtils.getSnapshotInfo(ozoneManager, SnapshotInfo.getTableKey((String)volumeName, (String)bucketName, (String)snapshotName));
    }

    public static SnapshotInfo getSnapshotInfo(OzoneManager ozoneManager, String snapshotKey) throws IOException {
        SnapshotInfo snapshotInfo;
        try {
            snapshotInfo = (SnapshotInfo)ozoneManager.getMetadataManager().getSnapshotInfoTable().get((Object)snapshotKey);
        }
        catch (IOException e) {
            LOG.error("Snapshot '{}' is not found.", (Object)snapshotKey, (Object)e);
            throw e;
        }
        if (snapshotInfo == null) {
            throw new OMException("Snapshot '" + snapshotKey + "' is not found.", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        return snapshotInfo;
    }

    public static void dropColumnFamilyHandle(ManagedRocksDB rocksDB, ColumnFamilyHandle columnFamilyHandle) {
        if (columnFamilyHandle == null) {
            return;
        }
        try {
            ((RocksDB)rocksDB.get()).dropColumnFamily(columnFamilyHandle);
        }
        catch (RocksDBException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void checkSnapshotDirExist(File checkpoint) throws IOException {
        if (!checkpoint.exists()) {
            throw new OMException("Unable to load snapshot. Snapshot checkpoint directory '" + checkpoint.getAbsolutePath() + "' does not exist yet. Please wait a few more seconds before " + "retrying", OMException.ResultCodes.TIMEOUT);
        }
    }

    public static void checkSnapshotActive(OzoneManager ozoneManager, String snapshotTableKey) throws IOException {
        SnapshotUtils.checkSnapshotActive(SnapshotUtils.getSnapshotInfo(ozoneManager, snapshotTableKey), false);
    }

    public static void checkSnapshotActive(SnapshotInfo snapInfo, boolean skipCheck) throws OMException {
        if (!skipCheck && snapInfo.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) {
            throw new OMException("Unable to load snapshot. Snapshot with table key '" + snapInfo.getTableKey() + "' is no longer active", OMException.ResultCodes.FILE_NOT_FOUND);
        }
    }

    /*
     * Exception decompiling
     */
    public static SnapshotInfo getNextActiveSnapshot(SnapshotInfo snapInfo, SnapshotChainManager chainManager, OzoneManager ozoneManager) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, String> getColumnFamilyToKeyPrefixMap(OMMetadataManager omMetadataManager, String volumeName, String bucketName) throws IOException {
        String keyPrefix = SnapshotUtils.getOzonePathKey(volumeName, bucketName);
        String keyPrefixFso = SnapshotUtils.getOzonePathKeyForFso(omMetadataManager, volumeName, bucketName);
        HashMap<String, String> columnFamilyToPrefixMap = new HashMap<String, String>();
        columnFamilyToPrefixMap.put("keyTable", keyPrefix);
        columnFamilyToPrefixMap.put("directoryTable", keyPrefixFso);
        columnFamilyToPrefixMap.put("fileTable", keyPrefixFso);
        return columnFamilyToPrefixMap;
    }

    public static String getOzonePathKey(String volumeName, String bucketName) throws IOException {
        return "/" + volumeName + "/" + bucketName + "/";
    }

    public static String getOzonePathKeyForFso(OMMetadataManager metadataManager, String volumeName, String bucketName) throws IOException {
        long volumeId = metadataManager.getVolumeId(volumeName);
        long bucketId = metadataManager.getBucketId(volumeName, bucketName);
        return "/" + volumeId + "/" + bucketId + "/";
    }
}

