/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import com.google.protobuf.ServiceException;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.token.SecretManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class S3SecurityUtil {
    private S3SecurityUtil() {
    }

    public static void validateS3Credential(OzoneManagerProtocolProtos.OMRequest omRequest, OzoneManager ozoneManager) throws ServiceException, OMException {
        if (ozoneManager.isSecurityEnabled()) {
            OzoneTokenIdentifier s3Token = S3SecurityUtil.constructS3Token(omRequest);
            try {
                ozoneManager.getDelegationTokenMgr().retrievePassword(s3Token);
            }
            catch (SecretManager.InvalidToken e) {
                if (e.getCause() != null && (e.getCause().getClass() == OMNotLeaderException.class || e.getCause().getClass() == OMLeaderNotReadyException.class)) {
                    throw new ServiceException(e.getCause());
                }
                OzoneManagerProtocolServerSideTranslatorPB.getLog().error("signatures do NOT match for S3 identifier:{}", (Object)s3Token, (Object)e);
                throw new OMException("User " + s3Token.getAwsAccessId() + " request authorization failure: signatures do NOT match", OMException.ResultCodes.INVALID_TOKEN);
            }
        }
    }

    private static OzoneTokenIdentifier constructS3Token(OzoneManagerProtocolProtos.OMRequest omRequest) {
        OzoneManagerProtocolProtos.S3Authentication auth = omRequest.getS3Authentication();
        OzoneTokenIdentifier s3Token = new OzoneTokenIdentifier();
        s3Token.setTokenType(OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO);
        s3Token.setStrToSign(auth.getStringToSign());
        s3Token.setSignature(auth.getSignature());
        s3Token.setAwsAccessId(auth.getAccessId());
        s3Token.setOwner(new Text(auth.getAccessId()));
        return s3Token;
    }
}

