/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.annotations;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.hadoop.hdds.scm.metadata.Replicate"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ReplicateAnnotationProcessor
extends AbstractProcessor {
    static final String ANNOTATION_NAME = "org.apache.hadoop.hdds.scm.metadata.Replicate";
    private static final String REQUIRED_EXCEPTION = "org.apache.hadoop.hdds.scm.exceptions.SCMException";
    private TypeMirror requiredException;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.requiredException = processingEnv.getElementUtils().getTypeElement(REQUIRED_EXCEPTION).asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            if (!ANNOTATION_NAME.contentEquals(typeElement.getQualifiedName())) continue;
            roundEnv.getElementsAnnotatedWith(typeElement).forEach(this::checkMethodSignature);
        }
        return false;
    }

    private void checkMethodSignature(Element element) {
        if (!(element instanceof ExecutableElement)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Replicate annotation should be on method.");
            return;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getThrownTypes().stream().noneMatch(m -> this.processingEnv.getTypeUtils().isAssignable(this.requiredException, (TypeMirror)m))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Method with Replicate annotation should declare throwing org.apache.hadoop.hdds.scm.exceptions.SCMException or one of its parents", executableElement);
        }
    }
}

