/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import picocli.CommandLine;

@CommandLine.Command(name="transfer", description={"Manually transfer the raft leadership to the target node."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class TransferOmLeaderSubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"Ozone Manager Service ID."})
    private String omServiceId;
    @CommandLine.ArgGroup(multiplicity="1")
    private TransferOption configGroup;

    @Override
    public Void call() throws Exception {
        OzoneManagerProtocolClientSideTranslatorPB client = this.parent.createOmClient(this.omServiceId, null, true);
        if (this.configGroup.isRandom) {
            this.configGroup.omNodeId = "";
        }
        client.transferLeadership(this.configGroup.omNodeId);
        System.out.println("Transfer leadership successfully to " + (this.configGroup.isRandom ? "random node" : this.configGroup.omNodeId) + ".");
        return null;
    }

    static class TransferOption {
        @CommandLine.Option(names={"-n", "--newLeaderId", "--new-leader-id"}, description={"The new leader id of OM to transfer leadership. E.g OM1."})
        private String omNodeId;
        @CommandLine.Option(names={"-r", "--random"}, description={"Randomly choose a follower to transfer leadership."})
        private boolean isRandom;

        TransferOption() {
        }
    }
}

