/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.audit.parser.handler;

import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.audit.parser.AuditParser;
import org.apache.hadoop.ozone.audit.parser.common.DatabaseHelper;
import picocli.CommandLine;

@CommandLine.Command(name="query", aliases={"q"}, description={"Execute custom query.\n\nTo run a custom read-only query:\nozone auditparser <path to db file> query <query>\n"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class QueryCommandHandler
implements Callable<Void> {
    @CommandLine.Parameters(arity="1..1", description={"Custom query enclosed within double quotes."})
    private String query;
    @CommandLine.ParentCommand
    private AuditParser auditParser;

    @Override
    public Void call() throws Exception {
        try {
            System.out.println(DatabaseHelper.executeCustomQuery(this.auditParser.getDatabase(), this.query));
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
        }
        return null;
    }
}

