/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.conf.OzoneManagersCommandHandler;
import org.apache.hadoop.ozone.conf.PrintConfKeyCommandHandler;
import org.apache.hadoop.ozone.conf.StorageContainerManagersCommandHandler;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import picocli.CommandLine;

@CommandLine.Command(name="ozone getconf", description={"ozone getconf is utility for getting configuration information from the config file."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={PrintConfKeyCommandHandler.class, StorageContainerManagersCommandHandler.class, OzoneManagersCommandHandler.class})
public class OzoneGetConf
extends GenericCli {
    private final PrintStream out;
    private final PrintStream err;
    private OzoneConfiguration conf;

    protected OzoneGetConf(OzoneConfiguration conf) {
        this(conf, System.out, System.err);
    }

    protected OzoneGetConf(OzoneConfiguration conf, PrintStream out, PrintStream err) {
        this.conf = conf;
        this.out = out;
        this.err = err;
    }

    void printError(String message) {
        this.err.println(message);
    }

    void printOut(String message) {
        this.out.println(message);
    }

    OzoneConfiguration getConf() {
        return this.conf;
    }

    public static void main(String[] argv) {
        LogManager.resetConfiguration();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        Logger.getLogger(NativeCodeLoader.class).setLevel(Level.ERROR);
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.addResource((Configuration)new OzoneConfiguration());
        new OzoneGetConf(conf).run(argv);
    }
}

