/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.debug.OzoneDebug;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import picocli.CommandLine;

@CommandLine.Command(name="print-log-dag", aliases={"pld"}, description={"Create an image of the current compaction log DAG in OM."})
public class CompactionLogDagPrinter
extends Handler
implements SubcommandWithParent {
    @CommandLine.Option(names={"-f", "--file-name-prefix"}, description={"Prefix to be use in image file name. (optional)"})
    private String fileNamePrefix;
    @CommandLine.Option(names={"-t", "--graph-type"}, description={"Type of node name to use in the graph image. (optional)\n Accepted values are: \n  file_name (default) : to use file name as node name in DAG,\n  key_size: to show the no. of keys in the file along with file name in the DAG node name,\n  cumulative_size: to show the cumulative size along with file name in the DAG node name."}, defaultValue="file_name")
    private String graphType;

    public Class<?> getParentType() {
        return OzoneDebug.class;
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException, OzoneClientException {
        String message = client.getObjectStore().printCompactionLogDag(this.fileNamePrefix, this.graphType);
        System.out.println(message);
    }
}

