/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dcg", aliases={"datanode-chunk-generator"}, description={"Create as many chunks as possible with pure XCeiverClient."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class DatanodeChunkGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeChunkGenerator.class);
    @CommandLine.Option(names={"-a", "--async"}, description={"Use async operation."}, defaultValue="false")
    private boolean async;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated chunks (in bytes)"}, defaultValue="1024")
    private int chunkSize;
    @CommandLine.Option(names={"-l", "--pipeline"}, description={"Pipeline to use. By default the first RATIS/THREE pipeline will be used."}, defaultValue="")
    private String pipelineIds;
    @CommandLine.Option(names={"-d", "--datanodes"}, description={"Datanodes to use. Test will write to all the existing pipelines which this datanode is member of."}, defaultValue="")
    private String datanodes;
    private List<XceiverClientSpi> xceiverClients;
    private Timer timer;
    private ByteString dataToWrite;
    private ContainerProtos.ChecksumData checksumProtobuf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        OzoneConfiguration ozoneConf = this.createOzoneConfiguration();
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)ozoneConf)) {
            throw new IllegalArgumentException("Datanode chunk generator is not supported in secure environment");
        }
        List<String> pipelinesFromCmd = Arrays.asList(this.pipelineIds.split(","));
        List<String> datanodeHosts = Arrays.asList(this.datanodes.split(","));
        try (StorageContainerLocationProtocol scmLocationClient = this.createStorageContainerLocationClient(ozoneConf);
             XceiverClientManager xceiverClientManager = new XceiverClientManager((ConfigurationSource)ozoneConf);){
            List pipelinesFromSCM = scmLocationClient.listPipelines();
            this.init();
            if (!this.arePipelinesOrDatanodesProvided()) {
                Pipeline firstPipeline = pipelinesFromSCM.stream().filter(p -> p.getReplicationConfig().getRequiredNodes() == 3).findFirst().orElseThrow(() -> new IllegalArgumentException("Pipeline ID is NOT defined, and no pipeline has been found with factor=THREE"));
                XceiverClientSpi xceiverClientSpi = xceiverClientManager.acquireClient(firstPipeline);
                this.xceiverClients = new ArrayList<XceiverClientSpi>();
                this.xceiverClients.add(xceiverClientSpi);
            } else {
                this.xceiverClients = new ArrayList<XceiverClientSpi>();
                HashSet pipelines = new HashSet();
                for (String pipelineId : pipelinesFromCmd) {
                    List selectedPipelines = pipelinesFromSCM.stream().filter(p -> p.getId().toString().equals("PipelineID=" + pipelineId) || this.pipelineContainsDatanode((Pipeline)p, datanodeHosts)).collect(Collectors.toList());
                    pipelines.addAll(selectedPipelines);
                }
                for (Pipeline p2 : pipelines) {
                    LOG.info("Writing to pipeline: " + p2.getId());
                    this.xceiverClients.add(xceiverClientManager.acquireClient(p2));
                }
                if (pipelines.isEmpty()) {
                    throw new IllegalArgumentException("Couldn't find the any/the selected pipeline");
                }
            }
            this.runTest();
        }
        finally {
            for (XceiverClientSpi xceiverClientSpi : this.xceiverClients) {
                if (xceiverClientSpi == null) continue;
                xceiverClientSpi.close();
            }
        }
        return null;
    }

    private boolean pipelineContainsDatanode(Pipeline p, List<String> datanodeHosts) {
        for (DatanodeDetails dn : p.getNodes()) {
            if (!datanodeHosts.contains(dn.getHostName())) continue;
            return true;
        }
        return false;
    }

    private boolean arePipelinesOrDatanodesProvided() {
        return !this.pipelineIds.equals("") || !this.datanodes.equals("");
    }

    private void runTest() throws IOException {
        this.timer = this.getMetrics().timer("chunk-write");
        byte[] data = RandomStringUtils.randomAscii((int)this.chunkSize).getBytes(StandardCharsets.UTF_8);
        this.dataToWrite = ByteString.copyFrom((byte[])data);
        Checksum checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, this.chunkSize);
        this.checksumProtobuf = checksum.computeChecksum(data).getProtoBufMessage();
        this.runTests(this::writeChunk);
    }

    private void writeChunk(long stepNo) throws Exception {
        ContainerProtos.DatanodeBlockID blockId = ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(1L).setLocalID(stepNo % 20L).build();
        ContainerProtos.ChunkInfo chunkInfo = ContainerProtos.ChunkInfo.newBuilder().setChunkName(this.getPrefix() + "_testdata_chunk_" + stepNo).setOffset(stepNo / 20L * (long)this.chunkSize).setLen((long)this.chunkSize).setChecksumData(this.checksumProtobuf).build();
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(blockId).setChunkData(chunkInfo).setData(this.dataToWrite);
        XceiverClientSpi clientSpi = this.xceiverClients.get((int)(stepNo % (long)this.xceiverClients.size()));
        this.sendWriteChunkRequest(blockId, writeChunkRequest, clientSpi);
    }

    private void sendWriteChunkRequest(ContainerProtos.DatanodeBlockID blockId, ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest, XceiverClientSpi xceiverClientSpi) throws Exception {
        DatanodeDetails datanodeDetails = xceiverClientSpi.getPipeline().getFirstNode();
        String id = datanodeDetails.getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockId.getContainerID()).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        this.timer.time(() -> {
            if (this.async) {
                XceiverClientReply xceiverClientReply = xceiverClientSpi.sendCommandAsync(request);
                xceiverClientSpi.watchForCommit(xceiverClientReply.getLogIndex());
            } else {
                xceiverClientSpi.sendCommand(request);
            }
            return null;
        });
    }
}

