/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dtsg", aliases={"dfs-tree-generator"}, description={"Create nested directories and create given number of files in each dir in any dfs compatible file system."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopDirTreeGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopDirTreeGenerator.class);
    @CommandLine.Option(names={"-r", "--rpath"}, description={"Hadoop FS root path"}, defaultValue="o3fs://bucket2.vol2")
    private String rootPath;
    @CommandLine.Option(names={"-d", "--depth"}, description={"Number of directories to be generated recursively"}, defaultValue="5")
    private int depth;
    @CommandLine.Option(names={"-c", "--file-count", "--fileCount"}, description={"Number of files to be written in each directory. Full name --fileCount will be removed in later versions."}, defaultValue="2")
    private int fileCount;
    @CommandLine.Option(names={"-g", "--file-size", "--fileSize"}, description={"Generated data size of each file to be written in each directory. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="4KB", converter={StorageSizeConverter.class})
    private StorageSize fileSize;
    @CommandLine.Option(names={"-b", "--buffer"}, description={"Size of buffer used to generated the file content."}, defaultValue="1024")
    private int bufferSize;
    @CommandLine.Option(names={"-s", "--span"}, description={"Number of child directories to be created in each directory."}, defaultValue="10")
    private int span;
    @CommandLine.Option(names={"-l", "--name-len", "--nameLen"}, description={"Length of the random name of directory you want to create. Full name --nameLen will be removed in later versions."}, defaultValue="10")
    private int length;
    private AtomicLong totalDirsCnt = new AtomicLong();
    private Timer timer;
    private ContentGenerator contentGenerator;
    private FileSystem fileSystem;

    @Override
    public Void call() throws Exception {
        if (this.depth <= 0) {
            String s = "Invalid depth value, depth value should be greater than zero!";
            this.print(s);
        } else if (this.span <= 0) {
            String s = "Invalid span value, span value should be greater than zero!";
            this.print(s);
        } else {
            this.init();
            OzoneConfiguration configuration = this.createOzoneConfiguration();
            this.fileSystem = FileSystem.get((URI)URI.create(this.rootPath), (Configuration)configuration);
            this.contentGenerator = new ContentGenerator(this.fileSize.toBytes(), this.bufferSize);
            this.timer = this.getMetrics().timer("file-create");
            this.runTests(this::createDir);
        }
        return null;
    }

    private void createDir(long counter) throws Exception {
        String dir = this.makeDirWithGivenNumberOfFiles(this.rootPath);
        if (this.depth > 1) {
            this.createSubDirRecursively(dir, 1, 1);
        }
        String message = "Successfully created directories & files. Total Dirs Count=" + this.totalDirsCnt.get() + ", Total Files Count=" + this.timer.getCount();
        this.print(message);
    }

    private void createSubDirRecursively(String parent, int depthIndex, int spanIndex) throws Exception {
        if (depthIndex < this.depth) {
            String depthSubDir = this.makeDirWithGivenNumberOfFiles(parent);
            ++depthIndex;
            if (LOG.isDebugEnabled()) {
                LOG.debug("SubDir:{}, depthIndex:{} +", (Object)depthSubDir, (Object)depthIndex);
            }
            if (depthIndex < this.depth) {
                this.createSubDirRecursively(depthSubDir, depthIndex, spanIndex);
            }
        }
        while (spanIndex < this.span) {
            String levelSubDir = this.makeDirWithGivenNumberOfFiles(parent);
            ++spanIndex;
            if (LOG.isDebugEnabled()) {
                LOG.debug("SpanSubDir:{}, depthIndex:{}, spanIndex:{} +", new Object[]{levelSubDir, depthIndex, spanIndex});
            }
            if (depthIndex >= this.depth) continue;
            this.createSubDirRecursively(levelSubDir, depthIndex, 1);
        }
    }

    private String makeDirWithGivenNumberOfFiles(String parent) throws Exception {
        String dir = RandomStringUtils.randomAlphanumeric((int)this.length);
        dir = parent.toString().concat("/").concat(dir);
        this.fileSystem.mkdirs(new Path(dir));
        this.totalDirsCnt.incrementAndGet();
        this.createFiles(dir);
        return dir;
    }

    private void createFile(String dir, long counter) throws Exception {
        String fileName = dir.concat("/").concat(RandomStringUtils.randomAlphanumeric((int)this.length));
        Path file = new Path(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("FilePath:{}", (Object)file);
        }
        this.timer.time(() -> {
            try (FSDataOutputStream output = this.fileSystem.create(file);){
                this.contentGenerator.write((OutputStream)output);
            }
            return null;
        });
    }

    private void createFiles(String dir) throws Exception {
        for (int i = 0; i < this.fileCount; ++i) {
            this.createFile(dir, i);
        }
    }
}

