/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dfsv", aliases={"dfs-file-validator"}, description={"Validate if the generated files have the same hash."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopFsValidator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFsValidator.class);
    @CommandLine.Option(names={"--path"}, description={"Hadoop FS file system path"}, defaultValue="o3fs://bucket1.vol1")
    private String rootPath;
    private ContentGenerator contentGenerator;
    private Timer timer;
    private FileSystem fileSystem;
    private byte[] referenceDigest;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration configuration = this.createOzoneConfiguration();
        this.fileSystem = FileSystem.get((URI)URI.create(this.rootPath), (Configuration)configuration);
        Path file = new Path(this.rootPath + "/" + this.generateObjectName(0L));
        try (FSDataInputStream stream = this.fileSystem.open(file);){
            this.referenceDigest = HadoopFsValidator.getDigest((InputStream)stream);
        }
        this.timer = this.getMetrics().timer("file-read");
        this.runTests(this::validateFile);
        return null;
    }

    private void validateFile(long counter) throws Exception {
        Path file = new Path(this.rootPath + "/" + this.generateObjectName(counter));
        byte[] content = (byte[])this.timer.time(() -> {
            try (FSDataInputStream input = this.fileSystem.open(file);){
                byte[] byArray = IOUtils.toByteArray((InputStream)input);
                return byArray;
            }
        });
        if (!MessageDigest.isEqual(this.referenceDigest, HadoopFsValidator.getDigest(content))) {
            throw new IllegalStateException("Reference (=first) message digest doesn't match with digest of " + file.toString());
        }
    }
}

