/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientRatis;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.freon.BaseAppendLogGenerator;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.NegotiationType;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="lalg", aliases={"leader-append-log-generator"}, description={"Generate append log entries to a leader server"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class LeaderAppendLogEntryGenerator
extends BaseAppendLogGenerator
implements Callable<Void> {
    public static final String FAKE_LEADER_ADDDRESS1 = "localhost:1234";
    public static final String FAKE_LEADER_ADDDRESS2 = "localhost:1235";
    private static final Logger LOG = LoggerFactory.getLogger(LeaderAppendLogEntryGenerator.class);
    private static final String FAKE_FOLLOWER_ID1 = "ffffffff-df33-4a20-8e1f-ffffffff6be5";
    @CommandLine.Option(names={"-l", "--pipeline"}, description={"Pipeline to use. By default the first RATIS/THREE pipeline will be used."}, defaultValue="96714307-4bd7-42b5-a65d-e1b13b4ca5c0")
    private String pipelineId = "96714307-4bd7-42b5-a65d-e1b13b4ca5c0";
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated chunks (in bytes)"}, defaultValue="1024")
    private int chunkSize;
    @CommandLine.Option(names={"-i", "--next-index"}, description={"The next index in the term 2 to continue a test. (If zero, a new ratis ring will be intialized with configureGroup call and vote)"}, defaultValue="0")
    private long nextIndex;
    private RaftProtos.RaftPeerProto requestor;
    private long term = 2L;
    private RaftServerProtocolServiceGrpc.RaftServerProtocolServiceStub stub;
    private Random callIdRandom = new Random();
    private ByteString dataToWrite;
    private Timer timer;

    @Override
    public Void call() throws Exception {
        this.inFlightMessages = new LinkedBlockingQueue(this.inflightLimit);
        OzoneConfiguration conf = this.createOzoneConfiguration();
        byte[] data = RandomStringUtils.randomAscii((int)this.chunkSize).getBytes(StandardCharsets.UTF_8);
        this.dataToWrite = ByteString.copyFrom((byte[])data);
        this.setServerIdFromFile(conf);
        this.requestor = RaftProtos.RaftPeerProto.newBuilder().setId(RaftPeerId.valueOf((String)FAKE_FOLLOWER_ID1).toByteString()).setAddress(FAKE_LEADER_ADDDRESS1).build();
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forTarget((String)this.serverAddress);
        channelBuilder.negotiationType(NegotiationType.PLAINTEXT);
        ManagedChannel build = channelBuilder.build();
        this.stub = RaftServerProtocolServiceGrpc.newStub((Channel)build);
        this.init();
        if (this.nextIndex == 0L) {
            this.configureGroup();
        }
        Thread.sleep(3000L);
        XceiverClientRatis client = this.createXceiverClient(conf);
        client.connect();
        long containerId = 1L;
        System.out.println(client.sendCommand(this.createContainerRequest(containerId)));
        this.timer = this.getMetrics().timer("append-entry");
        this.runTests(step -> this.timer.time(() -> {
            this.inFlightMessages.put(step);
            XceiverClientReply xceiverClientReply = client.sendCommandAsync(this.createChunkWriteRequest(containerId, step));
            xceiverClientReply.getResponse().thenApply(response -> this.inFlightMessages.remove(step));
            return null;
        }));
        return null;
    }

    private XceiverClientRatis createXceiverClient(OzoneConfiguration conf) {
        ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
        datanodes.add(DatanodeDetails.newBuilder().setUuid(UUID.fromString(this.serverId)).setHostName("localhost").setIpAddress("127.0.0.1").addPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.RATIS, (Integer)9858)).build());
        Pipeline pipeline = Pipeline.newBuilder().setId(PipelineID.valueOf((UUID)UUID.fromString(this.pipelineId))).setState(Pipeline.PipelineState.OPEN).setReplicationConfig((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE)).setLeaderId(UUID.fromString(this.serverId)).setNodes(datanodes).build();
        return XceiverClientRatis.newXceiverClientRatis((Pipeline)pipeline, (ConfigurationSource)conf);
    }

    private ContainerProtos.ContainerCommandRequestProto createContainerRequest(long containerId) {
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setContainerID(containerId).setCmdType(ContainerProtos.Type.CreateContainer).setDatanodeUuid(this.serverId).setCreateContainer(ContainerProtos.CreateContainerRequestProto.newBuilder().setContainerType(ContainerProtos.ContainerType.KeyValueContainer).build()).build();
    }

    private ContainerProtos.ContainerCommandRequestProto createChunkWriteRequest(long containerId, long chunkId) {
        long blockId = (long)this.getPrefix().hashCode() + chunkId / 1000L;
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setContainerID(containerId).setCmdType(ContainerProtos.Type.WriteChunk).setDatanodeUuid(this.serverId).setWriteChunk(ContainerProtos.WriteChunkRequestProto.newBuilder().setData(this.dataToWrite).setBlockID(ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(containerId).setLocalID(blockId).build()).setChunkData(ContainerProtos.ChunkInfo.newBuilder().setChunkName("chunk" + chunkId).setLen((long)this.dataToWrite.size()).setOffset(0L).setChecksumData(ContainerProtos.ChecksumData.newBuilder().setBytesPerChecksum(0).setType(ContainerProtos.ChecksumType.NONE).build()).build()).build()).build();
    }

    private void configureGroup() throws IOException {
        ClientId clientId = ClientId.randomId();
        RaftGroupId groupId = RaftGroupId.valueOf((UUID)UUID.fromString(this.pipelineId));
        RaftPeerId peerId = RaftPeerId.getRaftPeerId((String)this.serverId);
        RaftGroup group = RaftGroup.valueOf((RaftGroupId)groupId, (RaftPeer[])new RaftPeer[]{RaftPeer.newBuilder().setId(this.serverId).setAddress(this.serverAddress).build(), RaftPeer.newBuilder().setId(RaftPeerId.valueOf((String)FAKE_FOLLOWER_ID1)).setAddress(FAKE_LEADER_ADDDRESS1).build(), RaftPeer.newBuilder().setId(RaftPeerId.valueOf((String)FAKE_FOLLOWER_ID1)).setAddress(FAKE_LEADER_ADDDRESS2).build()});
        RaftClient client = RaftClient.newBuilder().setClientId(clientId).setProperties(new RaftProperties()).setRaftGroup(group).build();
        RaftClientReply raftClientReply = client.getGroupManagementApi(peerId).add(group);
        LOG.info("Group is configured in the RAFT server (with two fake leader leader): {}", (Object)raftClientReply);
    }
}

