/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import picocli.CommandLine;

@CommandLine.Command(name="om-echo", aliases={"ome"}, description={"Generate echo RPC request to the OM with or without payload. Max payload size is 2097151 KB"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmRPCLoadGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    private static final int RPC_PAYLOAD_MULTIPLICATION_FACTOR = 1024;
    private static final int MAX_SIZE_KB = 0x1FFFFF;
    private Timer timer;
    private OzoneConfiguration configuration;
    private OzoneManagerProtocolClientSideTranslatorPB[] clients;
    private byte[] payloadReqBytes = new byte[0];
    private int payloadRespSize;
    @CommandLine.Option(names={"--payload-req"}, description={"Specifies the size of payload in KB in RPC request. Max size is 2097151 KB"}, defaultValue="0")
    private int payloadReqSizeKB = 0;
    @CommandLine.Option(names={"--clients"}, description={"Number of clients, defaults 1."}, defaultValue="1")
    private int clientsCount = 1;
    @CommandLine.Option(names={"--payload-resp"}, description={"Specifies the size of payload in KB in RPC response. Max size is 2097151 KB"}, defaultValue="0")
    private int payloadRespSizeKB = 0;
    @CommandLine.Option(names={"--ratis"}, description={"Write to Ratis log, skip flag for read-only EchoRPC request"})
    private boolean writeToRatis = false;

    @Override
    public Void call() throws Exception {
        int i;
        Preconditions.checkArgument((this.payloadReqSizeKB >= 0 ? 1 : 0) != 0, (Object)"OM echo request payload size should be positive value or zero.");
        Preconditions.checkArgument((this.payloadRespSizeKB >= 0 ? 1 : 0) != 0, (Object)"OM echo response payload size should be positive value or zero.");
        this.configuration = this.createOzoneConfiguration();
        this.clients = new OzoneManagerProtocolClientSideTranslatorPB[this.clientsCount];
        for (i = 0; i < this.clientsCount; ++i) {
            this.clients[i] = this.createOmClient(this.configuration, null);
        }
        this.init();
        this.payloadReqBytes = RandomUtils.nextBytes((int)this.calculateMaxPayloadSize(this.payloadReqSizeKB));
        this.payloadRespSize = this.calculateMaxPayloadSize(this.payloadRespSizeKB);
        this.timer = this.getMetrics().timer("rpc-payload");
        try {
            this.runTests(this::sendRPCReq);
        }
        finally {
            for (i = 0; i < this.clientsCount; ++i) {
                if (this.clients[i] == null) continue;
                this.clients[i].close();
            }
        }
        return null;
    }

    private int calculateMaxPayloadSize(int payloadSizeKB) {
        if (payloadSizeKB > 0) {
            return Math.min(Math.toIntExact((long)payloadSizeKB * 1024L), 0x1FFFFF);
        }
        return 0;
    }

    private void sendRPCReq(long l) throws Exception {
        this.timer.time(() -> {
            this.clients[(int)(l % (long)this.clientsCount)].echoRPCReq(this.payloadReqBytes, this.payloadRespSize, this.writeToRatis);
            return null;
        });
    }
}

