/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import picocli.CommandLine;

@CommandLine.Command(name="link", description={"creates a symlink to another bucket"})
public class LinkBucketHandler
extends Handler {
    @CommandLine.Parameters(index="0", arity="1..1", description={"The bucket which the link should point to."}, converter={BucketUri.class})
    private OzoneAddress source;
    @CommandLine.Parameters(index="1", arity="1..1", description={"Address of the link bucket"}, converter={BucketUri.class})
    private OzoneAddress target;

    @Override
    protected OzoneAddress getAddress() {
        return this.source;
    }

    @Override
    public void execute(OzoneClient client, OzoneAddress address) throws IOException {
        BucketArgs.Builder bb = new BucketArgs.Builder().setStorageType(StorageType.DEFAULT).setVersioning(Boolean.valueOf(false)).setSourceVolume(this.source.getVolumeName()).setSourceBucket(this.source.getBucketName());
        String volumeName = this.target.getVolumeName();
        String bucketName = this.target.getBucketName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        vol.createBucket(bucketName, bb.build());
        if (this.isVerbose()) {
            OzoneBucket bucket = vol.getBucket(bucketName);
            this.printObjectAsJson(bucket);
        }
    }
}

