/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.TenantArgs;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a tenant. This can create a new Ozone volume for the tenant."})
public class TenantCreateHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Tenant name"}, arity="1..1")
    private String tenantId;
    @CommandLine.Option(names={"-f", "--force"}, description={"(Optional) Force tenant creation even when volume exists. This does NOT override other errors like Ranger failure."}, hidden=true)
    private boolean forceCreationWhenVolumeExists;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        TenantArgs tenantArgs = TenantArgs.newBuilder().setVolumeName(this.tenantId).setForceCreationWhenVolumeExists(this.forceCreationWhenVolumeExists).build();
        client.getObjectStore().createTenant(this.tenantId, tenantArgs);
        if (this.isVerbose()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("tenantId", this.tenantId);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            this.out().println(gson.toJson((JsonElement)obj));
        }
    }
}

