/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.DeleteTenantState;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="delete", aliases={"remove"}, description={"Delete an empty tenant. Will not remove the associated volume."})
public class TenantDeleteHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Tenant name"}, arity="1..1")
    private String tenantId;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        DeleteTenantState resp = client.getObjectStore().deleteTenant(this.tenantId);
        this.err().println("Deleted tenant '" + this.tenantId + "'.");
        long volumeRefCount = resp.getVolRefCount();
        assert (volumeRefCount >= 0L);
        String volumeName = resp.getVolumeName();
        String extraPrompt = "But the associated volume '" + volumeName + "' is not removed. ";
        if (volumeRefCount == 0L) {
            this.err().println(extraPrompt + "To delete it, run\n    ozone sh volume delete " + volumeName + "\n");
        } else {
            this.err().println(extraPrompt + "And it is still referenced by some other Ozone features (refCount is " + volumeRefCount + ").");
        }
        if (this.isVerbose()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("tenantId", this.tenantId);
            obj.addProperty("volumeName", resp.getVolumeName());
            obj.addProperty("volumeRefCount", (Number)resp.getVolRefCount());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            this.out().println(gson.toJson((JsonElement)obj));
        }
    }
}

