/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.ContainerCommands;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="close", description={"close container"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class CloseSubcommand
extends ScmSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(CloseSubcommand.class);
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"Id of the container to close"})
    private long containerId;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        ContainerCommands.checkContainerExists(scmClient, this.containerId);
        try {
            scmClient.closeContainer(this.containerId);
        }
        catch (IOException ioe) {
            boolean verbose;
            boolean bl = verbose = this.spec != null && this.spec.root().userObject() instanceof GenericParentCommand && ((GenericParentCommand)this.spec.root().userObject()).isVerbose();
            if (!verbose) {
                LOG.error("Unable to close container : {}", (Object)ioe.getMessage());
            }
            LOG.error("Unable to close container", (Throwable)ioe);
        }
    }
}

