/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.datanode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="decommission", description={"Decommission a datanode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class DecommissionSubCommand
extends ScmSubcommand {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters(description={"List of fully qualified host names"})
    private List<String> hosts = new ArrayList<String>();

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (this.hosts.size() > 0) {
            List errors = scmClient.decommissionNodes(this.hosts);
            System.out.println("Started decommissioning datanode(s):\n" + String.join((CharSequence)"\n", this.hosts));
            if (errors.size() > 0) {
                for (DatanodeAdminError error : errors) {
                    System.err.println("Error: " + error.getHostname() + ": " + error.getError());
                }
                throw new IOException("Some nodes could not enter the decommission workflow");
            }
        } else {
            GenericCli.missingSubcommand((CommandLine.Model.CommandSpec)this.spec);
        }
    }
}

