/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.hsqldb;

import java.sql.SQLException;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.hsqldb.information_schema.Tables;
import org.jooq.tools.StringUtils;

public class HSQLDBRoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;

    public HSQLDBRoutineDefinition(SchemaDefinition schema, String name, String specificName, String dataType, Number precision, Number scale) {
        this(schema, name, specificName, dataType, precision, scale, false);
    }

    public HSQLDBRoutineDefinition(SchemaDefinition schema, String name, String specificName, String dataType, Number precision, Number scale, boolean aggregate) {
        super(schema, null, name, null, null, aggregate);
        if (!StringUtils.isBlank((String)dataType)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale, null, (String)null);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = specificName;
    }

    @Override
    protected void init0() throws SQLException {
        Result result = this.create().select(Tables.PARAMETERS.PARAMETER_MODE, Tables.PARAMETERS.PARAMETER_NAME, (SelectField)DSL.nvl(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER, Tables.PARAMETERS.DATA_TYPE).as("datatype"), Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH, Tables.PARAMETERS.NUMERIC_PRECISION, Tables.PARAMETERS.NUMERIC_SCALE, Tables.PARAMETERS.ORDINAL_POSITION).from((TableLike)Tables.PARAMETERS).join((TableLike)Tables.ROUTINES).on(Tables.PARAMETERS.SPECIFIC_SCHEMA.equal(Tables.ROUTINES.SPECIFIC_SCHEMA)).and(Tables.PARAMETERS.SPECIFIC_NAME.equal(Tables.ROUTINES.SPECIFIC_NAME)).leftOuterJoin((TableLike)Tables.ELEMENT_TYPES).on(Tables.ROUTINES.ROUTINE_SCHEMA.equal(Tables.ELEMENT_TYPES.OBJECT_SCHEMA)).and(Tables.ROUTINES.ROUTINE_NAME.equal(Tables.ELEMENT_TYPES.OBJECT_NAME)).and(Tables.PARAMETERS.DTD_IDENTIFIER.equal(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(Tables.PARAMETERS.SPECIFIC_SCHEMA.equal((Object)this.getSchema().getName())).and(Tables.PARAMETERS.SPECIFIC_NAME.equal((Object)this.specificName)).and(DSL.condition((Field)DSL.val((!this.isAggregate() ? 1 : 0) != 0)).or(Tables.PARAMETERS.ORDINAL_POSITION.eq((Object)1L))).orderBy((OrderField)Tables.PARAMETERS.ORDINAL_POSITION.asc()).fetch();
        for (Record record : result) {
            String inOut = (String)record.get(Tables.PARAMETERS.PARAMETER_MODE);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.get("datatype", String.class), (Number)record.get(Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.PARAMETERS.NUMERIC_PRECISION), (Number)record.get(Tables.PARAMETERS.NUMERIC_SCALE), null, (String)null);
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, ((String)record.get(Tables.PARAMETERS.PARAMETER_NAME)).replaceAll("@", ""), (Integer)record.get(Tables.PARAMETERS.ORDINAL_POSITION, Integer.TYPE), type);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }
}

