/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.recon.api.types.AclMetadata;
import org.apache.hadoop.ozone.recon.api.types.ObjectDBInfo;

public class BucketObjectDBInfo
extends ObjectDBInfo {
    @JsonProperty(value="volumeName")
    private String volumeName;
    @JsonProperty(value="storageType")
    private StorageType storageType;
    @JsonProperty(value="versioning")
    private boolean isVersioningEnabled;
    @JsonProperty(value="usedBytes")
    private long usedBytes;
    @JsonProperty(value="encryptionInfo")
    private BucketEncryptionKeyInfo bekInfo;
    @JsonProperty(value="replicationConfigInfo")
    private DefaultReplicationConfig defaultReplicationConfig;
    @JsonProperty(value="sourceVolume")
    private String sourceVolume;
    @JsonProperty(value="sourceBucket")
    private String sourceBucket;
    @JsonProperty(value="bucketLayout")
    private BucketLayout bucketLayout;
    @JsonProperty(value="owner")
    private String owner;

    public BucketObjectDBInfo() {
    }

    public BucketObjectDBInfo(OmBucketInfo omBucketInfo) {
        super.setMetadata(omBucketInfo.getMetadata());
        super.setName(omBucketInfo.getBucketName());
        super.setQuotaInBytes(omBucketInfo.getQuotaInBytes());
        super.setQuotaInNamespace(omBucketInfo.getQuotaInNamespace());
        super.setUsedNamespace(omBucketInfo.getUsedNamespace());
        super.setCreationTime(omBucketInfo.getCreationTime());
        super.setModificationTime(omBucketInfo.getModificationTime());
        super.setAcls(AclMetadata.fromOzoneAcls(omBucketInfo.getAcls()));
        this.volumeName = omBucketInfo.getVolumeName();
        this.sourceBucket = omBucketInfo.getSourceBucket();
        this.sourceVolume = omBucketInfo.getSourceVolume();
        this.isVersioningEnabled = omBucketInfo.getIsVersionEnabled();
        this.storageType = omBucketInfo.getStorageType();
        this.defaultReplicationConfig = omBucketInfo.getDefaultReplicationConfig();
        this.bucketLayout = omBucketInfo.getBucketLayout();
        this.owner = omBucketInfo.getOwner();
        this.bekInfo = omBucketInfo.getEncryptionKeyInfo();
        this.usedBytes = omBucketInfo.getUsedBytes();
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public void setStorageType(StorageType storageType) {
        this.storageType = storageType;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public void setUsedBytes(long usedBytes) {
        this.usedBytes = usedBytes;
    }

    public BucketEncryptionKeyInfo getBekInfo() {
        return this.bekInfo;
    }

    public void setBekInfo(BucketEncryptionKeyInfo bekInfo) {
        this.bekInfo = bekInfo;
    }

    public DefaultReplicationConfig getDefaultReplicationConfig() {
        return this.defaultReplicationConfig;
    }

    public void setDefaultReplicationConfig(DefaultReplicationConfig defaultReplicationConfig) {
        this.defaultReplicationConfig = defaultReplicationConfig;
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public void setSourceVolume(String sourceVolume) {
        this.sourceVolume = sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public void setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
    }

    public boolean isVersioningEnabled() {
        return this.isVersioningEnabled;
    }

    public void setVersioningEnabled(boolean versioningEnabled) {
        this.isVersioningEnabled = versioningEnabled;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    public void setBucketLayout(BucketLayout bucketLayout) {
        this.bucketLayout = bucketLayout;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

