/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.recon.ReconUtils;

public class ReconStorageConfig
extends SCMStorageConfig {
    public static final String RECON_CERT_SERIAL_ID = "reconCertSerialId";
    public static final String RECON_ID = "uuid";

    @Inject
    public ReconStorageConfig(OzoneConfiguration conf, ReconUtils reconUtils) throws IOException {
        super(HddsProtos.NodeType.RECON, reconUtils.getReconDbDir((ConfigurationSource)conf, "ozone.recon.db.dir"), "recon");
    }

    public void setReconCertSerialId(String certSerialId) throws IOException {
        this.getStorageInfo().setProperty(RECON_CERT_SERIAL_ID, certSerialId);
    }

    public void setReconId(String uuid) throws IOException {
        if (this.getState() == Storage.StorageState.INITIALIZED) {
            throw new IOException("Recon is already initialized.");
        }
        this.getStorageInfo().setProperty(RECON_ID, uuid);
    }

    public String getReconId() {
        return this.getStorageInfo().getProperty(RECON_ID);
    }

    protected Properties getNodeProperties() {
        String reconId = this.getReconId();
        if (reconId == null) {
            reconId = UUID.randomUUID().toString();
        }
        Properties reconProperties = new Properties();
        reconProperties.setProperty(RECON_ID, reconId);
        if (this.getReconCertSerialId() != null) {
            reconProperties.setProperty(RECON_CERT_SERIAL_ID, this.getReconCertSerialId());
        }
        return reconProperties;
    }

    public String getReconCertSerialId() {
        return this.getStorageInfo().getProperty(RECON_CERT_SERIAL_ID);
    }

    public void unsetReconCertSerialId() {
        this.getStorageInfo().unsetProperty(RECON_CERT_SERIAL_ID);
    }
}

