/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTaskDbEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTaskDbEventHandler.class);
    private ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private ReconOMMetadataManager reconOMMetadataManager;
    private final long nsSummaryFlushToDBMaxThreshold;

    public NSSummaryTaskDbEventHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, OzoneConfiguration ozoneConfiguration) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconOMMetadataManager = reconOMMetadataManager;
        this.nsSummaryFlushToDBMaxThreshold = ozoneConfiguration.getLong("ozone.recon.nssummary.flush.db.max.threshold", 150000L);
    }

    public ReconNamespaceSummaryManager getReconNamespaceSummaryManager() {
        return this.reconNamespaceSummaryManager;
    }

    public ReconOMMetadataManager getReconOMMetadataManager() {
        return this.reconOMMetadataManager;
    }

    protected void writeNSSummariesToDB(Map<Long, NSSummary> nsSummaryMap) throws IOException {
        try (RDBBatchOperation rdbBatchOperation = new RDBBatchOperation();){
            nsSummaryMap.keySet().forEach(key -> {
                try {
                    this.reconNamespaceSummaryManager.batchStoreNSSummaries((BatchOperation)rdbBatchOperation, (long)key, (NSSummary)nsSummaryMap.get(key));
                }
                catch (IOException e) {
                    LOG.error("Unable to write Namespace Summary data in Recon DB.", (Throwable)e);
                }
            });
            this.reconNamespaceSummaryManager.commitBatchOperation(rdbBatchOperation);
        }
    }

    protected void handlePutKeyEvent(OmKeyInfo keyInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        int binIndex;
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        int numOfFile = nsSummary.getNumOfFiles();
        long sizeOfFile = nsSummary.getSizeOfFiles();
        int[] fileBucket = nsSummary.getFileSizeBucket();
        nsSummary.setNumOfFiles(numOfFile + 1);
        long dataSize = keyInfo.getDataSize();
        nsSummary.setSizeOfFiles(sizeOfFile + dataSize);
        int n = binIndex = ReconUtils.getFileSizeBinIndex(dataSize);
        fileBucket[n] = fileBucket[n] + 1;
        nsSummary.setFileSizeBucket(fileBucket);
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    protected void handlePutDirEvent(OmDirectoryInfo directoryInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        long parentObjectId = directoryInfo.getParentObjectID();
        long objectId = directoryInfo.getObjectID();
        String dirName = directoryInfo.getName();
        NSSummary curNSSummary = nsSummaryMap.get(objectId);
        if (curNSSummary == null) {
            curNSSummary = this.reconNamespaceSummaryManager.getNSSummary(objectId);
        }
        if (curNSSummary == null) {
            curNSSummary = new NSSummary();
        }
        curNSSummary.setDirName(dirName);
        curNSSummary.setParentId(parentObjectId);
        nsSummaryMap.put(objectId, curNSSummary);
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            nsSummary = new NSSummary();
        }
        nsSummary.addChildDir(objectId);
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    protected void handleDeleteKeyEvent(OmKeyInfo keyInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        long parentObjectId = keyInfo.getParentObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        int numOfFile = nsSummary.getNumOfFiles();
        long sizeOfFile = nsSummary.getSizeOfFiles();
        int[] fileBucket = nsSummary.getFileSizeBucket();
        long dataSize = keyInfo.getDataSize();
        int binIndex = ReconUtils.getFileSizeBinIndex(dataSize);
        nsSummary.setNumOfFiles(numOfFile - 1);
        nsSummary.setSizeOfFiles(sizeOfFile - dataSize);
        int n = binIndex;
        fileBucket[n] = fileBucket[n] - 1;
        nsSummary.setFileSizeBucket(fileBucket);
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    protected void handleDeleteDirEvent(OmDirectoryInfo directoryInfo, Map<Long, NSSummary> nsSummaryMap) throws IOException {
        long parentObjectId = directoryInfo.getParentObjectID();
        long objectId = directoryInfo.getObjectID();
        NSSummary nsSummary = nsSummaryMap.get(parentObjectId);
        if (nsSummary == null) {
            nsSummary = this.reconNamespaceSummaryManager.getNSSummary(parentObjectId);
        }
        if (nsSummary == null) {
            LOG.error("The namespace table is not correctly populated.");
            return;
        }
        nsSummary.removeChildDir(objectId);
        nsSummaryMap.put(parentObjectId, nsSummary);
    }

    protected boolean flushAndCommitNSToDB(Map<Long, NSSummary> nsSummaryMap) {
        try {
            this.writeNSSummariesToDB(nsSummaryMap);
            nsSummaryMap.clear();
        }
        catch (IOException e) {
            LOG.error("Unable to write Namespace Summary data in Recon DB.", (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean checkAndCallFlushToDB(Map<Long, NSSummary> nsSummaryMap) {
        if (null != nsSummaryMap && (long)nsSummaryMap.size() >= this.nsSummaryFlushToDBMaxThreshold) {
            return this.flushAndCommitNSToDB(nsSummaryMap);
        }
        return true;
    }
}

