/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;

@ConfigGroup(prefix="ozone.recon.task")
public class ReconTaskConfig {
    @Config(key="pipelinesync.interval", type=ConfigType.TIME, defaultValue="300s", tags={ConfigTag.RECON, ConfigTag.OZONE}, description="The time interval of periodic sync of pipeline state from SCM to Recon.")
    private Duration pipelineSyncTaskInterval = Duration.ofMinutes(5L);
    @Config(key="missingcontainer.interval", type=ConfigType.TIME, defaultValue="300s", tags={ConfigTag.RECON, ConfigTag.OZONE}, description="The time interval of the periodic check for unhealthy containers in the cluster as reported by Datanodes.")
    private Duration missingContainerTaskInterval = Duration.ofMinutes(5L);
    @Config(key="safemode.wait.threshold", type=ConfigType.TIME, defaultValue="300s", tags={ConfigTag.RECON, ConfigTag.OZONE}, description="The time interval to wait for starting container health task and pipeline sync task before recon exits out of safe or warmup mode. ")
    private Duration safeModeWaitThreshold = Duration.ofMinutes(5L);
    @Config(key="containercounttask.interval", type=ConfigType.TIME, defaultValue="60s", tags={ConfigTag.RECON, ConfigTag.OZONE}, description="The time interval to wait between each runs of container count task.")
    private Duration containerSizeCountTaskInterval = Duration.ofMinutes(1L);

    public Duration getPipelineSyncTaskInterval() {
        return this.pipelineSyncTaskInterval;
    }

    public void setPipelineSyncTaskInterval(Duration interval) {
        this.pipelineSyncTaskInterval = interval;
    }

    public Duration getMissingContainerTaskInterval() {
        return this.missingContainerTaskInterval;
    }

    public void setMissingContainerTaskInterval(Duration interval) {
        this.missingContainerTaskInterval = interval;
    }

    public Duration getSafeModeWaitThreshold() {
        return this.safeModeWaitThreshold;
    }

    public void setSafeModeWaitThreshold(Duration safeModeWaitThreshold) {
        this.safeModeWaitThreshold = safeModeWaitThreshold;
    }

    public Duration getContainerSizeCountTaskInterval() {
        return this.containerSizeCountTaskInterval;
    }

    public void setContainerSizeCountTaskInterval(Duration interval) {
        this.containerSizeCountTaskInterval = interval;
    }
}

