/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.ozone.erasurecode.ECChunk;
import org.apache.ozone.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.ozone.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.ozone.erasurecode.rawcoder.CoderUtil;

public abstract class RawErasureDecoder {
    private final ECReplicationConfig coderOptions;

    public RawErasureDecoder(ECReplicationConfig coderOptions) {
        this.coderOptions = coderOptions;
    }

    public synchronized void decode(ByteBuffer[] inputs, int[] erasedIndexes, ByteBuffer[] outputs) throws IOException {
        int i;
        ByteBufferDecodingState decodingState = new ByteBufferDecodingState(this, inputs, erasedIndexes, outputs);
        boolean usingDirectBuffer = decodingState.usingDirectBuffer;
        int dataLen = decodingState.decodeLength;
        if (dataLen == 0) {
            return;
        }
        int[] inputPositions = new int[inputs.length];
        for (i = 0; i < inputPositions.length; ++i) {
            if (inputs[i] == null) continue;
            inputPositions[i] = inputs[i].position();
        }
        if (usingDirectBuffer) {
            this.doDecode(decodingState);
        } else {
            ByteArrayDecodingState badState = decodingState.convertToByteArrayState();
            this.doDecode(badState);
        }
        for (i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            inputs[i].position(inputPositions[i] + dataLen);
        }
    }

    protected abstract void doDecode(ByteBufferDecodingState var1) throws IOException;

    public synchronized void decode(byte[][] inputs, int[] erasedIndexes, byte[][] outputs) throws IOException {
        ByteArrayDecodingState decodingState = new ByteArrayDecodingState(this, inputs, erasedIndexes, outputs);
        if (decodingState.decodeLength == 0) {
            return;
        }
        this.doDecode(decodingState);
    }

    protected abstract void doDecode(ByteArrayDecodingState var1) throws IOException;

    public synchronized void decode(ECChunk[] inputs, int[] erasedIndexes, ECChunk[] outputs) throws IOException {
        ByteBuffer[] newInputs = CoderUtil.toBuffers(inputs);
        ByteBuffer[] newOutputs = CoderUtil.toBuffers(outputs);
        this.decode(newInputs, erasedIndexes, newOutputs);
    }

    public int getNumDataUnits() {
        return this.coderOptions.getData();
    }

    public int getNumParityUnits() {
        return this.coderOptions.getParity();
    }

    protected int getNumAllUnits() {
        return this.coderOptions.getData() + this.coderOptions.getParity();
    }

    public boolean preferDirectBuffer() {
        return false;
    }

    public boolean allowChangeInputs() {
        return false;
    }

    public boolean allowVerboseDump() {
        return false;
    }

    public void release() {
    }
}

