/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.ContainerClientMetrics;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.StreamBufferArgs;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.scm.storage.CommitWatcher;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatisBlockOutputStream
extends BlockOutputStream
implements Syncable {
    public static final Logger LOG = LoggerFactory.getLogger(RatisBlockOutputStream.class);
    private final CommitWatcher commitWatcher;

    public RatisBlockOutputStream(BlockID blockID, XceiverClientFactory xceiverClientManager, Pipeline pipeline, BufferPool bufferPool, OzoneClientConfig config, Token<? extends TokenIdentifier> token, ContainerClientMetrics clientMetrics, StreamBufferArgs streamBufferArgs, Supplier<ExecutorService> blockOutputStreamResourceProvider) throws IOException {
        super(blockID, xceiverClientManager, pipeline, bufferPool, config, token, clientMetrics, streamBufferArgs, blockOutputStreamResourceProvider);
        this.commitWatcher = new CommitWatcher(bufferPool, this.getXceiverClient());
    }

    @Override
    public long getTotalAckDataLength() {
        return this.commitWatcher.getTotalAckDataLength();
    }

    @VisibleForTesting
    public Map<Long, List<ChunkBuffer>> getCommitIndex2flushedDataMap() {
        return this.commitWatcher.getCommitIndexMap();
    }

    @Override
    void releaseBuffersOnException() {
        this.commitWatcher.releaseBuffersOnException();
    }

    @Override
    XceiverClientReply sendWatchForCommit(boolean bufferFull) throws IOException {
        return bufferFull ? this.commitWatcher.watchOnFirstIndex() : this.commitWatcher.watchOnLastIndex();
    }

    @Override
    void updateCommitInfo(XceiverClientReply reply, List<ChunkBuffer> buffers) {
        this.commitWatcher.updateCommitInfoMap(reply.getLogIndex(), buffers);
    }

    @Override
    void putFlushFuture(long flushPos, CompletableFuture<ContainerProtos.ContainerCommandResponseProto> flushFuture) {
        this.commitWatcher.putFlushFuture(flushPos, flushFuture);
    }

    @Override
    void waitOnFlushFutures() throws InterruptedException, ExecutionException {
        this.commitWatcher.waitOnFlushFutures();
    }

    @Override
    void cleanup() {
        this.commitWatcher.cleanup();
    }

    public void hflush() throws IOException {
        this.hsync();
    }

    public void hsync() throws IOException {
        if (!this.isClosed()) {
            if (this.getBufferPool() != null && this.getBufferPool().getSize() > 0) {
                this.handleFlush(false);
            }
            this.waitForFlushAndCommit(false);
        }
    }
}

