/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.container.common.HDDSVolumeLayoutVersion;
import org.apache.hadoop.ozone.container.common.volume.DbVolume;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

public final class StorageVolumeUtil {
    private static final String VERSION_FILE = "VERSION";
    private static final String STORAGE_ID_PREFIX = "DS-";

    private StorageVolumeUtil() {
    }

    public static void onFailure(StorageVolume volume) {
        VolumeSet volumeSet;
        if (volume != null && (volumeSet = volume.getVolumeSet()) != null && volumeSet instanceof MutableVolumeSet) {
            ((MutableVolumeSet)volumeSet).checkVolumeAsync(volume);
        }
    }

    public static List<HddsVolume> getHddsVolumesList(List<StorageVolume> volumes) {
        return volumes.stream().map(v -> (HddsVolume)v).collect(Collectors.toList());
    }

    public static List<DbVolume> getDbVolumesList(List<StorageVolume> volumes) {
        return volumes.stream().map(v -> (DbVolume)v).collect(Collectors.toList());
    }

    public static File getVersionFile(File rootDir) {
        return new File(rootDir, VERSION_FILE);
    }

    public static String generateUuid() {
        return STORAGE_ID_PREFIX + UUID.randomUUID();
    }

    @VisibleForTesting
    public static String getStorageID(Properties props, File versionFile) throws InconsistentStorageStateException {
        return StorageVolumeUtil.getProperty(props, "storageID", versionFile);
    }

    @VisibleForTesting
    public static String getClusterID(Properties props, File versionFile, String clusterID) throws InconsistentStorageStateException {
        String cid = StorageVolumeUtil.getProperty(props, "clusterID", versionFile);
        if (clusterID == null) {
            return cid;
        }
        if (!clusterID.equals(cid)) {
            throw new InconsistentStorageStateException("Mismatched ClusterIDs. Version File : " + versionFile + " has clusterID: " + cid + " and Datanode has clusterID: " + clusterID);
        }
        return cid;
    }

    @VisibleForTesting
    public static String getDatanodeUUID(Properties props, File versionFile, String datanodeUuid) throws InconsistentStorageStateException {
        String datanodeID = StorageVolumeUtil.getProperty(props, "datanodeUuid", versionFile);
        if (datanodeUuid != null && !datanodeUuid.equals(datanodeID)) {
            throw new InconsistentStorageStateException("Mismatched DatanodeUUIDs. Version File : " + versionFile + " has datanodeUuid: " + datanodeID + " and Datanode has datanodeUuid: " + datanodeUuid);
        }
        return datanodeID;
    }

    @VisibleForTesting
    public static long getCreationTime(Properties props, File versionFile) throws InconsistentStorageStateException {
        long currentTime;
        String cTimeStr = StorageVolumeUtil.getProperty(props, "ctime", versionFile);
        long cTime = Long.parseLong(cTimeStr);
        if (cTime > (currentTime = Time.now()) || cTime < 0L) {
            throw new InconsistentStorageStateException("Invalid Creation time in Version File : " + versionFile + " - " + cTime + ". Current system time is " + currentTime);
        }
        return cTime;
    }

    @VisibleForTesting
    public static int getLayOutVersion(Properties props, File versionFile) throws InconsistentStorageStateException {
        String lvStr = StorageVolumeUtil.getProperty(props, "layOutVersion", versionFile);
        int lv = Integer.parseInt(lvStr);
        if (HDDSVolumeLayoutVersion.getLatestVersion().getVersion() != lv) {
            throw new InconsistentStorageStateException("Invalid layOutVersion. Version file has layOutVersion as " + lv + " and latest Datanode layOutVersion is " + HDDSVolumeLayoutVersion.getLatestVersion().getVersion());
        }
        return lv;
    }

    public static String getProperty(Properties props, String propName, File versionFile) throws InconsistentStorageStateException {
        String value = props.getProperty(propName);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new InconsistentStorageStateException("Invalid " + propName + ". Version File : " + versionFile + " has null or empty " + propName);
        }
        return value;
    }

    public static boolean checkVolume(StorageVolume volume, String scmId, String clusterId, ConfigurationSource conf, Logger logger, MutableVolumeSet dbVolumeSet) {
        File volumeRoot = volume.getStorageDir();
        String volumeRootPath = volumeRoot.getPath();
        File clusterIDDir = new File(volumeRoot, clusterId);
        try {
            volume.format(clusterId);
        }
        catch (IOException ex) {
            logger.error("Error during formatting volume {}.", (Object)volumeRootPath, (Object)ex);
            return false;
        }
        File[] rootFiles = volumeRoot.listFiles();
        String workingDirName = clusterId;
        boolean success = true;
        if (rootFiles == null) {
            success = false;
        } else if (rootFiles.length == 1) {
            workingDirName = VersionedDatanodeFeatures.ScmHA.chooseContainerPathID(conf, scmId, clusterId);
            try {
                volume.createWorkingDir(workingDirName, dbVolumeSet);
            }
            catch (IOException e) {
                logger.error("Prepare working dir failed for volume {}.", (Object)volumeRootPath, (Object)e);
                success = false;
            }
        } else if (rootFiles.length == 2) {
            success = VersionedDatanodeFeatures.ScmHA.upgradeVolumeIfNeeded(volume, clusterId);
            try {
                workingDirName = VersionedDatanodeFeatures.ScmHA.chooseContainerPathID(volume, clusterId);
            }
            catch (IOException ex) {
                success = false;
            }
        } else if (clusterIDDir.exists()) {
            workingDirName = clusterId;
        } else {
            logger.error("Volume {} is in an inconsistent state. {} files found but cluster ID directory {} does not exist.", new Object[]{volumeRootPath, rootFiles.length, clusterIDDir});
            success = false;
        }
        if (success) {
            try {
                volume.createTmpDirs(workingDirName);
            }
            catch (IOException e) {
                logger.error("Prepare tmp dir failed for volume {}.", (Object)volumeRootPath, (Object)e);
                success = false;
            }
        }
        return success;
    }
}

