/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeInfo;

@Metrics(about="Ozone Volume Information Metrics", context="ozone")
public class VolumeInfoMetrics {
    private String metricsSourceName = VolumeInfoMetrics.class.getSimpleName();
    private String volumeRootStr;
    private HddsVolume volume;

    public VolumeInfoMetrics(String identifier, HddsVolume ref) {
        this.metricsSourceName = this.metricsSourceName + '-' + identifier;
        this.volumeRootStr = identifier;
        this.volume = ref;
        this.init();
    }

    public void init() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.register(this.metricsSourceName, "Volume Info Statistics", (Object)this);
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.metricsSourceName);
    }

    @Metric(value={"Metric to return the Storage Type"})
    public String getStorageType() {
        return this.volume.getStorageType().toString();
    }

    @Metric(value={"Returns the Directory name for the volume"})
    public String getStorageDirectory() {
        return this.volume.getStorageDir().toString();
    }

    @Metric(value={"Return the DataNode UID for the respective volume"})
    public String getDatanodeUuid() {
        return this.volume.getDatanodeUuid();
    }

    @Metric(value={"Return the Layout Version for the volume"})
    public int getLayoutVersion() {
        return this.volume.getLayoutVersion();
    }

    @Metric(value={"Returns the Volume State"})
    public String getVolumeState() {
        return this.volume.getStorageState().name();
    }

    @Metric(value={"Returns the Volume Type"})
    public String getVolumeType() {
        return this.volume.getType().name();
    }

    public String getMetricsSourceName() {
        return this.metricsSourceName;
    }

    @Metric(value={"Returns the Used space"})
    public long getUsed() {
        return this.volume.getVolumeInfo().map(VolumeInfo::getScmUsed).orElse(0L);
    }

    @Metric(value={"Returns the Available space"})
    public long getAvailable() {
        return this.volume.getVolumeInfo().map(VolumeInfo::getAvailable).orElse(0L);
    }

    @Metric(value={"Fetches the Reserved Space"})
    public long getReserved() {
        return this.volume.getVolumeInfo().map(VolumeInfo::getReservedInBytes).orElse(0L);
    }

    @Metric(value={"Returns the Capacity of the Volume"})
    public long getCapacity() {
        return this.getUsed() + this.getAvailable();
    }

    @Metric(value={"Returns the Total Capacity of the Volume"})
    public long getTotalCapacity() {
        return this.getUsed() + this.getAvailable() + this.getReserved();
    }

    @Metric(value={"Returns the Committed bytes of the Volume"})
    public long getCommitted() {
        return this.volume.getCommittedBytes();
    }
}

