/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.upgrade;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.upgrade.ScmHAFinalizeUpgradeActionDatanode;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;

public final class VersionedDatanodeFeatures {
    private static HDDSLayoutVersionManager versionManager;

    private VersionedDatanodeFeatures() {
    }

    public static void initialize(HDDSLayoutVersionManager manager) {
        versionManager = manager;
    }

    public static boolean isFinalized(HDDSLayoutFeature layoutFeature) {
        return versionManager == null || versionManager.isAllowed((LayoutFeature)layoutFeature);
    }

    public static class SchemaV3 {
        public static String chooseSchemaVersion(ConfigurationSource conf) {
            if (SchemaV3.isFinalizedAndEnabled(conf)) {
                return "3";
            }
            return SchemaV2.chooseSchemaVersion();
        }

        public static boolean isFinalizedAndEnabled(ConfigurationSource conf) {
            DatanodeConfiguration dcf = (DatanodeConfiguration)((Object)conf.getObject(DatanodeConfiguration.class));
            return VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.DATANODE_SCHEMA_V3) && dcf.getContainerSchemaV3Enabled();
        }
    }

    public static class ScmHA {
        public static String chooseContainerPathID(StorageVolume volume, String clusterID) throws IOException {
            File clusterIDDir = new File(volume.getStorageDir(), clusterID);
            if (VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.SCM_HA) || clusterIDDir.exists()) {
                return clusterID;
            }
            File[] subdirs = volume.getStorageDir().listFiles(File::isDirectory);
            if (subdirs == null) {
                throw new IOException("Failed to read volume " + volume.getStorageDir());
            }
            if (subdirs.length != 1) {
                throw new IOException("Invalid volume directory " + volume.getStorageDir() + " has more than one directory before SCM HA finalization.");
            }
            return subdirs[0].getName();
        }

        public static String chooseContainerPathID(ConfigurationSource conf, String scmID, String clusterID) {
            boolean scmHAEnabled = conf.getBoolean("ozone.scm.ratis.enable", true);
            if (VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.SCM_HA) || scmHAEnabled) {
                return clusterID;
            }
            return scmID;
        }

        public static boolean upgradeVolumeIfNeeded(StorageVolume volume, String clusterID) {
            File clusterIDDir = new File(volume.getStorageDir(), clusterID);
            boolean needsUpgrade = VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.SCM_HA) && !clusterIDDir.exists();
            boolean success = true;
            if (needsUpgrade) {
                success = ScmHAFinalizeUpgradeActionDatanode.upgradeVolume(volume, clusterID);
            }
            return success;
        }
    }

    public static class SchemaV2 {
        public static String chooseSchemaVersion() {
            if (VersionedDatanodeFeatures.isFinalized(HDDSLayoutFeature.DATANODE_SCHEMA_V2)) {
                return "2";
            }
            return "1";
        }
    }
}

