/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class DeleteContainerCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto> {
    private final long containerId;
    private final boolean force;
    private int replicaIndex = 0;

    public DeleteContainerCommand(long containerId) {
        this(containerId, false);
    }

    public DeleteContainerCommand(long containerId, boolean forceFlag) {
        this.containerId = containerId;
        this.force = forceFlag;
    }

    public DeleteContainerCommand(ContainerID containerID, boolean forceFlag) {
        this.containerId = containerID.getId();
        this.force = forceFlag;
    }

    public void setReplicaIndex(int index) {
        this.replicaIndex = index;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto getProto() {
        StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto.Builder builder = StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto.newBuilder();
        builder.setCmdId(this.getId()).setContainerID(this.getContainerID()).setForce(this.force);
        builder.setReplicaIndex(this.replicaIndex);
        return builder.build();
    }

    public long getContainerID() {
        return this.containerId;
    }

    public boolean isForce() {
        return this.force;
    }

    public static DeleteContainerCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.DeleteContainerCommandProto protoMessage) {
        Preconditions.checkNotNull((Object)protoMessage);
        DeleteContainerCommand cmd = new DeleteContainerCommand(protoMessage.getContainerID(), protoMessage.getForce());
        if (protoMessage.hasReplicaIndex()) {
            cmd.setReplicaIndex(protoMessage.getReplicaIndex());
        }
        return cmd;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType()).append(": containerID: ").append(this.getContainerID()).append(", replicaIndex: ").append(this.getReplicaIndex()).append(", force: ").append(this.force);
        return sb.toString();
    }
}

